/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;

public class PropertyDelegate
extends ItemDelegate {
    private final Tree parent;
    @Nonnull
    private final String name;
    @CheckForNull
    private PropertyState state;

    PropertyDelegate(SessionDelegate sessionDelegate, Tree parent, String name) {
        super(sessionDelegate);
        this.parent = Preconditions.checkNotNull(parent);
        this.name = Preconditions.checkNotNull(name);
        this.state = parent.getProperty(name);
    }

    @Override
    protected void update() {
        this.state = this.parent.getProperty(this.name);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getPath() {
        return PathUtils.concat(this.parent.getPath(), this.name);
    }

    @Override
    @CheckForNull
    public NodeDelegate getParent() {
        return this.parent.exists() ? new NodeDelegate(this.sessionDelegate, this.parent) : null;
    }

    @Override
    public boolean exists() {
        return this.state != null;
    }

    @Override
    @CheckForNull
    public Tree.Status getStatus() {
        return this.parent.getPropertyStatus(this.name);
    }

    @Override
    public boolean isProtected() throws InvalidItemStateException {
        return this.getParent().isProtected(this.name);
    }

    @Nonnull
    public PropertyState getPropertyState() throws InvalidItemStateException {
        if (this.state != null) {
            return this.state;
        }
        throw new InvalidItemStateException("The " + this.name + " property does not exist");
    }

    @Nonnull
    public PropertyState getSingleState() throws InvalidItemStateException, ValueFormatException {
        PropertyState p = this.getPropertyState();
        if (p.isArray()) {
            throw new ValueFormatException(p + " is multi-valued.");
        }
        return p;
    }

    public boolean getBoolean() throws ValueFormatException, InvalidItemStateException {
        return this.getSingleState().getValue(Type.BOOLEAN);
    }

    public String getString() throws ValueFormatException, InvalidItemStateException {
        return this.getSingleState().getValue(Type.STRING);
    }

    public String getDate() throws ValueFormatException, InvalidItemStateException {
        return this.getSingleState().getValue(Type.DATE);
    }

    @Nonnull
    public PropertyState getMultiState() throws InvalidItemStateException, ValueFormatException {
        PropertyState p = this.getPropertyState();
        if (!p.isArray()) {
            throw new ValueFormatException(p + " is single-valued.");
        }
        return p;
    }

    public void setState(@Nonnull PropertyState propertyState) {
        this.parent.setProperty(propertyState);
    }

    @Override
    public boolean remove() {
        if (this.parent.hasProperty(this.name)) {
            this.parent.removeProperty(this.name);
            return true;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("parent", this.parent).add("property", this.parent.getProperty(this.name)).toString();
    }
}

