/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;

public class EventFactory {
    public static final String USER_DATA = "user-data";
    private final NamePathMapper mapper;
    private final String userID;
    private final String userData;
    private final long date;
    private final boolean external;

    EventFactory(NamePathMapper mapper, CommitInfo commitInfo) {
        this.mapper = mapper;
        if (commitInfo != null) {
            this.userID = commitInfo.getUserId();
            Object userData = commitInfo.getInfo().get(USER_DATA);
            this.userData = userData instanceof String ? (String)userData : null;
            this.date = commitInfo.getDate();
            this.external = false;
        } else {
            this.userID = "oak:unknown";
            this.userData = null;
            this.date = System.currentTimeMillis();
            this.external = true;
        }
    }

    Event propertyAdded(final PropertyState after, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            @Override
            public int getType() {
                return 4;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).put("afterValue", EventFactory.this.createValue(after)).build();
            }
        };
    }

    Event propertyChanged(final PropertyState before, final PropertyState after, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            @Override
            public int getType() {
                return 16;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).put("beforeValue", EventFactory.this.createValue(before)).put("afterValue", EventFactory.this.createValue(after)).build();
            }
        };
    }

    Event propertyDeleted(final PropertyState before, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            @Override
            public int getType() {
                return 8;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).put("beforeValue", EventFactory.this.createValue(before)).build();
            }
        };
    }

    private Object createValue(PropertyState property) {
        if (property.isArray()) {
            List<Value> values = ValueFactoryImpl.createValues(property, this.mapper);
            return values.toArray(new Value[values.size()]);
        }
        return ValueFactoryImpl.createValue(property, this.mapper);
    }

    Event nodeAdded(final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            @Override
            public int getType() {
                return 1;
            }

            @Override
            public Map<?, ?> getInfo() {
                return EventFactory.this.createInfoMap(primaryType, mixinTypes);
            }
        };
    }

    Event nodeDeleted(final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            @Override
            public int getType() {
                return 2;
            }

            @Override
            public Map<?, ?> getInfo() {
                return EventFactory.this.createInfoMap(primaryType, mixinTypes);
            }
        };
    }

    Event nodeMoved(final String primaryType, final Iterable<String> mixinTypes, String parent, String name, String identifier, final String sourcePath) {
        return new EventImpl(parent, name, identifier){

            @Override
            public int getType() {
                return 32;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().put("srcAbsPath", EventFactory.this.mapper.getJcrPath(sourcePath)).put("destAbsPath", this.getPath()).putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).build();
            }
        };
    }

    Event nodeReordered(final String primaryType, final Iterable<String> mixinTypes, String parent, String name, String identifier, final String destName) {
        return new EventImpl(parent, name, identifier){

            @Override
            public int getType() {
                return 32;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().put("srcChildRelPath", EventFactory.this.mapper.getJcrName(this.name)).put("destChildRelPath", EventFactory.this.mapper.getJcrName(destName)).putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).build();
            }
        };
    }

    private Map<String, ?> createInfoMap(String primaryType, Iterable<String> mixinTypes) {
        if (Iterables.isEmpty(mixinTypes)) {
            return ImmutableMap.of("jcr:primaryType", this.mapper.getJcrName(primaryType));
        }
        ArrayList<String> jcrNames = Lists.newArrayList();
        for (String name : mixinTypes) {
            jcrNames.add(this.mapper.getJcrName(name));
        }
        return ImmutableMap.of("jcr:primaryType", this.mapper.getJcrName(primaryType), "jcr:mixinTypes", Iterables.toArray(jcrNames, String.class));
    }

    private abstract class EventImpl
    implements JackrabbitEvent {
        private final String parent;
        protected final String name;
        private final String identifier;

        EventImpl(String parent, String name, String identifier) {
            this.parent = parent;
            this.name = name;
            this.identifier = identifier;
        }

        @Override
        public String getPath() {
            return PathUtils.concat(EventFactory.this.mapper.getJcrPath(this.parent), EventFactory.this.mapper.getJcrName(this.name));
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public Map<?, ?> getInfo() {
            return Collections.emptyMap();
        }

        @Override
        public String getUserID() {
            return EventFactory.this.userID;
        }

        @Override
        public String getUserData() {
            return EventFactory.this.userData;
        }

        @Override
        public long getDate() {
            return EventFactory.this.date;
        }

        @Override
        public boolean isExternal() {
            return EventFactory.this.external;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof EventImpl) {
                EventImpl that = (EventImpl)object;
                return this.getType() == that.getType() && this.getPath().equals(that.getPath()) && this.getIdentifier().equals(that.getIdentifier()) && this.getInfo().equals(that.getInfo()) && Objects.equal(this.getUserID(), that.getUserID()) && Objects.equal(this.getUserData(), that.getUserData()) && this.getDate() == that.getDate() && this.isExternal() == that.isExternal();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.getType(), this.getPath(), this.getIdentifier(), this.getInfo(), this.getUserID(), this.getUserData(), this.getDate(), this.isExternal());
        }

        public String toString() {
            return Objects.toStringHelper("Event").add("type", this.getType()).add("path", this.getPath()).add("identifier", this.getIdentifier()).add("info", this.getInfo()).add("userID", this.getUserID()).add("userData", this.getUserData()).add("date", this.getDate()).add("external", this.isExternal()).toString();
        }
    }
}

