/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.security;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;

public class AccessManager {
    private final SessionDelegate delegate;
    private final PermissionProvider permissionProvider;

    public AccessManager(SessionDelegate delegate, PermissionProvider permissionProvider) {
        this.delegate = delegate;
        this.permissionProvider = permissionProvider;
    }

    public boolean hasPermissions(final @Nonnull String oakPath, final @Nonnull String actions) {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPermissions"){

            @Override
            @Nonnull
            public Boolean perform() {
                return AccessManager.this.permissionProvider.isGranted(oakPath, actions);
            }
        });
    }

    public boolean hasPermissions(final @Nonnull Tree tree, final @Nullable PropertyState property, final long permissions) throws RepositoryException {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPermissions"){

            @Override
            @Nonnull
            public Boolean perform() {
                return AccessManager.this.permissionProvider.isGranted(tree, property, permissions);
            }
        });
    }

    public void checkPermissions(@Nonnull String oakPath, @Nonnull String actions) throws RepositoryException {
        if (!this.hasPermissions(oakPath, actions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }

    public void checkPermissions(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) throws RepositoryException {
        if (!this.hasPermissions(tree, property, permissions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }
}

