/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.jcr.delegate.AccessControlManagerDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.JackrabbitAccessControlManagerDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PrincipalManagerDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.PrivilegeManagerDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.UserManagerDelegator;
import org.apache.jackrabbit.oak.jcr.observation.ObservationManagerImpl;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.SessionImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionNamespaces;
import org.apache.jackrabbit.oak.jcr.session.SessionStats;
import org.apache.jackrabbit.oak.jcr.session.WorkspaceImpl;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapperImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticManager;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionContext
implements NamePathMapper {
    private static final Logger log = LoggerFactory.getLogger(SessionContext.class);
    private final Repository repository;
    private final StatisticManager statisticManager;
    private final SecurityProvider securityProvider;
    private final Whiteboard whiteboard;
    private final Map<String, Object> attributes;
    private final SessionDelegate delegate;
    private final int observationQueueLength;
    private final CommitRateLimiter commitRateLimiter;
    private final NamePathMapper namePathMapper;
    private final ValueFactory valueFactory;
    private SessionImpl session = null;
    private WorkspaceImpl workspace = null;
    private AccessControlManager accessControlManager;
    private AccessManager accessManager;
    private PrincipalManager principalManager;
    private UserManager userManager;
    private PrivilegeManager privilegeManager;
    private ObservationManagerImpl observationManager;
    private final Set<String> openScopedLocks = Sets.newTreeSet();
    private final Set<String> sessionScopedLocks = Sets.newHashSet();
    private final boolean fastQueryResultSize;

    public SessionContext(@Nonnull Repository repository, @Nonnull StatisticManager statisticManager, @Nonnull SecurityProvider securityProvider, @Nonnull Whiteboard whiteboard, @Nonnull Map<String, Object> attributes, @Nonnull SessionDelegate delegate, int observationQueueLength, CommitRateLimiter commitRateLimiter) {
        this(repository, statisticManager, securityProvider, whiteboard, attributes, delegate, observationQueueLength, commitRateLimiter, false);
    }

    public SessionContext(@Nonnull Repository repository, @Nonnull StatisticManager statisticManager, @Nonnull SecurityProvider securityProvider, @Nonnull Whiteboard whiteboard, @Nonnull Map<String, Object> attributes, @Nonnull SessionDelegate delegate, int observationQueueLength, CommitRateLimiter commitRateLimiter, boolean fastQueryResultSize) {
        this.repository = Preconditions.checkNotNull(repository);
        this.statisticManager = statisticManager;
        this.securityProvider = Preconditions.checkNotNull(securityProvider);
        this.whiteboard = Preconditions.checkNotNull(whiteboard);
        this.attributes = Preconditions.checkNotNull(attributes);
        this.delegate = Preconditions.checkNotNull(delegate);
        this.observationQueueLength = observationQueueLength;
        this.commitRateLimiter = commitRateLimiter;
        SessionStats sessionStats = delegate.getSessionStats();
        sessionStats.setAttributes(attributes);
        this.namePathMapper = new NamePathMapperImpl(delegate.getNamespaces(), delegate.getIdManager());
        this.valueFactory = new ValueFactoryImpl(delegate.getRoot(), this.namePathMapper);
        this.fastQueryResultSize = fastQueryResultSize;
    }

    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final synchronized SessionImpl getSession() {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public final synchronized WorkspaceImpl getWorkspace() {
        if (this.workspace == null) {
            this.workspace = this.createWorkspace();
        }
        return this.workspace;
    }

    protected SessionImpl createSession() {
        return new SessionImpl(this);
    }

    protected WorkspaceImpl createWorkspace() {
        return new WorkspaceImpl(this);
    }

    @Nonnull
    public StatisticManager getStatisticManager() {
        return this.statisticManager;
    }

    @Nonnull
    public MeterStats getMeter(RepositoryStatistics.Type type) {
        return this.statisticManager.getMeter(type);
    }

    @Nonnull
    public TimerStats getTimer(RepositoryStatistics.Type type) {
        return this.statisticManager.getTimer(type);
    }

    @Nonnull
    public CounterStats getCount(RepositoryStatistics.Type type) {
        return this.statisticManager.getStatsCounter(type);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public SessionDelegate getSessionDelegate() {
        return this.delegate;
    }

    SessionNamespaces getNamespaces() {
        return this.delegate.getNamespaces();
    }

    @Override
    @Nonnull
    public Map<String, String> getSessionLocalMappings() {
        return this.getNamespaces().getSessionLocalMappings();
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Nonnull
    public AccessControlManager getAccessControlManager() throws RepositoryException {
        if (this.accessControlManager == null) {
            AccessControlManager acm = this.getConfig(AuthorizationConfiguration.class).getAccessControlManager(this.delegate.getRoot(), this.namePathMapper);
            this.accessControlManager = acm instanceof JackrabbitAccessControlManager ? new JackrabbitAccessControlManagerDelegator(this.delegate, (JackrabbitAccessControlManager)acm) : new AccessControlManagerDelegator(this.delegate, acm);
        }
        return this.accessControlManager;
    }

    @Nonnull
    public PrincipalManager getPrincipalManager() {
        if (this.principalManager == null) {
            this.principalManager = new PrincipalManagerDelegator(this.delegate, this.getConfig(PrincipalConfiguration.class).getPrincipalManager(this.delegate.getRoot(), this.namePathMapper));
        }
        return this.principalManager;
    }

    @Nonnull
    public UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = new UserManagerDelegator(this.delegate, this.getConfig(UserConfiguration.class).getUserManager(this.delegate.getRoot(), this.namePathMapper));
        }
        return this.userManager;
    }

    @Nonnull
    public PrivilegeManager getPrivilegeManager() {
        if (this.privilegeManager == null) {
            this.privilegeManager = new PrivilegeManagerDelegator(this.delegate, this.getConfig(PrivilegeConfiguration.class).getPrivilegeManager(this.delegate.getRoot(), this.namePathMapper));
        }
        return this.privilegeManager;
    }

    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        ArrayList<ProtectedItemImporter> importers = new ArrayList<ProtectedItemImporter>();
        for (SecurityConfiguration securityConfiguration : this.securityProvider.getConfigurations()) {
            importers.addAll(securityConfiguration.getProtectedItemImporters());
        }
        return importers;
    }

    @Nonnull
    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException {
        if (this.observationManager == null) {
            this.observationManager = new ObservationManagerImpl(this, ReadOnlyNodeTypeManager.getInstance(this.delegate.getRoot(), this.namePathMapper), this.whiteboard, this.observationQueueLength, this.commitRateLimiter);
        }
        return this.observationManager;
    }

    public Set<String> getOpenScopedLocks() {
        return this.openScopedLocks;
    }

    public Set<String> getSessionScopedLocks() {
        return this.sessionScopedLocks;
    }

    public boolean getFastQueryResultSize() {
        if (System.getProperty("oak.fastQuerySize") != null) {
            return Boolean.getBoolean("oak.fastQuerySize");
        }
        return this.fastQueryResultSize;
    }

    @Override
    @Nonnull
    public String getOakName(@Nonnull String jcrName) throws RepositoryException {
        return this.namePathMapper.getOakName(jcrName);
    }

    @Override
    @CheckForNull
    public String getOakNameOrNull(@Nonnull String jcrName) {
        return this.namePathMapper.getOakNameOrNull(jcrName);
    }

    @Override
    @Nonnull
    public String getJcrName(@Nonnull String oakName) {
        return this.namePathMapper.getJcrName(oakName);
    }

    @Override
    @CheckForNull
    public String getOakPath(String jcrPath) {
        return this.namePathMapper.getOakPath(jcrPath);
    }

    @Override
    @Nonnull
    public String getJcrPath(String oakPath) {
        return this.namePathMapper.getJcrPath(oakPath);
    }

    @Nonnull
    public String getOakPathOrThrow(String jcrPath) throws RepositoryException {
        String oakPath = this.getOakPath(jcrPath);
        if (oakPath != null) {
            return oakPath;
        }
        throw new RepositoryException("Invalid name or path: " + jcrPath);
    }

    @Nonnull
    public String getOakPathOrThrowNotFound(String jcrPath) throws PathNotFoundException {
        String oakPath = this.getOakPath(jcrPath);
        if (oakPath != null) {
            return oakPath;
        }
        throw new PathNotFoundException(jcrPath);
    }

    @Nonnull
    public AccessManager getAccessManager() throws RepositoryException {
        if (this.accessManager == null) {
            this.accessManager = new AccessManager(this.delegate, this.delegate.getPermissionProvider());
        }
        return this.accessManager;
    }

    @Nonnull
    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    void dispose() {
        try {
            this.unlockAllSessionScopedLocks();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected repository error", e);
        }
        if (this.observationManager != null) {
            this.observationManager.dispose();
        }
        this.getNamespaces().clear();
    }

    private void unlockAllSessionScopedLocks() throws RepositoryException {
        this.delegate.performVoid(new SessionOperation<Void>("unlockAllSessionScopedLocks"){

            @Override
            public void performVoid() {
                Iterator iterator = SessionContext.this.sessionScopedLocks.iterator();
                while (iterator.hasNext()) {
                    NodeDelegate node = SessionContext.this.delegate.getNode((String)iterator.next());
                    if (node != null) {
                        try {
                            node.unlock();
                        }
                        catch (RepositoryException e) {
                            log.warn("Failed to unlock a session scoped lock", e);
                        }
                    }
                    iterator.remove();
                }
            }
        });
    }

    @Nonnull
    private <T> T getConfig(Class<T> clss) {
        return this.securityProvider.getConfiguration(clss);
    }
}

