/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.version.VersionStorage;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.ISO8601;

public class ReadWriteVersionManager
extends ReadOnlyVersionManager {
    private final SessionDelegate sessionDelegate;
    private final VersionStorage versionStorage;

    public ReadWriteVersionManager(@Nonnull SessionDelegate sessionDelegate) {
        this.sessionDelegate = sessionDelegate;
        this.versionStorage = new VersionStorage(sessionDelegate.getRoot());
    }

    protected void refresh() throws RepositoryException {
        this.sessionDelegate.refresh(true);
    }

    @Override
    @Nonnull
    protected Tree getVersionStorage() {
        return this.versionStorage.getTree();
    }

    @Override
    @Nonnull
    protected Root getWorkspaceRoot() {
        return this.sessionDelegate.getRoot();
    }

    @Override
    @Nonnull
    protected ReadOnlyNodeTypeManager getNodeTypeManager() {
        return ReadOnlyNodeTypeManager.getInstance(this.sessionDelegate.getRoot(), NamePathMapper.DEFAULT);
    }

    @Nonnull
    public Tree checkin(@Nonnull Tree versionable) throws RepositoryException, InvalidItemStateException, UnsupportedRepositoryOperationException {
        if (this.sessionDelegate.hasPendingChanges()) {
            throw new InvalidItemStateException("Unable to perform checkin. Session has pending changes.");
        }
        if (!this.isVersionable(versionable)) {
            throw new UnsupportedRepositoryOperationException(versionable.getPath() + " is not versionable");
        }
        if (this.isCheckedOut(versionable)) {
            Tree baseVersion = this.getExistingBaseVersion(versionable);
            versionable.setProperty("jcr:isCheckedOut", Boolean.FALSE, Type.BOOLEAN);
            PropertyState created = baseVersion.getProperty("jcr:created");
            if (created != null) {
                long c = ISO8601.parse(created.getValue(Type.DATE)).getTimeInMillis();
                while (System.currentTimeMillis() == c) {
                }
            }
            try {
                this.sessionDelegate.commit();
                this.refresh();
            }
            catch (CommitFailedException e) {
                this.sessionDelegate.refresh(true);
                throw e.asRepositoryException();
            }
        }
        return this.getExistingBaseVersion(this.getWorkspaceRoot().getTree(versionable.getPath()));
    }

    public void checkout(@Nonnull Root workspaceRoot, @Nonnull String versionablePath) throws UnsupportedRepositoryOperationException, InvalidItemStateException, RepositoryException {
        Preconditions.checkState(!workspaceRoot.hasPendingChanges());
        Preconditions.checkArgument(PathUtils.isAbsolute(versionablePath));
        Tree versionable = workspaceRoot.getTree(versionablePath);
        if (!this.isVersionable(versionable)) {
            throw new UnsupportedRepositoryOperationException(versionable.getPath() + " is not versionable");
        }
        if (!this.isCheckedOut(versionable)) {
            versionable.setProperty("jcr:isCheckedOut", Boolean.TRUE, Type.BOOLEAN);
            try {
                workspaceRoot.commit();
                this.refresh();
            }
            catch (CommitFailedException e) {
                workspaceRoot.refresh();
                throw e.asRepositoryException();
            }
        }
    }

    public void addVersionLabel(@Nonnull VersionStorage versionStorage, @Nonnull String versionHistoryOakRelPath, @Nonnull String versionIdentifier, @Nonnull String oakVersionLabel, boolean moveLabel) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree(Preconditions.checkNotNull(versionStorage.getTree()), Preconditions.checkNotNull(versionHistoryOakRelPath));
        Tree labels = Preconditions.checkNotNull(versionHistory).getChild("jcr:versionLabels");
        PropertyState existing = labels.getProperty(Preconditions.checkNotNull(oakVersionLabel));
        if (existing != null) {
            if (moveLabel) {
                labels.removeProperty(existing.getName());
            } else {
                throw new LabelExistsVersionException("Version label '" + oakVersionLabel + "' already exists on this version history");
            }
        }
        labels.setProperty(oakVersionLabel, versionIdentifier, Type.REFERENCE);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    public void removeVersionLabel(@Nonnull VersionStorage versionStorage, @Nonnull String versionHistoryOakRelPath, @Nonnull String oakVersionLabel) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree(Preconditions.checkNotNull(versionStorage.getTree()), Preconditions.checkNotNull(versionHistoryOakRelPath));
        Tree labels = Preconditions.checkNotNull(versionHistory).getChild("jcr:versionLabels");
        if (!labels.hasProperty(oakVersionLabel)) {
            throw new VersionException("Version label " + oakVersionLabel + " does not exist on this version history");
        }
        labels.removeProperty(oakVersionLabel);
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    public void removeVersion(@Nonnull VersionStorage versionStorage, @Nonnull String versionHistoryOakRelPath, @Nonnull String oakVersionName) throws RepositoryException {
        Tree versionHistory = TreeUtil.getTree(versionStorage.getTree(), versionHistoryOakRelPath);
        if (versionHistory == null || !versionHistory.exists()) {
            throw new VersionException("Version history " + versionHistoryOakRelPath + " does not exist on this version storage");
        }
        Tree version = versionHistory.getChild(oakVersionName);
        if (!version.exists()) {
            throw new VersionException("Version " + oakVersionName + " does not exist on this version history");
        }
        version.remove();
        try {
            this.sessionDelegate.commit(versionStorage.getRoot());
            this.refresh();
        }
        catch (CommitFailedException e) {
            versionStorage.refresh();
            throw e.asRepositoryException();
        }
    }

    @Nonnull
    private Tree getExistingBaseVersion(@Nonnull Tree versionableTree) throws RepositoryException {
        Tree baseVersion = this.getBaseVersion(versionableTree);
        if (baseVersion == null) {
            throw new IllegalStateException("Base version does not exist.");
        }
        return baseVersion;
    }
}

