/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.NodeIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.commons.iterator.FrozenNodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.VersionIteratorAdapter;
import org.apache.jackrabbit.oak.jcr.delegate.VersionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionHistoryDelegate;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionImpl;

public class VersionHistoryImpl
extends NodeImpl<VersionHistoryDelegate>
implements VersionHistory {
    public VersionHistoryImpl(VersionHistoryDelegate dlg, SessionContext sessionContext) {
        super(dlg, sessionContext);
    }

    @Override
    public String getVersionableUUID() throws RepositoryException {
        return this.getVersionableIdentifier();
    }

    @Override
    public String getVersionableIdentifier() throws RepositoryException {
        return this.perform(new SessionOperation<String>("getVersionableIdentifier"){

            @Override
            @Nonnull
            public String perform() throws RepositoryException {
                return ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getVersionableIdentifier();
            }
        });
    }

    @Override
    public Version getRootVersion() throws RepositoryException {
        return this.perform(new SessionOperation<Version>("getRootVersion"){

            @Override
            @Nonnull
            public Version perform() throws RepositoryException {
                return new VersionImpl(((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getRootVersion(), VersionHistoryImpl.this.sessionContext);
            }
        });
    }

    @Override
    public VersionIterator getAllLinearVersions() throws RepositoryException {
        return this.perform(new SessionOperation<VersionIterator>("getAllLinearVersions"){

            @Override
            @Nonnull
            public VersionIterator perform() throws RepositoryException {
                Iterator<Version> versions = Iterators.transform(((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getAllLinearVersions(), new Function<VersionDelegate, Version>(){

                    @Override
                    public Version apply(VersionDelegate input) {
                        return new VersionImpl(input, VersionHistoryImpl.this.sessionContext);
                    }
                });
                return new VersionIteratorAdapter(VersionHistoryImpl.this.sessionDelegate.sync(versions));
            }
        });
    }

    @Override
    public VersionIterator getAllVersions() throws RepositoryException {
        return this.perform(new SessionOperation<VersionIterator>("getAllVersions"){

            @Override
            @Nonnull
            public VersionIterator perform() throws RepositoryException {
                Iterator<Version> versions = Iterators.transform(((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getAllVersions(), new Function<VersionDelegate, Version>(){

                    @Override
                    public Version apply(VersionDelegate input) {
                        return new VersionImpl(input, VersionHistoryImpl.this.sessionContext);
                    }
                });
                return new VersionIteratorAdapter(VersionHistoryImpl.this.sessionDelegate.sync(versions));
            }
        });
    }

    @Override
    public NodeIterator getAllLinearFrozenNodes() throws RepositoryException {
        return new FrozenNodeIteratorAdapter(this.getAllLinearVersions());
    }

    @Override
    public NodeIterator getAllFrozenNodes() throws RepositoryException {
        return new FrozenNodeIteratorAdapter(this.getAllVersions());
    }

    @Override
    public Version getVersion(final String versionName) throws VersionException, RepositoryException {
        return this.perform(new SessionOperation<Version>("getVersion"){

            @Override
            @Nonnull
            public Version perform() throws RepositoryException {
                return new VersionImpl(((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getVersion(versionName), VersionHistoryImpl.this.sessionContext);
            }
        });
    }

    @Override
    public Version getVersionByLabel(final String label) throws VersionException, RepositoryException {
        return this.perform(new SessionOperation<Version>("getVersionByLabel"){

            @Override
            @Nonnull
            public Version perform() throws RepositoryException {
                String oakLabel = VersionHistoryImpl.this.sessionContext.getOakName(label);
                return new VersionImpl(((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getVersionByLabel(oakLabel), VersionHistoryImpl.this.sessionContext);
            }
        });
    }

    @Override
    public void addVersionLabel(final String versionName, final String label, final boolean moveLabel) throws LabelExistsVersionException, VersionException, RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("addVersionLabel", true){

            @Override
            public void performVoid() throws RepositoryException {
                String oakLabel = VersionHistoryImpl.this.sessionContext.getOakName(label);
                VersionDelegate version = ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getVersion(versionName);
                ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).addVersionLabel(version, oakLabel, moveLabel);
            }
        });
    }

    @Override
    public void removeVersionLabel(final String label) throws VersionException, RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("removeVersionLabel", true){

            @Override
            public void performVoid() throws RepositoryException {
                String oakLabel = VersionHistoryImpl.this.sessionContext.getOakName(label);
                ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).removeVersionLabel(oakLabel);
            }
        });
    }

    @Override
    public boolean hasVersionLabel(String label) throws RepositoryException {
        return Arrays.asList(this.getVersionLabels()).contains(label);
    }

    @Override
    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        return Arrays.asList(this.getVersionLabels(version)).contains(label);
    }

    @Override
    public String[] getVersionLabels() throws RepositoryException {
        return this.perform(new SessionOperation<String[]>("getVersionLabels"){

            @Override
            @Nonnull
            public String[] perform() throws RepositoryException {
                ArrayList<String> labels = new ArrayList<String>();
                for (String label : ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getVersionLabels()) {
                    labels.add(VersionHistoryImpl.this.sessionContext.getJcrName(label));
                }
                return labels.toArray(new String[labels.size()]);
            }
        });
    }

    @Override
    public String[] getVersionLabels(final Version version) throws VersionException, RepositoryException {
        if (!version.getContainingHistory().getPath().equals(this.getPath())) {
            throw new VersionException("Version is not contained in this VersionHistory");
        }
        return this.perform(new SessionOperation<String[]>("getVersionLabels"){

            @Override
            @Nonnull
            public String[] perform() throws RepositoryException {
                ArrayList<String> labels = new ArrayList<String>();
                for (String label : ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).getVersionLabels(version.getIdentifier())) {
                    labels.add(VersionHistoryImpl.this.sessionContext.getJcrName(label));
                }
                return labels.toArray(new String[labels.size()]);
            }
        });
    }

    @Override
    public void removeVersion(final String versionName) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("removeVersion", true){

            @Override
            public void performVoid() throws RepositoryException {
                String oakName = VersionHistoryImpl.this.sessionContext.getOakName(versionName);
                ((VersionHistoryDelegate)VersionHistoryImpl.this.dlg).removeVersion(oakName);
            }
        });
    }
}

