/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;

public abstract class CheckpointsHelper {
    public static SortedMap<Revision, Long> getCheckpoints(DocumentNodeStore store) {
        SortedMap<Revision, Checkpoints.Info> checkpoints = store.getCheckpoints().getCheckpoints();
        TreeMap<Revision, Long> map = Maps.newTreeMap(checkpoints.comparator());
        for (Map.Entry<Revision, Checkpoints.Info> entry : checkpoints.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getExpiryTime());
        }
        return map;
    }

    public static long removeAll(DocumentNodeStore store) {
        long cnt = 0L;
        for (Revision r : CheckpointsHelper.getCheckpoints(store).keySet()) {
            store.getCheckpoints().release(r.toString());
            ++cnt;
        }
        return cnt;
    }

    public static long removeOlderThan(DocumentNodeStore store, Revision r) {
        long cnt = 0L;
        for (Revision cp : CheckpointsHelper.getCheckpoints(store).keySet()) {
            if (cp.getTimestamp() >= r.getTimestamp()) continue;
            store.getCheckpoints().release(cp.toString());
            ++cnt;
        }
        return cnt;
    }

    public static int remove(DocumentNodeStore store, Revision r) {
        if (CheckpointsHelper.getCheckpoints(store).containsKey(r)) {
            store.getCheckpoints().release(r.toString());
            return 1;
        }
        return 0;
    }
}

