/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.mongodb.DB;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.cache.EmpiricalWeigher;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.BlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.LeaseFailureHandler;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.TieredDiffCache;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoMissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.EvictionListener;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.MemoryBlobStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMK {
    static final Logger LOG = LoggerFactory.getLogger(DocumentMK.class);
    static final String DEFAULT_PERSISTENT_CACHE_URI = System.getProperty("oak.documentMK.persCache");
    static final int MANY_CHILDREN_THRESHOLD = Integer.getInteger("oak.documentMK.manyChildren", 50);
    static final Boolean LIRS_CACHE;
    static final boolean FAST_DIFF;
    static final int CACHE_CONCURRENCY;
    protected final DocumentNodeStore nodeStore;
    protected final DocumentStore store;

    DocumentMK(Builder builder) {
        this.nodeStore = builder.getNodeStore();
        this.store = this.nodeStore.getDocumentStore();
    }

    public void dispose() {
        this.nodeStore.dispose();
    }

    void backgroundRead() {
        this.nodeStore.backgroundRead();
    }

    void backgroundWrite() {
        this.nodeStore.backgroundWrite();
    }

    void runBackgroundOperations() {
        this.nodeStore.runBackgroundOperations();
    }

    public DocumentNodeStore getNodeStore() {
        return this.nodeStore;
    }

    ClusterNodeInfo getClusterInfo() {
        return this.nodeStore.getClusterInfo();
    }

    int getPendingWriteCount() {
        return this.nodeStore.getPendingWriteCount();
    }

    public String getHeadRevision() throws DocumentStoreException {
        return this.nodeStore.getHeadRevision().toString();
    }

    public String checkpoint(long lifetime) throws DocumentStoreException {
        try {
            return this.nodeStore.checkpoint(lifetime);
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) throws DocumentStoreException {
        if (depth != 0) {
            throw new DocumentStoreException("Only depth 0 is supported, depth is " + depth);
        }
        if (path == null || path.equals("")) {
            path = "/";
        }
        RevisionVector fromRev = RevisionVector.fromString(fromRevisionId);
        RevisionVector toRev = RevisionVector.fromString(toRevisionId);
        DocumentNodeState before = this.nodeStore.getNode(path, fromRev);
        DocumentNodeState after = this.nodeStore.getNode(path, toRev);
        if (before == null || after == null) {
            String msg = String.format("Diff is only supported if the node exists in both cases. Node [%s], fromRev [%s] -> %s, toRev [%s] -> %s", path, fromRev, before != null, toRev, after != null);
            throw new DocumentStoreException(msg);
        }
        JsopDiff diff = new JsopDiff(path, depth);
        after.compareAgainstBaseState(before, diff);
        return diff.toString();
    }

    public boolean nodeExists(String path, String revisionId) throws DocumentStoreException {
        DocumentNodeState n;
        if (!PathUtils.isAbsolute(path)) {
            throw new DocumentStoreException("Path is not absolute: " + path);
        }
        revisionId = revisionId != null ? revisionId : this.nodeStore.getHeadRevision().toString();
        RevisionVector rev = RevisionVector.fromString(revisionId);
        try {
            n = this.nodeStore.getNode(path, rev);
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
        return n != null;
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws DocumentStoreException {
        if (depth != 0) {
            throw new DocumentStoreException("Only depth 0 is supported, depth is " + depth);
        }
        revisionId = revisionId != null ? revisionId : this.nodeStore.getHeadRevision().toString();
        RevisionVector rev = RevisionVector.fromString(revisionId);
        try {
            int max;
            DocumentNodeState n = this.nodeStore.getNode(path, rev);
            if (n == null) {
                return null;
            }
            JsopStream json = new JsopStream();
            boolean includeId = filter != null && filter.contains(":id");
            boolean bl = filter != null && filter.contains(":hash");
            json.object();
            n.append(json, includeId |= bl);
            if (maxChildNodes == -1) {
                max = Integer.MAX_VALUE;
                maxChildNodes = Integer.MAX_VALUE;
            } else {
                long m = (long)maxChildNodes + offset;
                max = (int)Math.min(m, Integer.MAX_VALUE);
            }
            DocumentNodeState.Children c = this.nodeStore.getChildren(n, null, max);
            for (long i = offset; i < (long)c.children.size() && maxChildNodes-- > 0; ++i) {
                String name = c.children.get((int)i);
                json.key(name).object().endObject();
            }
            if (c.hasMore) {
                json.key(":childNodeCount").value(Long.MAX_VALUE);
            } else {
                json.key(":childNodeCount").value(c.children.size());
            }
            json.endObject();
            return json.toString();
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
    }

    public String commit(String rootPath, String jsonDiff, String baseRevId, String message) throws DocumentStoreException {
        RevisionVector rev;
        boolean success = false;
        Commit commit = this.nodeStore.newCommit(baseRevId != null ? RevisionVector.fromString(baseRevId) : null, null);
        try {
            RevisionVector baseRev = commit.getBaseRevision();
            boolean isBranch = baseRev != null && baseRev.isBranch();
            this.parseJsonDiff(commit, jsonDiff, rootPath);
            commit.apply();
            rev = this.nodeStore.done(commit, isBranch, null);
            success = true;
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
        finally {
            if (!success) {
                this.nodeStore.canceled(commit);
            }
        }
        return rev.toString();
    }

    public String branch(@Nullable String trunkRevisionId) throws DocumentStoreException {
        RevisionVector revision = trunkRevisionId != null ? RevisionVector.fromString(trunkRevisionId) : this.nodeStore.getHeadRevision();
        return revision.asBranchRevision(this.nodeStore.getClusterId()).toString();
    }

    public String merge(String branchRevisionId, String message) throws DocumentStoreException {
        RevisionVector revision = RevisionVector.fromString(branchRevisionId);
        if (!revision.isBranch()) {
            throw new DocumentStoreException("Not a branch: " + branchRevisionId);
        }
        try {
            return this.nodeStore.merge(revision, null).toString();
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
        catch (CommitFailedException e) {
            throw new DocumentStoreException(e);
        }
    }

    @Nonnull
    public String rebase(@Nonnull String branchRevisionId, @Nullable String newBaseRevisionId) throws DocumentStoreException {
        RevisionVector r = RevisionVector.fromString(branchRevisionId);
        RevisionVector base = newBaseRevisionId != null ? RevisionVector.fromString(newBaseRevisionId) : this.nodeStore.getHeadRevision();
        return this.nodeStore.rebase(r, base).toString();
    }

    @Nonnull
    public String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws DocumentStoreException {
        RevisionVector branch = RevisionVector.fromString(branchRevisionId);
        if (!branch.isBranch()) {
            throw new DocumentStoreException("Not a branch revision: " + branchRevisionId);
        }
        RevisionVector ancestor = RevisionVector.fromString(ancestorRevisionId);
        if (!ancestor.isBranch()) {
            throw new DocumentStoreException("Not a branch revision: " + ancestorRevisionId);
        }
        try {
            return this.nodeStore.reset(branch, ancestor).toString();
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
    }

    public long getLength(String blobId) throws DocumentStoreException {
        try {
            return this.nodeStore.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new DocumentStoreException(e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws DocumentStoreException {
        try {
            int read = this.nodeStore.getBlobStore().readBlob(blobId, pos, buff, off, length);
            return read < 0 ? 0 : read;
        }
        catch (Exception e) {
            throw new DocumentStoreException(e);
        }
    }

    public String write(InputStream in) throws DocumentStoreException {
        try {
            return this.nodeStore.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new DocumentStoreException(e);
        }
    }

    public DocumentStore getDocumentStore() {
        return this.store;
    }

    private void parseJsonDiff(Commit commit, String json, String rootPath) {
        int r;
        RevisionVector baseRev = commit.getBaseRevision();
        String baseRevId = baseRev != null ? baseRev.toString() : null;
        HashSet<String> added = Sets.newHashSet();
        JsopTokenizer t = new JsopTokenizer(json);
        block7: while ((r = t.read()) != 0) {
            String path = PathUtils.concat(rootPath, t.readString());
            switch (r) {
                case 43: {
                    t.read(58);
                    t.read(123);
                    this.parseAddNode(commit, t, path);
                    added.add(path);
                    continue block7;
                }
                case 45: {
                    DocumentNodeState toRemove = this.nodeStore.getNode(path, commit.getBaseRevision());
                    if (toRemove == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    commit.removeNode(path, toRemove);
                    this.nodeStore.markAsDeleted(toRemove, commit, true);
                    commit.removeNodeDiff(path);
                    continue block7;
                }
                case 94: {
                    t.read(58);
                    String value = t.matches(5) ? null : t.readRawValue().trim();
                    String p = PathUtils.getParentPath(path);
                    if (!added.contains(p) && this.nodeStore.getNode(p, commit.getBaseRevision()) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    String propertyName = PathUtils.getName(path);
                    commit.updateProperty(p, propertyName, value);
                    commit.updatePropertyDiff(p, propertyName, value);
                    continue block7;
                }
                case 62: {
                    DocumentNodeState source;
                    t.read(58);
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute(targetPath)) {
                        targetPath = PathUtils.concat(rootPath, targetPath);
                    }
                    if ((source = this.nodeStore.getNode(path, baseRev)) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new DocumentStoreException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    commit.moveNode(path, targetPath);
                    this.nodeStore.moveNode(source, targetPath, commit);
                    continue block7;
                }
                case 42: {
                    DocumentNodeState source;
                    t.read(58);
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute(targetPath)) {
                        targetPath = PathUtils.concat(rootPath, targetPath);
                    }
                    if ((source = this.nodeStore.getNode(path, baseRev)) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new DocumentStoreException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    commit.copyNode(path, targetPath);
                    this.nodeStore.copyNode(source, targetPath, commit);
                    continue block7;
                }
            }
            throw new DocumentStoreException("token: " + (char)t.getTokenType());
        }
    }

    private void parseAddNode(Commit commit, JsopReader t, String path) {
        DocumentNodeState n = new DocumentNodeState(this.nodeStore, path, new RevisionVector(commit.getRevision()));
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    String childPath = PathUtils.concat(path, key);
                    this.parseAddNode(commit, t, childPath);
                    continue;
                }
                String value = t.readRawValue().trim();
                n.setProperty(key, value);
            } while (t.matches(44));
            t.read(125);
        }
        commit.addNode(n);
        commit.addNodeDiff(n);
    }

    static {
        String s = System.getProperty("oak.documentMK.lirsCache");
        LIRS_CACHE = s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
        FAST_DIFF = Boolean.parseBoolean(System.getProperty("oak.documentMK.fastDiff", "true"));
        CACHE_CONCURRENCY = Integer.getInteger("oak.documentMK.cacheConcurrency", 16);
    }

    public static class Builder {
        private static final long DEFAULT_MEMORY_CACHE_SIZE = 0x10000000L;
        public static final int DEFAULT_NODE_CACHE_PERCENTAGE = 25;
        public static final int DEFAULT_PREV_DOC_CACHE_PERCENTAGE = 4;
        public static final int DEFAULT_CHILDREN_CACHE_PERCENTAGE = 10;
        public static final int DEFAULT_DIFF_CACHE_PERCENTAGE = 5;
        public static final int DEFAULT_DOC_CHILDREN_CACHE_PERCENTAGE = 3;
        public static final int DEFAULT_CACHE_SEGMENT_COUNT = 16;
        public static final int DEFAULT_CACHE_STACK_MOVE_DISTANCE = 16;
        private DocumentNodeStore nodeStore;
        private DocumentStore documentStore;
        private DiffCache diffCache;
        private BlobStore blobStore;
        private int clusterId = Integer.getInteger("oak.documentMK.clusterId", 0);
        private int asyncDelay = 1000;
        private boolean timing;
        private boolean logging;
        private boolean leaseCheck = true;
        private Weigher<CacheValue, CacheValue> weigher = new EmpiricalWeigher();
        private long memoryCacheSize = 0x10000000L;
        private int nodeCachePercentage = 25;
        private int prevDocCachePercentage = 4;
        private int childrenCachePercentage = 10;
        private int diffCachePercentage = 5;
        private int docChildrenCachePercentage = 3;
        private int cacheSegmentCount = 16;
        private int cacheStackMoveDistance = 16;
        private boolean useSimpleRevision;
        private long maxReplicationLagMillis = TimeUnit.HOURS.toMillis(6L);
        private boolean disableBranches;
        private Clock clock = Clock.SIMPLE;
        private Executor executor;
        private String persistentCacheURI = DEFAULT_PERSISTENT_CACHE_URI;
        private PersistentCache persistentCache;
        private LeaseFailureHandler leaseFailureHandler;
        private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
        private BlobStoreStats blobStoreStats;
        private CacheStats blobStoreCacheStats;
        private DocumentStoreStatsCollector documentStoreStatsCollector;
        private Map<CacheType, PersistentCacheStats> persistentCacheStats = new EnumMap<CacheType, PersistentCacheStats>(CacheType.class);

        public Builder setMongoDB(@Nonnull String uri, @Nonnull String name, int blobCacheSizeMB) throws UnknownHostException {
            DB db = new MongoConnection(uri).getDB(name);
            if (!MongoConnection.hasWriteConcern(uri)) {
                db.setWriteConcern(MongoConnection.getDefaultWriteConcern(db));
            }
            this.setMongoDB(db, blobCacheSizeMB);
            return this;
        }

        public Builder setMongoDB(@Nonnull DB db, int blobCacheSizeMB) {
            if (!MongoConnection.hasSufficientWriteConcern(db)) {
                LOG.warn("Insufficient write concern: " + db.getWriteConcern() + " At least " + MongoConnection.getDefaultWriteConcern(db) + " is recommended.");
            }
            if (this.documentStore == null) {
                this.documentStore = new MongoDocumentStore(db, this);
            }
            if (this.blobStore == null) {
                GarbageCollectableBlobStore s = new MongoBlobStore(db, (long)(blobCacheSizeMB * 1024) * 1024L);
                this.configureBlobStore(s);
                PersistentCache p = this.getPersistentCache();
                if (p != null) {
                    s = p.wrapBlobStore(s);
                }
                this.blobStore = s;
            }
            return this;
        }

        public Builder setMongoDB(@Nonnull DB db) {
            return this.setMongoDB(db, 16);
        }

        public Builder setRDBConnection(DataSource ds) {
            this.documentStore = new RDBDocumentStore(ds, this);
            if (this.blobStore == null) {
                this.blobStore = new RDBBlobStore(ds);
                this.configureBlobStore(this.blobStore);
            }
            return this;
        }

        public Builder setRDBConnection(DataSource ds, RDBOptions options) {
            this.documentStore = new RDBDocumentStore(ds, this, options);
            if (this.blobStore == null) {
                this.blobStore = new RDBBlobStore(ds, options);
                this.configureBlobStore(this.blobStore);
            }
            return this;
        }

        public Builder setPersistentCache(String persistentCache) {
            this.persistentCacheURI = persistentCache;
            return this;
        }

        public Builder setRDBConnection(DataSource documentStoreDataSource, DataSource blobStoreDataSource) {
            this.documentStore = new RDBDocumentStore(documentStoreDataSource, this);
            this.blobStore = new RDBBlobStore(blobStoreDataSource);
            this.configureBlobStore(this.blobStore);
            return this;
        }

        public Builder setTiming(boolean timing) {
            this.timing = timing;
            return this;
        }

        public boolean getTiming() {
            return this.timing;
        }

        public Builder setLogging(boolean logging) {
            this.logging = logging;
            return this;
        }

        public boolean getLogging() {
            return this.logging;
        }

        public Builder setLeaseCheck(boolean leaseCheck) {
            this.leaseCheck = leaseCheck;
            return this;
        }

        public boolean getLeaseCheck() {
            return this.leaseCheck;
        }

        public Builder setLeaseFailureHandler(LeaseFailureHandler leaseFailureHandler) {
            this.leaseFailureHandler = leaseFailureHandler;
            return this;
        }

        public LeaseFailureHandler getLeaseFailureHandler() {
            return this.leaseFailureHandler;
        }

        public Builder setDocumentStore(DocumentStore documentStore) {
            this.documentStore = documentStore;
            return this;
        }

        public DocumentStore getDocumentStore() {
            if (this.documentStore == null) {
                this.documentStore = new MemoryDocumentStore();
            }
            return this.documentStore;
        }

        public DocumentNodeStore getNodeStore() {
            if (this.nodeStore == null) {
                this.nodeStore = new DocumentNodeStore(this);
            }
            return this.nodeStore;
        }

        public DiffCache getDiffCache() {
            if (this.diffCache == null) {
                this.diffCache = new TieredDiffCache(this);
            }
            return this.diffCache;
        }

        public Builder setDiffCache(DiffCache diffCache) {
            this.diffCache = diffCache;
            return this;
        }

        public Builder setBlobStore(BlobStore blobStore) {
            this.blobStore = blobStore;
            return this;
        }

        public BlobStore getBlobStore() {
            if (this.blobStore == null) {
                this.blobStore = new MemoryBlobStore();
                this.configureBlobStore(this.blobStore);
            }
            return this.blobStore;
        }

        public Builder setClusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setCacheSegmentCount(int cacheSegmentCount) {
            this.cacheSegmentCount = cacheSegmentCount;
            return this;
        }

        public Builder setCacheStackMoveDistance(int cacheSegmentCount) {
            this.cacheStackMoveDistance = cacheSegmentCount;
            return this;
        }

        public int getClusterId() {
            return this.clusterId;
        }

        public Builder setAsyncDelay(int asyncDelay) {
            this.asyncDelay = asyncDelay;
            return this;
        }

        public int getAsyncDelay() {
            return this.asyncDelay;
        }

        public Weigher<CacheValue, CacheValue> getWeigher() {
            return this.weigher;
        }

        public Builder withWeigher(Weigher<CacheValue, CacheValue> weigher) {
            this.weigher = weigher;
            return this;
        }

        public Builder memoryCacheSize(long memoryCacheSize) {
            this.memoryCacheSize = memoryCacheSize;
            return this;
        }

        public Builder memoryCacheDistribution(int nodeCachePercentage, int prevDocCachePercentage, int childrenCachePercentage, int docChildrenCachePercentage, int diffCachePercentage) {
            Preconditions.checkArgument(nodeCachePercentage >= 0);
            Preconditions.checkArgument(prevDocCachePercentage >= 0);
            Preconditions.checkArgument(childrenCachePercentage >= 0);
            Preconditions.checkArgument(docChildrenCachePercentage >= 0);
            Preconditions.checkArgument(diffCachePercentage >= 0);
            Preconditions.checkArgument(nodeCachePercentage + prevDocCachePercentage + childrenCachePercentage + docChildrenCachePercentage + diffCachePercentage < 100);
            this.nodeCachePercentage = nodeCachePercentage;
            this.prevDocCachePercentage = prevDocCachePercentage;
            this.childrenCachePercentage = childrenCachePercentage;
            this.docChildrenCachePercentage = docChildrenCachePercentage;
            this.diffCachePercentage = diffCachePercentage;
            return this;
        }

        public long getNodeCacheSize() {
            return this.memoryCacheSize * (long)this.nodeCachePercentage / 100L;
        }

        public long getPrevDocumentCacheSize() {
            return this.memoryCacheSize * (long)this.prevDocCachePercentage / 100L;
        }

        public long getChildrenCacheSize() {
            return this.memoryCacheSize * (long)this.childrenCachePercentage / 100L;
        }

        public long getDocumentCacheSize() {
            return this.memoryCacheSize - this.getNodeCacheSize() - this.getPrevDocumentCacheSize() - this.getChildrenCacheSize() - this.getDiffCacheSize() - this.getDocChildrenCacheSize();
        }

        public long getDocChildrenCacheSize() {
            return this.memoryCacheSize * (long)this.docChildrenCachePercentage / 100L;
        }

        public long getDiffCacheSize() {
            return this.memoryCacheSize * (long)this.diffCachePercentage / 100L;
        }

        public long getMemoryDiffCacheSize() {
            return this.getDiffCacheSize() / 2L;
        }

        public long getLocalDiffCacheSize() {
            return this.getDiffCacheSize() / 2L;
        }

        public Builder setUseSimpleRevision(boolean useSimpleRevision) {
            this.useSimpleRevision = useSimpleRevision;
            return this;
        }

        public boolean isUseSimpleRevision() {
            return this.useSimpleRevision;
        }

        public Executor getExecutor() {
            if (this.executor == null) {
                return MoreExecutors.sameThreadExecutor();
            }
            return this.executor;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setStatisticsProvider(StatisticsProvider statisticsProvider) {
            this.statisticsProvider = statisticsProvider;
            return this;
        }

        public StatisticsProvider getStatisticsProvider() {
            return this.statisticsProvider;
        }

        public DocumentStoreStatsCollector getDocumentStoreStatsCollector() {
            if (this.documentStoreStatsCollector == null) {
                this.documentStoreStatsCollector = new DocumentStoreStats(this.statisticsProvider);
            }
            return this.documentStoreStatsCollector;
        }

        public Builder setDocumentStoreStatsCollector(DocumentStoreStatsCollector documentStoreStatsCollector) {
            this.documentStoreStatsCollector = documentStoreStatsCollector;
            return this;
        }

        @Nonnull
        public Map<CacheType, PersistentCacheStats> getPersistenceCacheStats() {
            return this.persistentCacheStats;
        }

        @CheckForNull
        public BlobStoreStats getBlobStoreStats() {
            return this.blobStoreStats;
        }

        @CheckForNull
        public CacheStats getBlobStoreCacheStats() {
            return this.blobStoreCacheStats;
        }

        public Clock getClock() {
            return this.clock;
        }

        public Builder setMaxReplicationLag(long duration, TimeUnit unit) {
            this.maxReplicationLagMillis = unit.toMillis(duration);
            return this;
        }

        public long getMaxReplicationLagMillis() {
            return this.maxReplicationLagMillis;
        }

        public Builder disableBranches() {
            this.disableBranches = true;
            return this;
        }

        public boolean isDisableBranches() {
            return this.disableBranches;
        }

        VersionGCSupport createVersionGCSupport() {
            DocumentStore store = this.getDocumentStore();
            if (store instanceof MongoDocumentStore) {
                return new MongoVersionGCSupport((MongoDocumentStore)store);
            }
            if (store instanceof RDBDocumentStore) {
                return new RDBVersionGCSupport((RDBDocumentStore)store);
            }
            return new VersionGCSupport(store);
        }

        Iterable<ReferencedBlob> createReferencedBlobs(final DocumentNodeStore ns) {
            final DocumentStore store = this.getDocumentStore();
            return new Iterable<ReferencedBlob>(){

                @Override
                public Iterator<ReferencedBlob> iterator() {
                    if (store instanceof MongoDocumentStore) {
                        return new MongoBlobReferenceIterator(ns, (MongoDocumentStore)store);
                    }
                    return new BlobReferenceIterator(ns);
                }
            };
        }

        public MissingLastRevSeeker createMissingLastRevSeeker() {
            DocumentStore store = this.getDocumentStore();
            if (store instanceof MongoDocumentStore) {
                return new MongoMissingLastRevSeeker((MongoDocumentStore)store);
            }
            return new MissingLastRevSeeker(store);
        }

        public DocumentMK open() {
            return new DocumentMK(this);
        }

        public Cache<PathRev, DocumentNodeState> buildNodeCache(DocumentNodeStore store) {
            return this.buildCache(CacheType.NODE, this.getNodeCacheSize(), store, null);
        }

        public Cache<PathRev, DocumentNodeState.Children> buildChildrenCache() {
            return this.buildCache(CacheType.CHILDREN, this.getChildrenCacheSize(), null, null);
        }

        public Cache<StringValue, NodeDocument.Children> buildDocChildrenCache() {
            return this.buildCache(CacheType.DOC_CHILDREN, this.getDocChildrenCacheSize(), null, null);
        }

        public Cache<PathRev, StringValue> buildMemoryDiffCache() {
            return this.buildCache(CacheType.DIFF, this.getMemoryDiffCacheSize(), null, null);
        }

        public Cache<RevisionsKey, LocalDiffCache.Diff> buildLocalDiffCache() {
            return this.buildCache(CacheType.LOCAL_DIFF, this.getLocalDiffCacheSize(), null, null);
        }

        public Cache<CacheValue, NodeDocument> buildDocumentCache(DocumentStore docStore) {
            return this.buildCache(CacheType.DOCUMENT, this.getDocumentCacheSize(), null, docStore);
        }

        public Cache<StringValue, NodeDocument> buildPrevDocumentsCache(DocumentStore docStore) {
            return this.buildCache(CacheType.PREV_DOCUMENT, this.getPrevDocumentCacheSize(), null, docStore);
        }

        public NodeDocumentCache buildNodeDocumentCache(DocumentStore docStore, NodeDocumentLocks locks) {
            Cache<CacheValue, NodeDocument> nodeDocumentsCache = this.buildDocumentCache(docStore);
            CacheStats nodeDocumentsCacheStats = new CacheStats(nodeDocumentsCache, "Document-Documents", this.getWeigher(), this.getDocumentCacheSize());
            Cache<StringValue, NodeDocument> prevDocumentsCache = this.buildPrevDocumentsCache(docStore);
            CacheStats prevDocumentsCacheStats = new CacheStats(prevDocumentsCache, "Document-PrevDocuments", this.getWeigher(), this.getPrevDocumentCacheSize());
            return new NodeDocumentCache(nodeDocumentsCache, nodeDocumentsCacheStats, prevDocumentsCache, prevDocumentsCacheStats, locks);
        }

        private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(CacheType cacheType, long maxWeight, DocumentNodeStore docNodeStore, DocumentStore docStore) {
            CopyOnWriteArraySet<EvictionListener<K, V>> listeners = new CopyOnWriteArraySet<EvictionListener<K, V>>();
            Cache<K, V> cache = this.buildCache(cacheType.name(), maxWeight, listeners);
            PersistentCache p = this.getPersistentCache();
            if (p != null) {
                PersistentCacheStats stats;
                if (docNodeStore != null) {
                    docNodeStore.setPersistentCache(p);
                }
                if ((cache = p.wrap(docNodeStore, docStore, cache, cacheType, this.statisticsProvider)) instanceof EvictionListener) {
                    listeners.add((EvictionListener)((Object)cache));
                }
                if ((stats = PersistentCache.getPersistentCacheStats(cache)) != null) {
                    this.persistentCacheStats.put(cacheType, stats);
                }
            }
            return cache;
        }

        public PersistentCache getPersistentCache() {
            if (this.persistentCacheURI == null) {
                return null;
            }
            if (this.persistentCache == null) {
                try {
                    this.persistentCache = new PersistentCache(this.persistentCacheURI);
                }
                catch (Throwable e) {
                    LOG.warn("Persistent cache not available; please disable the configuration", e);
                    throw new IllegalArgumentException(e);
                }
            }
            return this.persistentCache;
        }

        private <K extends CacheValue, V extends CacheValue> Cache<K, V> buildCache(String module, long maxWeight, final Set<EvictionListener<K, V>> listeners) {
            boolean useLirs;
            boolean bl = useLirs = this.persistentCacheURI != null;
            if (LIRS_CACHE != null) {
                useLirs = LIRS_CACHE;
            }
            if (useLirs) {
                return CacheLIRS.newBuilder().module(module).weigher(new Weigher<K, V>(){

                    @Override
                    public int weigh(K key, V value) {
                        return Builder.this.weigher.weigh(key, value);
                    }
                }).averageWeight(2000).maximumWeight(maxWeight).segmentCount(this.cacheSegmentCount).stackMoveDistance(this.cacheStackMoveDistance).recordStats().evictionCallback(new CacheLIRS.EvictionCallback<K, V>(){

                    @Override
                    public void evicted(K key, V value, RemovalCause cause) {
                        for (EvictionListener l : listeners) {
                            l.evicted(key, value, cause);
                        }
                    }
                }).build();
            }
            return CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY).weigher(this.weigher).maximumWeight(maxWeight).recordStats().removalListener(new RemovalListener<K, V>(){

                @Override
                public void onRemoval(RemovalNotification<K, V> notification) {
                    for (EvictionListener l : listeners) {
                        l.evicted(notification.getKey(), notification.getValue(), notification.getCause());
                    }
                }
            }).build();
        }

        private void configureBlobStore(BlobStore blobStore) {
            if (blobStore instanceof AbstractBlobStore) {
                this.blobStoreStats = new BlobStoreStats(this.statisticsProvider);
                ((AbstractBlobStore)blobStore).setStatsCollector(this.blobStoreStats);
            }
            if (blobStore instanceof CachingBlobStore) {
                this.blobStoreCacheStats = ((CachingBlobStore)blobStore).getCacheStats();
            }
        }
    }
}

