/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitDiff;
import org.apache.jackrabbit.oak.plugins.document.ConflictException;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.FailedWithConflictException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStoreBranch;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentNodeStoreBranch
implements NodeStoreBranch {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStoreBranch.class);
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger(DocumentNodeStoreBranch.class.getName() + ".perf"));
    private static final int MAX_LOCK_TRY_TIME_MULTIPLIER = Integer.getInteger("oak.maxLockTryTimeMultiplier", 30);
    private static final ConcurrentMap<Thread, DocumentNodeStoreBranch> BRANCHES = Maps.newConcurrentMap();
    private static final Random RANDOM = new Random();
    private static final long MIN_BACKOFF = 50L;
    protected final DocumentNodeStore store;
    protected final long maximumBackoff;
    protected final long maxLockTryTimeMS;
    private final ReadWriteLock mergeLock;
    private BranchState branchState;

    DocumentNodeStoreBranch(DocumentNodeStore store, DocumentNodeState base, ReadWriteLock mergeLock) {
        this.store = Preconditions.checkNotNull(store);
        this.branchState = new Unmodified(Preconditions.checkNotNull(base));
        this.maximumBackoff = Math.max((long)store.getMaxBackOffMillis(), 50L);
        this.maxLockTryTimeMS = store.getMaxBackOffMillis() * MAX_LOCK_TRY_TIME_MULTIPLIER;
        this.mergeLock = mergeLock;
    }

    @Override
    @Nonnull
    public NodeState getBase() {
        return this.branchState.getBase();
    }

    @Override
    @Nonnull
    public NodeState getHead() {
        return this.branchState.getHead();
    }

    @Override
    public void setRoot(NodeState newRoot) {
        this.branchState.setRoot(Preconditions.checkNotNull(newRoot));
    }

    @Override
    @Nonnull
    public NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
        try {
            return this.merge0(hook, info, false);
        }
        catch (CommitFailedException e) {
            if (!e.isOfType("Merge")) {
                throw e;
            }
            return this.merge0(hook, info, true);
        }
    }

    @Override
    public void rebase() {
        this.branchState.rebase();
    }

    public String toString() {
        return this.branchState.toString();
    }

    @Nonnull
    ReadWriteLock getMergeLock() {
        return this.mergeLock;
    }

    @Nonnull
    private NodeState merge0(@Nonnull CommitHook hook, @Nonnull CommitInfo info, boolean exclusive) throws CommitFailedException {
        CommitFailedException ex = null;
        HashSet<Revision> conflictRevisions = new HashSet<Revision>();
        long time = System.currentTimeMillis();
        int numRetries = 0;
        for (long backoff = 50L; backoff <= this.maximumBackoff; backoff *= 2L) {
            if (ex != null) {
                try {
                    ++numRetries;
                    long start = perfLogger.start();
                    if (!conflictRevisions.isEmpty()) {
                        LOG.debug("Suspending until {} is visible. Current head {}.", (Object)conflictRevisions, (Object)this.store.getHeadRevision());
                        this.store.suspendUntilAll(conflictRevisions);
                        conflictRevisions.clear();
                        LOG.debug("Resumed. Current head {}.", (Object)this.store.getHeadRevision());
                    } else {
                        Thread.sleep(backoff + (long)RANDOM.nextInt((int)Math.min(backoff, Integer.MAX_VALUE)));
                    }
                    perfLogger.end(start, 1L, "Merge - Retry attempt [{}]", (Object)numRetries);
                }
                catch (InterruptedException e) {
                    throw new CommitFailedException("Merge", 3, "Merge interrupted", e);
                }
            }
            try {
                return this.branchState.merge(Preconditions.checkNotNull(hook), Preconditions.checkNotNull(info), exclusive);
            }
            catch (FailedWithConflictException e) {
                ex = e;
                conflictRevisions.addAll(e.getConflictRevisions());
            }
            catch (CommitFailedException e) {
                ex = e;
            }
            LOG.trace("Merge Error", ex);
            if (ex.isOfType("Merge")) continue;
            throw ex;
        }
        time = System.currentTimeMillis() - time;
        String msg = ex.getMessage() + " (retries " + numRetries + ", " + time + " ms)";
        throw new CommitFailedException(ex.getSource(), ex.getType(), ex.getCode(), msg, ex.getCause());
    }

    @CheckForNull
    private Lock acquireMergeLock(boolean exclusive) throws CommitFailedException {
        String mode;
        boolean acquired;
        long start = perfLogger.start();
        Lock lock = exclusive ? this.mergeLock.writeLock() : this.mergeLock.readLock();
        try {
            acquired = lock.tryLock(this.maxLockTryTimeMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new CommitFailedException("Oak", 1, "Unable to acquire merge lock", e);
        }
        String string = mode = exclusive ? "exclusive" : "shared";
        if (acquired) {
            perfLogger.end(start, 1L, "Merge - Acquired lock ({})", (Object)mode);
        } else {
            LOG.info("Time out while acquiring merge lock ({})", (Object)mode);
            lock = null;
        }
        return lock;
    }

    private DocumentNodeState persist(final NodeState toPersist, final DocumentNodeState base, CommitInfo info) {
        return this.persist(new Changes(){

            @Override
            public void with(Commit c) {
                toPersist.compareAgainstBaseState(base, new CommitDiff(DocumentNodeStoreBranch.this.store, c, DocumentNodeStoreBranch.this.store.getBlobSerializer()));
            }
        }, base, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentNodeState persist(Changes op, DocumentNodeState base, CommitInfo info) {
        RevisionVector rev;
        boolean success = false;
        Commit c = this.store.newCommit(base.getRevision(), this);
        try {
            op.with(c);
            if (c.isEmpty()) {
                DocumentNodeState documentNodeState = base;
                return documentNodeState;
            }
            c.apply();
            rev = this.store.done(c, base.getRevision().isBranch(), info);
            success = true;
        }
        finally {
            if (!success) {
                this.store.canceled(c);
            }
        }
        return this.store.getRoot(rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withCurrentBranch(Callable<T> callable) throws Exception {
        Thread t = Thread.currentThread();
        DocumentNodeStoreBranch previous = BRANCHES.putIfAbsent(t, this);
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            if (previous == null) {
                BRANCHES.remove(t, this);
            }
        }
    }

    @CheckForNull
    static DocumentNodeStoreBranch getCurrentBranch() {
        return (DocumentNodeStoreBranch)BRANCHES.get(Thread.currentThread());
    }

    private class ResetFailed
    extends BranchState {
        private final CommitFailedException ex;

        protected ResetFailed(DocumentNodeState base, CommitFailedException e) {
            super(base);
            this.ex = e;
        }

        @Override
        @Nonnull
        NodeState getHead() {
            throw new IllegalStateException("Branch with failed reset", this.ex);
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch with failed reset", this.ex);
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch with failed reset", this.ex);
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info, boolean exclusive) throws CommitFailedException {
            throw this.ex;
        }
    }

    private class Merged
    extends BranchState {
        protected Merged(DocumentNodeState base) {
            super(base);
        }

        public String toString() {
            return "Merged[" + this.base + ']';
        }

        @Override
        @Nonnull
        NodeState getHead() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info, boolean exclusive) {
            throw new IllegalStateException("Branch has already been merged");
        }
    }

    private class Persisted
    extends BranchState {
        private DocumentNodeState head;

        public String toString() {
            return "Persisted[" + this.base + ", " + this.head + ']';
        }

        Persisted(DocumentNodeState base) {
            super(base);
            this.head = this.createBranch(base);
        }

        final DocumentNodeState createBranch(DocumentNodeState state) {
            return DocumentNodeStoreBranch.this.store.getRoot(state.getRevision().asBranchRevision(DocumentNodeStoreBranch.this.store.getClusterId()));
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.head.equals(root)) {
                this.persistTransientHead(root);
            }
        }

        @Override
        void rebase() {
            DocumentNodeState root = DocumentNodeStoreBranch.this.store.getRoot();
            this.head = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.rebase(this.head.getRevision(), root.getRevision()));
            this.base = root;
        }

        @Override
        @Nonnull
        NodeState merge(final @Nonnull CommitHook hook, final @Nonnull CommitInfo info, boolean exclusive) throws CommitFailedException {
            boolean success = false;
            DocumentNodeState previousHead = this.head;
            Lock lock = DocumentNodeStoreBranch.this.acquireMergeLock(exclusive);
            try {
                this.rebase();
                previousHead = this.head;
                DocumentNodeState newRoot = (DocumentNodeState)DocumentNodeStoreBranch.this.withCurrentBranch(new Callable<DocumentNodeState>(){

                    @Override
                    public DocumentNodeState call() throws Exception {
                        Persisted.this.checkForConflicts();
                        NodeState toCommit = Preconditions.checkNotNull(hook).processCommit(Persisted.this.base, Persisted.this.head, info);
                        Persisted.this.head = DocumentNodeStoreBranch.this.persist(toCommit, Persisted.this.head, info);
                        return DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.merge(Persisted.this.head.getRevision(), info));
                    }
                });
                DocumentNodeStoreBranch.this.branchState = new Merged(this.base);
                success = true;
                DocumentNodeState documentNodeState = newRoot;
                return documentNodeState;
            }
            catch (CommitFailedException e) {
                throw e;
            }
            catch (ConflictException e) {
                throw e.asCommitFailedException();
            }
            catch (Exception e) {
                throw new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying store", e);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
                if (!success) {
                    this.resetBranch(this.head, previousHead);
                }
            }
        }

        private void persistTransientHead(NodeState newHead) {
            this.head = DocumentNodeStoreBranch.this.persist(newHead, this.head, null);
        }

        private void resetBranch(DocumentNodeState branchHead, DocumentNodeState ancestor) {
            try {
                this.head = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.reset(branchHead.getRevision(), ancestor.getRevision()));
            }
            catch (Exception e) {
                CommitFailedException ex = new CommitFailedException("Oak", 100, "Branch reset failed", e);
                DocumentNodeStoreBranch.this.branchState = new ResetFailed(this.base, ex);
            }
        }

        private void checkForConflicts() throws CommitFailedException {
            HashSet<Revision> commits;
            Branch b = DocumentNodeStoreBranch.this.store.getBranches().getBranch(this.head.getRevision());
            if (b == null) {
                return;
            }
            NodeDocument doc = Utils.getRootDocument(DocumentNodeStoreBranch.this.store.getDocumentStore());
            HashSet<Revision> collisions = Sets.newHashSet(doc.getLocalMap("_collisions").keySet());
            Sets.SetView<Revision> conflicts = Sets.intersection(collisions, commits = Sets.newHashSet(Iterables.transform(b.getCommits(), new Function<Revision, Revision>(){

                @Override
                public Revision apply(Revision input) {
                    return input.asTrunkRevision();
                }
            })));
            if (!conflicts.isEmpty()) {
                throw new CommitFailedException("State", 2, "Conflicting concurrent change on branch commits " + conflicts);
            }
        }
    }

    private class InMemory
    extends BranchState {
        private NodeState head;

        public String toString() {
            return "InMemory[" + this.base + ", " + this.head + ']';
        }

        InMemory(DocumentNodeState base, NodeState head) {
            super(base);
            this.head = head;
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (this.base.equals(root)) {
                DocumentNodeStoreBranch.this.branchState = new Unmodified(this.base);
            } else if (!this.head.equals(root)) {
                this.head = root;
                this.persist();
            }
        }

        @Override
        void rebase() {
            DocumentNodeState root = DocumentNodeStoreBranch.this.store.getRoot();
            NodeBuilder builder = root.builder();
            this.head.compareAgainstBaseState(this.base, new ConflictAnnotatingRebaseDiff(builder));
            this.head = builder.getNodeState();
            this.base = root;
        }

        /*
         * Exception decompiling
         */
        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info, boolean exclusive) throws CommitFailedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class Unmodified
    extends BranchState {
        Unmodified(DocumentNodeState base) {
            super(base);
        }

        public String toString() {
            return "Unmodified[" + this.base + ']';
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.base;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.base.equals(root)) {
                DocumentNodeStoreBranch.this.branchState = new InMemory(this.base, root);
            }
        }

        @Override
        void rebase() {
            this.base = DocumentNodeStoreBranch.this.store.getRoot();
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info, boolean exclusive) {
            DocumentNodeStoreBranch.this.branchState = new Merged(this.base);
            return this.base;
        }
    }

    private abstract class BranchState {
        protected DocumentNodeState base;

        protected BranchState(DocumentNodeState base) {
            this.base = base;
        }

        Persisted persist() {
            Persisted p = new Persisted(this.base);
            p.persistTransientHead(this.getHead());
            DocumentNodeStoreBranch.this.branchState = p;
            return p;
        }

        DocumentNodeState getBase() {
            return this.base;
        }

        @Nonnull
        abstract NodeState getHead();

        abstract void setRoot(NodeState var1);

        abstract void rebase();

        @Nonnull
        abstract NodeState merge(@Nonnull CommitHook var1, @Nonnull CommitInfo var2, boolean var3) throws CommitFailedException;
    }

    private static interface Changes {
        public void with(Commit var1);
    }
}

