/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStoreHelper;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class DocumentNodeStoreHelper {
    public static void garbageReport(DocumentNodeStore dns) {
        System.out.print("Collecting top 100 nodes with most blob garbage ");
        Stopwatch sw = Stopwatch.createStarted();
        Iterable<BlobReferences> refs = DocumentNodeStoreHelper.scan(dns, new BlobGarbageSizeComparator(), 100);
        for (BlobReferences br : refs) {
            System.out.println(br);
        }
        System.out.println("Collected in " + sw.stop());
    }

    private static Iterable<BlobReferences> scan(DocumentNodeStore store, Comparator<BlobReferences> comparator, int num) {
        long totalGarbage = 0L;
        Iterable<NodeDocument> docs = DocumentNodeStoreHelper.getDocuments(store.getDocumentStore());
        PriorityQueue<BlobReferences> queue = new PriorityQueue<BlobReferences>(num, comparator);
        ArrayList blobs = Lists.newArrayList();
        long docCount = 0L;
        for (NodeDocument doc : docs) {
            if (++docCount % 10000L == 0L) {
                System.out.print(".");
            }
            blobs.clear();
            BlobReferences refs = DocumentNodeStoreHelper.collectReferences(doc, store);
            totalGarbage += refs.garbageSize;
            queue.add(refs);
            if (queue.size() <= num) continue;
            queue.remove();
        }
        System.out.println();
        ArrayList<BlobReferences> refs = Lists.newArrayList();
        refs.addAll(queue);
        Collections.sort(refs, Collections.reverseOrder(comparator));
        System.out.println("Total garbage size: " + FileUtils.byteCountToDisplaySize(totalGarbage));
        System.out.println("Total number of nodes with blob references: " + docCount);
        System.out.println("total referenced / old referenced / # blob references / path");
        return refs;
    }

    private static BlobReferences collectReferences(NodeDocument doc, DocumentNodeStore ns) {
        long blobSize = 0L;
        long garbageSize = 0L;
        int numBlobs = 0;
        ArrayList<Blob> blobs = Lists.newArrayList();
        RevisionVector head = ns.getHeadRevision();
        boolean exists = doc.getNodeAtRevision(ns, head, null) != null;
        for (String key : doc.keySet()) {
            if (!Utils.isPropertyName(key)) continue;
            boolean foundValid = false;
            SortedMap<Revision, String> valueMap = doc.getLocalMap(key);
            for (Map.Entry entry : valueMap.entrySet()) {
                blobs.clear();
                String v = (String)entry.getValue();
                if (v != null) {
                    DocumentNodeStoreHelper.loadValue(v, blobs, ns);
                }
                blobSize += DocumentNodeStoreHelper.size(blobs);
                if (foundValid) {
                    garbageSize += DocumentNodeStoreHelper.size(blobs);
                } else if (doc.isCommitted((Revision)entry.getKey())) {
                    foundValid = true;
                } else {
                    garbageSize += DocumentNodeStoreHelper.size(blobs);
                }
                numBlobs += blobs.size();
            }
        }
        return new BlobReferences(doc.getPath(), blobSize, numBlobs, garbageSize, exists);
    }

    private static Iterable<NodeDocument> getDocuments(DocumentStore store) {
        if (store instanceof MongoDocumentStore) {
            final MongoDocumentStore mds = (MongoDocumentStore)store;
            DBCollection dbCol = MongoDocumentStoreHelper.getDBCollection(mds, Collection.NODES);
            DBObject query = QueryBuilder.start("_bin").is(1L).get();
            DBCursor cursor = dbCol.find(query);
            return Iterables.transform(cursor, new Function<DBObject, NodeDocument>(){

                @Override
                @Nullable
                public NodeDocument apply(DBObject input) {
                    return MongoDocumentStoreHelper.convertFromDBObject(mds, Collection.NODES, input);
                }
            });
        }
        return Utils.getSelectedDocuments(store, "_bin", 1L);
    }

    private static long size(Iterable<Blob> blobs) {
        long size = 0L;
        for (Blob b : blobs) {
            size += b.length();
        }
        return size;
    }

    private static void loadValue(String v, java.util.Collection<Blob> blobs, DocumentNodeStore nodeStore) {
        JsopTokenizer reader = new JsopTokenizer(v);
        if (reader.matches(91)) {
            PropertyState p = DocumentPropertyState.readArrayProperty("x", nodeStore, reader);
            if (p.getType() == Type.BINARIES) {
                for (int i = 0; i < p.count(); ++i) {
                    Blob b = p.getValue(Type.BINARY, i);
                    blobs.add(b);
                }
            }
        } else {
            PropertyState p = DocumentPropertyState.readProperty("x", nodeStore, reader);
            if (p.getType() == Type.BINARY) {
                Blob b = p.getValue(Type.BINARY);
                blobs.add(b);
            }
        }
    }

    private static class BlobGarbageSizeComparator
    implements Comparator<BlobReferences> {
        private BlobGarbageSizeComparator() {
        }

        @Override
        public int compare(BlobReferences o1, BlobReferences o2) {
            int c = Longs.compare(o1.garbageSize, o2.garbageSize);
            if (c != 0) {
                return c;
            }
            return o1.path.compareTo(o2.path);
        }
    }

    private static class BlobReferences {
        final String path;
        final long blobSize;
        final long garbageSize;
        final int numBlobs;
        final boolean exists;

        public BlobReferences(String path, long blobSize, int numBlobs, long garbageSize, boolean exists) {
            this.path = path;
            this.blobSize = blobSize;
            this.garbageSize = garbageSize;
            this.numBlobs = numBlobs;
            this.exists = exists;
        }

        public String toString() {
            String s = FileUtils.byteCountToDisplaySize(this.blobSize) + "\t" + FileUtils.byteCountToDisplaySize(this.garbageSize) + "\t" + this.numBlobs + "\t" + this.path;
            if (!this.exists) {
                s = s + "\t(deleted)";
            }
            return s;
        }
    }
}

