/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClientURI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.api.jmx.PersistentCacheStatsMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.DocumentCheckpointMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsMBean;
import org.apache.jackrabbit.oak.plugins.document.LeaseFailureHandler;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStoreWrapper;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStoreStatsMBean;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.util.GenericDescriptors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak Document NodeStore Service", description="NodeStore implementation based on Document model. For configuration option refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#DocumentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported")
public class DocumentNodeStoreService {
    private static final String DEFAULT_URI = "mongodb://localhost:27017/oak";
    private static final int DEFAULT_CACHE = 256;
    private static final int DEFAULT_BLOB_CACHE_SIZE = 16;
    private static final String DEFAULT_DB = "oak";
    private static final String DEFAULT_PERSISTENT_CACHE = "";
    private static final int DEFAULT_CACHE_SEGMENT_COUNT = 16;
    private static final int DEFAULT_CACHE_STACK_MOVE_DISTANCE = 16;
    private static final String PREFIX = "oak.documentstore.";
    private static final String DESCRIPTION = "oak.nodestore.description";
    private static final String FWK_PROP_URI = "oak.mongo.uri";
    private static final String FWK_PROP_DB = "oak.mongo.db";
    @Property(value={"mongodb://localhost:27017/oak"}, label="Mongo URI", description="Mongo connection URI used to connect to Mongo. Refer to http://docs.mongodb.org/manual/reference/connection-string/ for details. Note that this value can be overridden via framework property 'oak.mongo.uri'")
    private static final String PROP_URI = "mongouri";
    @Property(value={"oak"}, label="Mongo DB name", description="Name of the database in Mongo. Note that this value can be overridden via framework property 'oak.mongo.db'")
    private static final String PROP_DB = "db";
    @Property(intValue={256}, label="Cache Size (in MB)", description="Cache size in MB. This is distributed among various caches used in DocumentNodeStore")
    private static final String PROP_CACHE = "cache";
    @Property(intValue={25}, label="NodeState Cache", description="Percentage of cache to be allocated towards Node cache")
    private static final String PROP_NODE_CACHE_PERCENTAGE = "nodeCachePercentage";
    @Property(intValue={4}, label="PreviousDocument Cache", description="Percentage of cache to be allocated towards Previous Document cache")
    private static final String PROP_PREV_DOC_CACHE_PERCENTAGE = "prevDocCachePercentage";
    @Property(intValue={10}, label="NodeState Children Cache", description="Percentage of cache to be allocated towards Children cache")
    private static final String PROP_CHILDREN_CACHE_PERCENTAGE = "childrenCachePercentage";
    @Property(intValue={5}, label="Diff Cache", description="Percentage of cache to be allocated towards Diff cache")
    private static final String PROP_DIFF_CACHE_PERCENTAGE = "diffCachePercentage";
    @Property(intValue={3}, label="Document Children Cache", description="Percentage of cache to be allocated towards Document children cache")
    private static final String PROP_DOC_CHILDREN_CACHE_PERCENTAGE = "docChildrenCachePercentage";
    @Property(intValue={16}, label="LIRS Cache Segment Count", description="The number of segments in the LIRS cache (default 16, a higher count means higher concurrency but slightly lower cache hit rate)")
    private static final String PROP_CACHE_SEGMENT_COUNT = "cacheSegmentCount";
    @Property(intValue={16}, label="LIRS Cache Stack Move Distance", description="The delay to move entries to the head of the queue in the LIRS cache (default 16, a higher value means higher concurrency but slightly lower cache hit rate)")
    private static final String PROP_CACHE_STACK_MOVE_DISTANCE = "cacheStackMoveDistance";
    @Property(intValue={16}, label="Blob Cache Size (in MB)", description="Cache size to store blobs in memory. Used only with default BlobStore (as per DocumentStore type)")
    private static final String PROP_BLOB_CACHE_SIZE = "blobCacheSize";
    @Property(value={""}, label="Persistent Cache Config", description="Configuration for enabling Persistent cache. By default it is not enabled. Refer to http://jackrabbit.apache.org/oak/docs/nodestore/persistent-cache.html for various options")
    private static final String PROP_PERSISTENT_CACHE = "persistentCache";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default, for MongoDB, MongoBlobStore is used; for RDB, RDBBlobStore is used.")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private static final long DEFAULT_JOURNAL_GC_INTERVAL_MILLIS = 300000L;
    @Property(longValue={300000L}, label="Journal Garbage Collection Interval (millis)", description="Long value indicating interval (in milliseconds) with which the journal (for external changes) is cleaned up. Default is 300000")
    private static final String PROP_JOURNAL_GC_INTERVAL_MILLIS = "journalGCInterval";
    private static final long DEFAULT_JOURNAL_GC_MAX_AGE_MILLIS = 21600000L;
    @Property(longValue={21600000L}, label="Maximum Age of Journal Entries (millis)", description="Long value indicating max age (in milliseconds) that journal (for external changes) entries are kept (older ones are candidates for gc). Default is 21600000")
    private static final String PROP_JOURNAL_GC_MAX_AGE_MILLIS = "journalGCMaxAge";
    private static final int DEFAULT_JOURNAL_GC_BATCH_SIZE = 100;
    @Property(intValue={100}, label="Batch size used for journalGC", description="The journal gc queries the journal for entries older than configured to delete them. It does so in batches to speed up the process. The batch size can be configured via this  property. The trade-off is between reducing number of operations with a larger batch size,  and consuming more memory less memory with a smaller batch size.")
    public static final String PROP_JOURNAL_GC_BATCH_SIZE = "journalGcBatchSize";
    private static final long MB = 0x100000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration reg;
    private final List<Registration> registrations = new ArrayList<Registration>();
    private WhiteboardExecutor executor;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(datasource.name=oak)")
    private volatile DataSource dataSource;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(datasource.name=oak)")
    private volatile DataSource blobDataSource;
    private DocumentMK mk;
    private ObserverTracker observerTracker;
    private ComponentContext context;
    private Whiteboard whiteboard;
    private long deactivationTimestamp = 0L;
    private static final long DEFAULT_VER_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Version GC Max Age (in secs)", description="Version Garbage Collector (GC) logic will only consider those deleted for GC which are not accessed recently (currentTime - lastModifiedTime > versionGcMaxAgeInSecs). For example as per default only those document which have been *marked* deleted 24 hrs ago will be considered for GC. This also applies how older revision of live document are GC.")
    public static final String PROP_VER_GC_MAX_AGE = "versionGcMaxAgeInSecs";
    public static final String PROP_REV_RECOVERY_INTERVAL = "lastRevRecoveryJobIntervalInSecs";
    private static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Blob GC Max Age (in secs)", description="Blob Garbage Collector (GC) logic will only consider those blobs for GC which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example as per default only those blobs which have been created 24 hrs ago will be considered for GC")
    public static final String PROP_BLOB_GC_MAX_AGE = "blobGcMaxAgeInSecs";
    private static final long DEFAULT_MAX_REPLICATION_LAG = 21600L;
    @Property(longValue={21600L}, label="Max Replication Lag (in secs)", description="Value in seconds. Determines the duration beyond which it can be safely assumed that the state on the secondaries is consistent with the primary, and it is safe to read from them")
    public static final String PROP_REPLICATION_LAG = "maxReplicationLagInSecs";
    private long maxReplicationLagInSecs = 21600L;
    @Property(options={@PropertyOption(name="MONGO", value="MONGO"), @PropertyOption(name="RDB", value="RDB")}, value={"MONGO"}, label="DocumentStore Type", description="Type of DocumentStore to use for persistence. Defaults to MONGO")
    public static final String PROP_DS_TYPE = "documentStoreType";
    private DocumentStoreType documentStoreType;
    @Reference
    private StatisticsProvider statisticsProvider;
    private boolean customBlobStore;

    @Activate
    protected void activate(ComponentContext context, Map<String, ?> config) throws Exception {
        this.context = context;
        this.whiteboard = new OsgiWhiteboard(context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(this.whiteboard);
        this.maxReplicationLagInSecs = PropertiesUtil.toLong(config.get(PROP_REPLICATION_LAG), 21600L);
        this.customBlobStore = PropertiesUtil.toBoolean(this.prop(CUSTOM_BLOB_STORE), false);
        this.documentStoreType = DocumentStoreType.fromString(PropertiesUtil.toString(config.get(PROP_DS_TYPE), "MONGO"));
        this.registerNodeStoreIfPossible();
    }

    private void registerNodeStoreIfPossible() throws IOException {
        if (this.deactivationTimestamp != 0L) {
            this.log.info("DocumentNodeStore was already unregistered ({}ms ago)", (Object)(System.currentTimeMillis() - this.deactivationTimestamp));
        } else if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
        } else if (this.customBlobStore && this.blobStore == null) {
            this.log.info("Custom BlobStore use enabled. DocumentNodeStoreService would be initialized when BlobStore would be available");
        } else if (this.documentStoreType == DocumentStoreType.RDB && (this.dataSource == null || this.blobDataSource == null)) {
            this.log.info("DataSource use enabled. DocumentNodeStoreService would be initialized when DataSource would be available (currently available: nodes: {}, blobs: {})", (Object)this.dataSource, (Object)this.blobDataSource);
        } else {
            this.registerNodeStore();
        }
    }

    private void registerNodeStore() throws IOException {
        DocumentNodeStore mns;
        boolean wrappingCustomBlobStore;
        String uri = PropertiesUtil.toString(this.prop(PROP_URI, FWK_PROP_URI), DEFAULT_URI);
        String db = PropertiesUtil.toString(this.prop(PROP_DB, FWK_PROP_DB), DEFAULT_DB);
        int cacheSize = PropertiesUtil.toInteger(this.prop(PROP_CACHE), 256);
        int nodeCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_NODE_CACHE_PERCENTAGE), 25);
        int prevDocCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_PREV_DOC_CACHE_PERCENTAGE), 25);
        int childrenCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_CHILDREN_CACHE_PERCENTAGE), 10);
        int docChildrenCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_DOC_CHILDREN_CACHE_PERCENTAGE), 3);
        int diffCachePercentage = PropertiesUtil.toInteger(this.prop(PROP_DIFF_CACHE_PERCENTAGE), 5);
        int blobCacheSize = PropertiesUtil.toInteger(this.prop(PROP_BLOB_CACHE_SIZE), 16);
        String persistentCache = PropertiesUtil.toString(this.prop(PROP_PERSISTENT_CACHE), DEFAULT_PERSISTENT_CACHE);
        int cacheSegmentCount = PropertiesUtil.toInteger(this.prop(PROP_CACHE_SEGMENT_COUNT), 16);
        int cacheStackMoveDistance = PropertiesUtil.toInteger(this.prop(PROP_CACHE_STACK_MOVE_DISTANCE), 16);
        DocumentMK.Builder mkBuilder = new DocumentMK.Builder().setStatisticsProvider(this.statisticsProvider).memoryCacheSize((long)cacheSize * 0x100000L).memoryCacheDistribution(nodeCachePercentage, prevDocCachePercentage, childrenCachePercentage, docChildrenCachePercentage, diffCachePercentage).setCacheSegmentCount(cacheSegmentCount).setCacheStackMoveDistance(cacheStackMoveDistance).setLeaseCheck(true).setLeaseFailureHandler(new LeaseFailureHandler(){

            @Override
            public void handleLeaseFailure() {
                try {
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopping oak-core...");
                    Bundle bundle = DocumentNodeStoreService.this.context.getBundleContext().getBundle();
                    bundle.stop();
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopped oak-core.");
                }
                catch (BundleException e) {
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: exception while stopping oak-core: " + (Object)((Object)e), e);
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopping DocumentNodeStoreService...");
                    DocumentNodeStoreService.this.context.disableComponent(DocumentNodeStoreService.class.getName());
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopped DocumentNodeStoreService");
                }
            }
        });
        if (persistentCache != null && persistentCache.length() > 0) {
            mkBuilder.setPersistentCache(persistentCache);
        }
        boolean bl = wrappingCustomBlobStore = this.customBlobStore && this.blobStore instanceof BlobStoreWrapper;
        if (this.customBlobStore && !wrappingCustomBlobStore) {
            Preconditions.checkNotNull(this.blobStore, "Use of custom BlobStore enabled via  [%s] but blobStore reference not initialized", CUSTOM_BLOB_STORE);
            mkBuilder.setBlobStore(this.blobStore);
        }
        if (this.documentStoreType == DocumentStoreType.RDB) {
            Preconditions.checkNotNull(this.dataSource, "DataStore type set [%s] but DataSource reference not initialized", PROP_DS_TYPE);
            if (!this.customBlobStore) {
                Preconditions.checkNotNull(this.blobDataSource, "DataStore type set [%s] but BlobDataSource reference not initialized", PROP_DS_TYPE);
                mkBuilder.setRDBConnection(this.dataSource, this.blobDataSource);
                this.log.info("Connected to datasources {} {}", (Object)this.dataSource, (Object)this.blobDataSource);
            } else {
                if (this.blobDataSource != null && this.blobDataSource != this.dataSource) {
                    this.log.info("Ignoring blobDataSource {} as custom blob store takes precedence.", (Object)this.blobDataSource);
                }
                mkBuilder.setRDBConnection(this.dataSource);
                this.log.info("Connected to datasource {}", (Object)this.dataSource);
            }
        } else {
            MongoClientURI mongoURI = new MongoClientURI(uri);
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting DocumentNodeStore with host={}, db={}, cache size (MB)={}, persistentCache={}, blobCacheSize (MB)={}, maxReplicationLagInSecs={}", mongoURI.getHosts(), db, cacheSize, persistentCache, blobCacheSize, this.maxReplicationLagInSecs);
                this.log.info("Mongo Connection details {}", (Object)MongoConnection.toString(mongoURI.getOptions()));
            }
            mkBuilder.setMaxReplicationLag(this.maxReplicationLagInSecs, TimeUnit.SECONDS);
            mkBuilder.setMongoDB(uri, db, blobCacheSize);
            this.log.info("Connected to database '{}'", (Object)db);
        }
        if (wrappingCustomBlobStore) {
            ((BlobStoreWrapper)this.blobStore).setBlobStore(mkBuilder.getBlobStore());
            mkBuilder.setBlobStore(this.blobStore);
        }
        mkBuilder.setExecutor(this.executor);
        this.mk = mkBuilder.open();
        GenericDescriptors clusterIdDesc = new GenericDescriptors();
        clusterIdDesc.put("oak.clusterid", new SimpleValueFactory().createValue(ClusterRepositoryInfo.getOrCreateId(this.mk.getNodeStore())), true, false);
        this.whiteboard.register(Descriptors.class, clusterIdDesc, Collections.emptyMap());
        if (SharedDataStoreUtils.isShared(this.blobStore)) {
            try {
                String repoId = ClusterRepositoryInfo.getOrCreateId(this.mk.getNodeStore());
                ((SharedDataStore)((Object)this.blobStore)).addMetadataRecord(new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(repoId));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
        }
        this.registerJMXBeans(this.mk.getNodeStore(), mkBuilder);
        this.registerLastRevRecoveryJob(this.mk.getNodeStore());
        this.registerJournalGC(this.mk.getNodeStore());
        DocumentNodeStore store = mns = this.mk.getNodeStore();
        this.observerTracker = new ObserverTracker(mns);
        this.observerTracker.start(this.context.getBundleContext());
        DocumentStore ds = this.mk.getDocumentStore();
        long maxDiff = Long.parseLong(System.getProperty("oak.documentMK.maxServerTimeDiffMillis", "2000"));
        try {
            if (maxDiff >= 0L) {
                long timeDiff = ds.determineServerTimeDifferenceMillis();
                this.log.info("registerNodeStore: server time difference: {}ms (max allowed: {}ms)", (Object)timeDiff, (Object)maxDiff);
                if (Math.abs(timeDiff) > maxDiff) {
                    throw new AssertionError((Object)("Server clock seems off (" + timeDiff + "ms) by more than configured amount (" + maxDiff + "ms)"));
                }
            }
        }
        catch (RuntimeException e) {
            this.log.warn("registerNodeStore: got RuntimeException while trying to determine time difference to server: " + e, e);
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", DocumentNodeStore.class.getName());
        ((Dictionary)props).put(DESCRIPTION, DocumentNodeStoreService.getMetadata(ds));
        this.reg = this.context.getBundleContext().registerService(new String[]{NodeStore.class.getName(), DocumentNodeStore.class.getName(), Clusterable.class.getName()}, (Object)store, props);
    }

    @Deactivate
    protected void deactivate() {
        if (this.observerTracker != null) {
            this.observerTracker.stop();
        }
        this.unregisterNodeStore();
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.log.info("Initializing DocumentNodeStore with BlobStore [{}]", (Object)blobStore);
        this.blobStore = blobStore;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    protected void bindDataSource(DataSource dataSource) throws IOException {
        this.log.info("Initializing DocumentNodeStore with dataSource [{}]", (Object)dataSource);
        this.dataSource = dataSource;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindDataSource(DataSource dataSource) {
        this.dataSource = null;
        this.unregisterNodeStore();
    }

    protected void bindBlobDataSource(DataSource dataSource) throws IOException {
        this.log.info("Initializing DocumentNodeStore with blobDataSource [{}]", (Object)dataSource);
        this.blobDataSource = dataSource;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindBlobDataSource(DataSource dataSource) {
        this.blobDataSource = null;
        this.unregisterNodeStore();
    }

    private void unregisterNodeStore() {
        this.deactivationTimestamp = System.currentTimeMillis();
        for (Registration r : this.registrations) {
            r.unregister();
        }
        this.registrations.clear();
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
        if (this.mk != null) {
            this.mk.dispose();
            this.mk = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    private void registerJMXBeans(final DocumentNodeStore store, DocumentMK.Builder mkBuilder) throws IOException {
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getNodeCacheStats(), "CacheStats", store.getNodeCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getNodeChildrenCacheStats(), "CacheStats", store.getNodeChildrenCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getDocChildrenCacheStats(), "CacheStats", store.getDocChildrenCacheStats().getName()));
        for (CacheStats cs : store.getDiffCacheStats()) {
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, cs, "CacheStats", cs.getName()));
        }
        DocumentStore ds = store.getDocumentStore();
        if (ds.getCacheStats() != null) {
            for (CacheStats cacheStats : ds.getCacheStats()) {
                this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, cacheStats, "CacheStats", cacheStats.getName()));
            }
        }
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CheckpointMBean.class, new DocumentCheckpointMBean(store), "CheckpointManger", "Document node store checkpoint management"));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, DocumentNodeStoreMBean.class, store.getMBean(), "DocumentNodeStore", "Document node store management"));
        if (mkBuilder.getBlobStoreCacheStats() != null) {
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, mkBuilder.getBlobStoreCacheStats(), "CacheStats", mkBuilder.getBlobStoreCacheStats().getName()));
        }
        if (mkBuilder.getDocumentStoreStatsCollector() instanceof DocumentStoreStatsMBean) {
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, DocumentStoreStatsMBean.class, (DocumentStoreStatsMBean)((Object)mkBuilder.getDocumentStoreStatsCollector()), "DocumentStoreStats", "DocumentStore Statistics"));
        }
        Map<CacheType, PersistentCacheStats> persistenceCacheStats = mkBuilder.getPersistenceCacheStats();
        for (PersistentCacheStats pcs : persistenceCacheStats.values()) {
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, PersistentCacheStatsMBean.class, pcs, "PersistentCacheStats", pcs.getName()));
        }
        final long versionGcMaxAgeInSecs = PropertiesUtil.toLong(this.prop(PROP_VER_GC_MAX_AGE), 86400L);
        long blobGcMaxAgeInSecs = PropertiesUtil.toLong(this.prop(PROP_BLOB_GC_MAX_AGE), 86400L);
        if (store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            MarkSweepGarbageCollector gc = store.createBlobGarbageCollector(blobGcMaxAgeInSecs, ClusterRepositoryInfo.getOrCreateId(this.mk.getNodeStore()));
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, BlobGCMBean.class, new BlobGC(gc, this.executor), "BlobGarbageCollection", "Document node store blob garbage collection"));
        }
        RevisionGC revisionGC = new RevisionGC(new Runnable(){

            @Override
            public void run() {
                try {
                    store.getVersionGarbageCollector().gc(versionGcMaxAgeInSecs, TimeUnit.SECONDS);
                }
                catch (IOException e) {
                    DocumentNodeStoreService.this.log.warn("Error occurred while executing the Version Garbage Collector", e);
                }
            }
        }, this.executor);
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, RevisionGCMBean.class, revisionGC, "RevisionGarbageCollection", "Document node store revision garbage collection"));
        BlobStoreStats blobStoreStats = mkBuilder.getBlobStoreStats();
        if (!this.customBlobStore && blobStoreStats != null) {
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, BlobStoreStatsMBean.class, blobStoreStats, "BlobStoreStats", ds.getClass().getSimpleName()));
        }
    }

    private void registerLastRevRecoveryJob(final DocumentNodeStore nodeStore) {
        long leaseTime = PropertiesUtil.toLong(this.context.getProperties().get(PROP_REV_RECOVERY_INTERVAL), ClusterNodeInfo.DEFAULT_LEASE_DURATION_MILLIS);
        Runnable recoverJob = new Runnable(){

            @Override
            public void run() {
                nodeStore.getLastRevRecoveryAgent().performRecoveryIfNeeded();
            }
        };
        this.registrations.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, recoverJob, TimeUnit.MILLISECONDS.toSeconds(leaseTime)));
    }

    private void registerJournalGC(final DocumentNodeStore nodeStore) {
        long journalGCInterval = PropertiesUtil.toLong(this.context.getProperties().get(PROP_JOURNAL_GC_INTERVAL_MILLIS), 300000L);
        final long journalGCMaxAge = PropertiesUtil.toLong(this.context.getProperties().get(PROP_JOURNAL_GC_MAX_AGE_MILLIS), 21600000L);
        final int journalGCBatchSize = PropertiesUtil.toInteger(this.context.getProperties().get(PROP_JOURNAL_GC_BATCH_SIZE), 100);
        Runnable journalGCJob = new Runnable(){

            @Override
            public void run() {
                nodeStore.getJournalGarbageCollector().gc(journalGCMaxAge, journalGCBatchSize, TimeUnit.MILLISECONDS);
            }
        };
        this.registrations.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, journalGCJob, TimeUnit.MILLISECONDS.toSeconds(journalGCInterval), true));
    }

    private Object prop(String propName) {
        return this.prop(propName, PREFIX + propName);
    }

    private Object prop(String propName, String fwkPropName) {
        return OsgiUtil.lookupFrameworkThenConfiguration(this.context, propName, fwkPropName);
    }

    private static String[] getMetadata(DocumentStore ds) {
        HashMap<String, String> meta = new HashMap<String, String>(ds.getMetadata());
        meta.put("nodeStoreType", "document");
        String[] result = new String[meta.size()];
        int i = 0;
        for (Map.Entry e : meta.entrySet()) {
            result[i++] = (String)e.getKey() + "=" + (String)e.getValue();
        }
        return result;
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }

    private static enum DocumentStoreType {
        MONGO,
        RDB;


        static DocumentStoreType fromString(String type) {
            if (type == null) {
                return MONGO;
            }
            return DocumentStoreType.valueOf(type.toUpperCase(Locale.ROOT));
        }
    }
}

