/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalGarbageCollector {
    private final DocumentStore ds;
    private static final Logger log = LoggerFactory.getLogger(JournalGarbageCollector.class);

    public JournalGarbageCollector(DocumentNodeStore nodeStore) {
        this.ds = nodeStore.getDocumentStore();
    }

    public int gc(long maxRevisionAge, int batchSize, TimeUnit unit) {
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        if (log.isDebugEnabled()) {
            log.debug("gc: Journal garbage collection starts with maxAge: {} min., batch size: {}.", (Object)TimeUnit.MILLISECONDS.toMinutes(maxRevisionAgeInMillis), (Object)batchSize);
        }
        Stopwatch sw = Stopwatch.createStarted();
        List<ClusterNodeInfoDocument> clusterNodeInfos = ClusterNodeInfoDocument.all(this.ds);
        int numDeleted = 0;
        block0: for (ClusterNodeInfoDocument clusterNodeInfoDocument : clusterNodeInfos) {
            int clusterNodeId = clusterNodeInfoDocument.getClusterId();
            boolean branch = false;
            long startPointer = 0L;
            while (true) {
                String toKey;
                String fromKey;
                List<JournalEntry> deletionBatch;
                if ((deletionBatch = this.ds.query(Collection.JOURNAL, fromKey = JournalEntry.asId(new Revision(startPointer, 0, clusterNodeId, branch)), toKey = JournalEntry.asId(new Revision(System.currentTimeMillis() - maxRevisionAgeInMillis, Integer.MAX_VALUE, clusterNodeId, branch)), batchSize)).size() > 0) {
                    this.ds.remove(Collection.JOURNAL, this.asKeys(deletionBatch));
                    numDeleted += deletionBatch.size();
                }
                if (deletionBatch.size() < batchSize) {
                    if (branch) continue block0;
                    startPointer = 0L;
                    branch = true;
                    continue;
                }
                startPointer = deletionBatch.get(deletionBatch.size() - 1).getRevisionTimestamp();
            }
        }
        sw.stop();
        log.info("gc: Journal garbage collection took {}, deleted {} entries that were older than {} min.", sw, numDeleted, TimeUnit.MILLISECONDS.toMinutes(maxRevisionAgeInMillis));
        return numDeleted;
    }

    private List<String> asKeys(List<JournalEntry> deletionBatch) {
        ArrayList<String> keys = new ArrayList<String>(deletionBatch.size());
        for (JournalEntry e : deletionBatch) {
            keys.add(e.getId());
        }
        return keys;
    }
}

