/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingLastRevSeeker {
    private static final Logger LOG = LoggerFactory.getLogger(MissingLastRevSeeker.class);
    protected final String ROOT_PATH = "/";
    private final DocumentStore store;

    public MissingLastRevSeeker(DocumentStore store) {
        this.store = store;
    }

    public Iterable<ClusterNodeInfoDocument> getAllClusters() {
        return ClusterNodeInfoDocument.all(this.store);
    }

    public ClusterNodeInfoDocument getClusterNodeInfo(int clusterId) {
        return this.store.find(Collection.CLUSTER_NODES, String.valueOf(clusterId));
    }

    public Iterable<NodeDocument> getCandidates(final long startTime) {
        Iterable<NodeDocument> nodes = Utils.getSelectedDocuments(this.store, "_modified", NodeDocument.getModifiedInSecs(startTime));
        return Iterables.filter(nodes, new Predicate<NodeDocument>(){

            @Override
            public boolean apply(NodeDocument input) {
                Long modified = (Long)input.get("_modified");
                return modified != null && modified >= NodeDocument.getModifiedInSecs(startTime);
            }
        });
    }

    public boolean acquireRecoveryLock(int clusterId, int recoveredBy) {
        try {
            ClusterNodeInfoDocument old;
            UpdateOp update = new UpdateOp(Integer.toString(clusterId), false);
            update.notEquals("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            if (recoveredBy != 0) {
                update.set("recoveryBy", recoveredBy);
            }
            return (old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update)) != null;
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to acquire the recovery lock for clusterNodeId " + clusterId, ex);
            throw ex;
        }
    }

    public void releaseRecoveryLock(int clusterId) {
        try {
            UpdateOp update = new UpdateOp(Integer.toString(clusterId), false);
            update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.NONE.name());
            update.set("recoveryBy", null);
            update.set("state", null);
            ClusterNodeInfoDocument old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update);
            if (old == null) {
                throw new RuntimeException("ClusterNodeInfo document for " + clusterId + " missing.");
            }
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to release the recovery lock for clusterNodeId " + clusterId, ex);
            throw ex;
        }
    }

    public NodeDocument getRoot() {
        return this.store.find(Collection.NODES, Utils.getIdFromPath("/"));
    }

    public boolean isRecoveryNeeded(long currentTime) {
        for (ClusterNodeInfoDocument nodeInfo : this.getAllClusters()) {
            if (!nodeInfo.isActive() || currentTime <= nodeInfo.getLeaseEndTime() || nodeInfo.isBeingRecovered()) continue;
            return true;
        }
        return false;
    }
}

