/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;

public final class Revision
implements CacheValue {
    static final int SHALLOW_MEMORY_USAGE = 32;
    private static volatile long lastTimestamp;
    private static volatile long lastRevisionTimestamp;
    private static volatile int lastRevisionCount;
    private final long timestamp;
    private final int counter;
    private final int clusterId;
    private final boolean branch;
    private static Clock clock;

    static void setClock(Clock c) {
        Preconditions.checkNotNull(c);
        clock = c;
    }

    static void resetClockToDefault() {
        clock = Clock.SIMPLE;
        lastTimestamp = clock.getTime();
        lastRevisionTimestamp = clock.getTime();
    }

    public Revision(long timestamp, int counter, int clusterId) {
        this(timestamp, counter, clusterId, false);
    }

    public Revision(long timestamp, int counter, int clusterId, boolean branch) {
        this.timestamp = timestamp;
        this.counter = counter;
        this.clusterId = clusterId;
        this.branch = branch;
    }

    int compareRevisionTime(Revision other) {
        int comp;
        if (this.clusterId != other.clusterId) {
            throw new IllegalArgumentException("Trying to compare revisions of different cluster ids: " + this + " and " + other);
        }
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            comp = this.counter < other.counter ? -1 : (this.counter > other.counter ? 1 : 0);
        }
        return comp;
    }

    int compareRevisionTimeThenClusterId(Revision other) {
        int comp;
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            int n2 = this.counter < other.counter ? -1 : (comp = this.counter > other.counter ? 1 : 0);
        }
        if (comp == 0) {
            comp = this.compareClusterId(other);
        }
        return comp;
    }

    int compareTo(Revision other) {
        int comp = this.compareRevisionTimeThenClusterId(other);
        if (comp == 0 && this.branch != other.branch) {
            return this.branch ? -1 : 1;
        }
        return comp;
    }

    int compareClusterId(Revision other) {
        return this.clusterId < other.clusterId ? -1 : (this.clusterId > other.clusterId ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Revision newRevision(int clusterId) {
        long timestamp = Revision.getCurrentTimestamp();
        Class<Revision> clazz = Revision.class;
        synchronized (Revision.class) {
            int c;
            if (timestamp < lastRevisionTimestamp) {
                timestamp = lastRevisionTimestamp;
            }
            if (timestamp == lastRevisionTimestamp) {
                c = ++lastRevisionCount;
            } else {
                lastRevisionTimestamp = timestamp;
                c = 0;
                lastRevisionCount = 0;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return new Revision(timestamp, c, clusterId);
        }
    }

    public static long getCurrentTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (clock != null) {
            timestamp = clock.getTime();
        }
        if (timestamp < lastTimestamp) {
            timestamp = lastTimestamp;
        } else if (timestamp > lastTimestamp) {
            lastTimestamp = timestamp;
        }
        return timestamp;
    }

    public static long getTimestampDifference(Revision r1, Revision r2) {
        return r1.getTimestamp() - r2.getTimestamp();
    }

    public static Revision fromString(String rev) {
        boolean isBranch = false;
        if (rev.startsWith("b")) {
            isBranch = true;
            rev = rev.substring(1);
        }
        if (!rev.startsWith("r")) {
            throw new IllegalArgumentException(rev);
        }
        int idxCount = rev.indexOf(45);
        if (idxCount < 0) {
            throw new IllegalArgumentException(rev);
        }
        int idxClusterId = rev.indexOf(45, idxCount + 1);
        if (idxClusterId < 0) {
            throw new IllegalArgumentException(rev);
        }
        String t = rev.substring(1, idxCount);
        long timestamp = Long.parseLong(t, 16);
        t = rev.substring(idxCount + 1, idxClusterId);
        int c = Integer.parseInt(t, 16);
        t = rev.substring(idxClusterId + 1);
        int clusterId = Integer.parseInt(t, 16);
        return new Revision(timestamp, c, clusterId, isBranch);
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        if (this.branch) {
            sb.append('b');
        }
        sb.append('r');
        sb.append(Long.toHexString(this.timestamp)).append('-');
        if (this.counter < 10) {
            sb.append(this.counter);
        } else {
            sb.append(Integer.toHexString(this.counter));
        }
        sb.append('-');
        if (this.clusterId < 10) {
            sb.append(this.clusterId);
        } else {
            sb.append(Integer.toHexString(this.clusterId));
        }
        return sb;
    }

    public String toReadableString() {
        StringBuilder buff = new StringBuilder();
        buff.append("revision: \"").append(this.toString()).append("\"");
        buff.append(", clusterId: ").append(this.clusterId);
        buff.append(", time: \"").append(Utils.timestampToString(this.timestamp)).append("\"");
        if (this.counter > 0) {
            buff.append(", counter: ").append(this.counter);
        }
        if (this.branch) {
            buff.append(", branch: true");
        }
        return buff.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isBranch() {
        return this.branch;
    }

    public Revision asBranchRevision() {
        if (this.isBranch()) {
            return this;
        }
        return new Revision(this.timestamp, this.counter, this.clusterId, true);
    }

    public Revision asTrunkRevision() {
        if (!this.isBranch()) {
            return this;
        }
        return new Revision(this.timestamp, this.counter, this.clusterId);
    }

    public int hashCode() {
        return (int)(this.timestamp >>> 32) ^ (int)this.timestamp ^ this.counter ^ this.clusterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Revision r = (Revision)other;
        return r.timestamp == this.timestamp && r.counter == this.counter && r.clusterId == this.clusterId && r.branch == this.branch;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public int getMemory() {
        return 32;
    }
}

