/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Revision;

public final class UpdateOp {
    final String id;
    private boolean isNew;
    private boolean isDelete;
    private final Map<Key, Operation> changes;
    private Map<Key, Condition> conditions;

    public UpdateOp(String id, boolean isNew) {
        this(id, isNew, false, new HashMap<Key, Operation>(), null);
    }

    private UpdateOp(@Nonnull String id, boolean isNew, boolean isDelete, @Nonnull Map<Key, Operation> changes, @Nullable Map<Key, Condition> conditions) {
        this.id = Preconditions.checkNotNull(id);
        this.isNew = isNew;
        this.isDelete = isDelete;
        this.changes = Preconditions.checkNotNull(changes);
        this.conditions = conditions;
    }

    static UpdateOp combine(String id, Iterable<UpdateOp> ops) {
        HashMap<Key, Operation> changes = Maps.newHashMap();
        HashMap<Key, Condition> conditions = Maps.newHashMap();
        for (UpdateOp op : ops) {
            changes.putAll(op.getChanges());
            if (op.conditions == null) continue;
            conditions.putAll(op.conditions);
        }
        if (conditions.isEmpty()) {
            conditions = null;
        }
        return new UpdateOp(id, false, false, changes, conditions);
    }

    public UpdateOp shallowCopy(String id) {
        return new UpdateOp(id, this.isNew, this.isDelete, this.changes, this.conditions);
    }

    public UpdateOp copy() {
        HashMap<Key, Condition> conditionMap = null;
        if (this.conditions != null) {
            conditionMap = new HashMap<Key, Condition>(this.conditions);
        }
        return new UpdateOp(this.id, this.isNew, this.isDelete, new HashMap<Key, Operation>(this.changes), conditionMap);
    }

    public String getId() {
        return this.id;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    boolean isDelete() {
        return this.isDelete;
    }

    public Map<Key, Operation> getChanges() {
        return this.changes;
    }

    public Map<Key, Condition> getConditions() {
        if (this.conditions == null) {
            return Collections.emptyMap();
        }
        return this.conditions;
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    void setMapEntry(@Nonnull String property, @Nonnull Revision revision, String value) {
        Operation op = new Operation(Operation.Type.SET_MAP_ENTRY, value);
        this.changes.put(new Key(property, Preconditions.checkNotNull(revision)), op);
    }

    public void removeMapEntry(@Nonnull String property, @Nonnull Revision revision) {
        Operation op = new Operation(Operation.Type.REMOVE_MAP_ENTRY, null);
        this.changes.put(new Key(property, Preconditions.checkNotNull(revision)), op);
    }

    public void set(String property, long value) {
        this.internalSet(property, value);
    }

    public void set(String property, boolean value) {
        this.internalSet(property, value);
    }

    public void set(String property, String value) {
        this.internalSet(property, value);
    }

    <T> void max(String property, Comparable<T> value) {
        Operation op = new Operation(Operation.Type.MAX, value);
        this.changes.put(new Key(property, null), op);
    }

    void unsetMapEntry(@Nonnull String property, @Nonnull Revision revision) {
        this.changes.remove(new Key(property, Preconditions.checkNotNull(revision)));
    }

    void containsMapEntry(@Nonnull String property, @Nonnull Revision revision, boolean exists) {
        if (this.isNew) {
            throw new IllegalStateException("Cannot use containsMapEntry() on new document");
        }
        Condition c = exists ? Condition.EXISTS : Condition.MISSING;
        this.getOrCreateConditions().put(new Key(property, Preconditions.checkNotNull(revision)), c);
    }

    void equals(@Nonnull String property, @Nullable Object value) {
        this.equals(property, null, value);
    }

    void equals(@Nonnull String property, @Nullable Revision revision, @Nullable Object value) {
        if (this.isNew) {
            throw new IllegalStateException("Cannot perform equals check on new document");
        }
        this.getOrCreateConditions().put(new Key(property, revision), Condition.newEqualsCondition(value));
    }

    void notEquals(@Nonnull String property, @Nullable Object value) {
        this.notEquals(property, null, value);
    }

    void notEquals(@Nonnull String property, @Nullable Revision revision, @Nullable Object value) {
        if (this.isNew) {
            throw new IllegalStateException("Cannot perform notEquals check on new document");
        }
        this.getOrCreateConditions().put(new Key(property, revision), Condition.newNotEqualsCondition(value));
    }

    public void increment(@Nonnull String property, long value) {
        Operation op = new Operation(Operation.Type.INCREMENT, value);
        this.changes.put(new Key(property, null), op);
    }

    public UpdateOp getReverseOperation() {
        UpdateOp reverse = new UpdateOp(this.id, this.isNew);
        for (Map.Entry<Key, Operation> e : this.changes.entrySet()) {
            Operation r = e.getValue().getReverse();
            if (r == null) continue;
            reverse.changes.put(e.getKey(), r);
        }
        return reverse;
    }

    public String toString() {
        String s = "key: " + this.id + " " + (this.isNew ? "new" : "update") + " " + this.changes;
        if (this.conditions != null) {
            s = s + " conditions " + this.conditions;
        }
        return s;
    }

    private Map<Key, Condition> getOrCreateConditions() {
        if (this.conditions == null) {
            this.conditions = Maps.newHashMap();
        }
        return this.conditions;
    }

    private void internalSet(String property, Object value) {
        Operation op = new Operation(Operation.Type.SET, value);
        this.changes.put(new Key(property, null), op);
    }

    public static final class Key {
        private final String name;
        private final Revision revision;

        public Key(@Nonnull String name, @Nullable Revision revision) {
            this.name = Preconditions.checkNotNull(name);
            this.revision = revision;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public Revision getRevision() {
            return this.revision;
        }

        public String toString() {
            String s = this.name;
            if (this.revision != null) {
                s = s + "." + this.revision.toString();
            }
            return s;
        }

        public int hashCode() {
            int hash = this.name.hashCode();
            if (this.revision != null) {
                hash ^= this.revision.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.name.equals(other.name) && (this.revision != null ? this.revision.equals(other.revision) : other.revision == null);
            }
            return false;
        }
    }

    public static final class Condition {
        public static final Condition EXISTS = new Condition(Type.EXISTS, true);
        public static final Condition MISSING = new Condition(Type.EXISTS, false);
        public final Type type;
        public final Object value;

        private Condition(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        public static Condition newEqualsCondition(@Nullable Object value) {
            return new Condition(Type.EQUALS, value);
        }

        public static Condition newNotEqualsCondition(@Nullable Object value) {
            return new Condition(Type.NOTEQUALS, value);
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.value;
        }

        public static enum Type {
            EXISTS,
            EQUALS,
            NOTEQUALS;

        }
    }

    public static final class Operation {
        public final Type type;
        public final Object value;

        Operation(Type type, Object value) {
            this.type = Preconditions.checkNotNull(type);
            this.value = value;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.value;
        }

        public Operation getReverse() {
            Operation reverse = null;
            switch (this.type) {
                case INCREMENT: {
                    reverse = new Operation(Type.INCREMENT, -((Long)this.value).longValue());
                    break;
                }
                case SET: 
                case MAX: 
                case REMOVE_MAP_ENTRY: {
                    break;
                }
                case SET_MAP_ENTRY: {
                    reverse = new Operation(Type.REMOVE_MAP_ENTRY, null);
                }
            }
            return reverse;
        }

        public static enum Type {
            SET,
            MAX,
            INCREMENT,
            SET_MAP_ENTRY,
            REMOVE_MAP_ENTRY;

        }
    }
}

