/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class VersionGCSupport {
    private final DocumentStore store;

    public VersionGCSupport(DocumentStore store) {
        this.store = store;
    }

    public Iterable<NodeDocument> getPossiblyDeletedDocs(final long lastModifiedTime) {
        return Iterables.filter(Utils.getSelectedDocuments(this.store, "_deletedOnce", 1L), new Predicate<NodeDocument>(){

            @Override
            public boolean apply(NodeDocument input) {
                return input.wasDeletedOnce() && !input.hasBeenModifiedSince(lastModifiedTime);
            }
        });
    }

    public void deleteSplitDocuments(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        stats.splitDocGCCount += this.createCleanUp(gcTypes, oldestRevTimeStamp, stats).disconnect().deleteSplitDocuments();
    }

    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new SplitDocumentCleanUp(this.store, stats, this.identifyGarbage(gcTypes, oldestRevTimeStamp));
    }

    protected Iterable<NodeDocument> identifyGarbage(final Set<NodeDocument.SplitDocType> gcTypes, final long oldestRevTimeStamp) {
        return Iterables.filter(Utils.getAllDocuments(this.store), new Predicate<NodeDocument>(){

            @Override
            public boolean apply(NodeDocument doc) {
                return gcTypes.contains((Object)doc.getSplitDocType()) && doc.hasAllRevisionLessThan(oldestRevTimeStamp);
            }
        });
    }
}

