/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.locks;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.jackrabbit.oak.plugins.document.locks.BulkLock;

class BulkReadWriteLock
implements ReadWriteLock {
    private Iterable<ReadWriteLock> locks;

    public BulkReadWriteLock(Iterable<ReadWriteLock> locks) {
        this.locks = locks;
    }

    @Override
    public Lock readLock() {
        return new BulkLock(Iterables.transform(this.locks, new Function<ReadWriteLock, Lock>(){

            @Override
            public Lock apply(ReadWriteLock input) {
                return input.readLock();
            }
        }));
    }

    @Override
    public Lock writeLock() {
        return new BulkLock(Iterables.transform(this.locks, new Function<ReadWriteLock, Lock>(){

            @Override
            public Lock apply(ReadWriteLock input) {
                return input.writeLock();
            }
        }));
    }
}

