/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.locks;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Striped;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.locks.BulkLock;
import org.apache.jackrabbit.oak.plugins.document.locks.BulkReadWriteLock;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class TreeNodeDocumentLocks
implements NodeDocumentLocks {
    private final Striped<Lock> locks = Striped.lock(4096);
    private final Striped<ReadWriteLock> parentLocks = Striped.readWriteLock(2048);
    private volatile AtomicLong lockAcquisitionCounter;

    @Override
    public TreeLock acquire(String key) {
        if (this.lockAcquisitionCounter != null) {
            this.lockAcquisitionCounter.incrementAndGet();
        }
        TreeLock lock = TreeLock.shared(this.parentLocks.get(TreeNodeDocumentLocks.getParentId(key)), this.locks.get(key));
        lock.lock();
        return lock;
    }

    @Override
    public Lock acquire(Collection<String> keys) {
        if (this.lockAcquisitionCounter != null) {
            this.lockAcquisitionCounter.addAndGet(keys.size());
        }
        Iterable<String> parentKeys = Iterables.transform(keys, new Function<String, String>(){

            @Override
            public String apply(String keys) {
                return TreeNodeDocumentLocks.getParentId(keys);
            }
        });
        BulkReadWriteLock bulkParentLock = new BulkReadWriteLock(this.parentLocks.bulkGet(parentKeys));
        BulkLock bulkChildrenLock = new BulkLock(this.locks.bulkGet(keys));
        TreeLock lock = TreeLock.shared(bulkParentLock, bulkChildrenLock);
        lock.lock();
        return lock;
    }

    public TreeLock acquireExclusive(String parentKey) {
        if (this.lockAcquisitionCounter != null) {
            this.lockAcquisitionCounter.incrementAndGet();
        }
        TreeLock lock = TreeLock.exclusive(this.parentLocks.get(parentKey));
        lock.lock();
        return lock;
    }

    @Nonnull
    private static String getParentId(@Nonnull String id) {
        String parentId = Utils.getParentId(Preconditions.checkNotNull(id));
        if (parentId == null) {
            parentId = "";
        }
        return parentId;
    }

    public void resetLockAcquisitionCount() {
        this.lockAcquisitionCounter = new AtomicLong();
    }

    public long getLockAcquisitionCount() {
        if (this.lockAcquisitionCounter == null) {
            throw new IllegalStateException("The counter hasn't been initialized");
        }
        return this.lockAcquisitionCounter.get();
    }

    private static final class TreeLock
    implements Lock {
        private final Lock parentLock;
        private final Lock lock;

        private TreeLock(Lock parentLock, Lock lock) {
            this.parentLock = parentLock;
            this.lock = lock;
        }

        private static TreeLock shared(ReadWriteLock parentLock, Lock lock) {
            return new TreeLock(parentLock.readLock(), lock);
        }

        private static TreeLock exclusive(ReadWriteLock parentLock) {
            return new TreeLock(parentLock.writeLock(), null);
        }

        @Override
        public void lock() {
            this.parentLock.lock();
            if (this.lock != null) {
                this.lock.lock();
            }
        }

        @Override
        public void unlock() {
            if (this.lock != null) {
                this.lock.unlock();
            }
            this.parentLock.unlock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

