/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.AbstractIterator;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlob;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoBlobStore
extends CachingBlobStore {
    public static final String COLLECTION_BLOBS = "blobs";
    private static final Logger LOG = LoggerFactory.getLogger(MongoBlobStore.class);
    private final DB db;
    private long minLastModified;

    public MongoBlobStore(DB db) {
        this(db, 0x1000000L);
    }

    public MongoBlobStore(DB db, long cacheSize) {
        super(cacheSize);
        this.db = db;
        this.setBlockSize(2096128);
        this.initBlobCollection();
    }

    @Override
    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        String id = StringUtils.convertBytesToHex(digest);
        this.cache.put(id, data);
        MongoBlob mongoBlob = new MongoBlob();
        mongoBlob.setId(id);
        mongoBlob.setData(data);
        mongoBlob.setLevel(level);
        mongoBlob.setLastMod(System.currentTimeMillis());
        try {
            this.getBlobCollection().insert(mongoBlob);
        }
        catch (DuplicateKeyException e) {
            // empty catch block
        }
    }

    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex(blockId.getDigest());
        byte[] data = (byte[])this.cache.get(id);
        if (data == null) {
            long start = System.nanoTime();
            MongoBlob blobMongo = this.getBlob(id, 0L);
            if (blobMongo == null) {
                String message = "Did not find block " + id;
                LOG.error(message);
                throw new IOException(message);
            }
            data = blobMongo.getData();
            this.getStatsCollector().downloaded(id, System.nanoTime() - start, TimeUnit.NANOSECONDS, data.length);
            this.cache.put(id, data);
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    @Override
    public void startMark() throws IOException {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        if (this.minLastModified == 0L) {
            return;
        }
        String id = StringUtils.convertBytesToHex(blockId.getDigest());
        DBObject query = MongoBlobStore.getBlobQuery(id, this.minLastModified);
        BasicDBObject update = new BasicDBObject("$set", new BasicDBObject("lastMod", (Object)System.currentTimeMillis()));
        this.getBlobCollection().update(query, update);
    }

    @Override
    public int sweep() throws IOException {
        DBObject query = MongoBlobStore.getBlobQuery(null, this.minLastModified);
        long countBefore = this.getBlobCollection().count(query);
        this.getBlobCollection().remove(query);
        long countAfter = this.getBlobCollection().count(query);
        this.minLastModified = 0L;
        return (int)(countBefore - countAfter);
    }

    private DBCollection getBlobCollection() {
        DBCollection collection = this.db.getCollection(COLLECTION_BLOBS);
        collection.setObjectClass(MongoBlob.class);
        return collection;
    }

    private void initBlobCollection() {
        if (this.db.collectionExists(COLLECTION_BLOBS)) {
            return;
        }
        DBCollection collection = this.getBlobCollection();
        BasicDBObject index = new BasicDBObject();
        index.put("_id", (Object)1L);
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)Boolean.TRUE);
        collection.createIndex((DBObject)index, options);
    }

    private MongoBlob getBlob(String id, long lastMod) {
        DBObject query = MongoBlobStore.getBlobQuery(id, lastMod);
        ReadPreference pref = ReadPreference.secondaryPreferred();
        BasicDBObject fields = new BasicDBObject();
        fields.put("data", (Object)1);
        MongoBlob blob = (MongoBlob)this.getBlobCollection().findOne(query, (DBObject)fields, pref);
        if (blob == null) {
            pref = ReadPreference.primary();
            blob = (MongoBlob)this.getBlobCollection().findOne(query, (DBObject)fields, pref);
        }
        return blob;
    }

    private static DBObject getBlobQuery(String id, long lastMod) {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (id != null) {
            queryBuilder = queryBuilder.and("_id").is(id);
        }
        if (lastMod > 0L) {
            queryBuilder = queryBuilder.and("lastMod").lessThan(lastMod);
        }
        return queryBuilder.get();
    }

    @Override
    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        DBCollection collection = this.getBlobCollection();
        QueryBuilder queryBuilder = new QueryBuilder();
        if (chunkIds != null) {
            queryBuilder = queryBuilder.and("_id").in(chunkIds.toArray(new String[0]));
            if (maxLastModifiedTime > 0L) {
                queryBuilder = queryBuilder.and("lastMod").lessThan(maxLastModifiedTime);
            }
        }
        WriteResult result = collection.remove(queryBuilder.get());
        return result.getN();
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        DBCollection collection = this.getBlobCollection();
        BasicDBObject fields = new BasicDBObject();
        fields.put("_id", (Object)1);
        QueryBuilder builder = new QueryBuilder();
        if (maxLastModifiedTime != 0L && maxLastModifiedTime != -1L) {
            builder.and("lastMod").lessThanEquals(maxLastModifiedTime);
        }
        final DBCursor cur = collection.find(builder.get(), fields).hint(fields).addOption(4);
        return new AbstractIterator<String>(){

            @Override
            protected String computeNext() {
                MongoBlob blob;
                if (cur.hasNext() && (blob = (MongoBlob)cur.next()) != null) {
                    return blob.getId();
                }
                return (String)this.endOfData();
            }
        };
    }
}

