/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.WriteResult;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentHelper;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class MongoDocumentStoreHelper {
    public static void repair(MongoDocumentStore store, String path) {
        DBCollection col = store.getDBCollection(Collection.NODES);
        String id = Utils.getIdFromPath(path);
        NodeDocument doc = store.find(Collection.NODES, id);
        if (doc == null) {
            System.out.println("No document for path " + path);
            return;
        }
        HashSet<Revision> changes = Sets.newHashSet();
        for (String key : doc.keySet()) {
            if (!Utils.isPropertyName(key) && !NodeDocument.isDeletedEntry(key)) continue;
            changes.addAll(NodeDocumentHelper.getLocalMap(doc, key).keySet());
        }
        TreeMap<Revision, String> commitRoot = Maps.newTreeMap(NodeDocumentHelper.getLocalCommitRoot(doc));
        if (!commitRoot.keySet().retainAll(changes)) {
            System.out.println("Nothing to repair on " + path);
            return;
        }
        Long modCount = doc.getModCount();
        if (modCount == null) {
            System.err.println("Document does not have a modCount " + path);
            return;
        }
        DBObject query = QueryBuilder.start("_id").is(id).and("_modCount").is(modCount).get();
        BasicDBObject cr = new BasicDBObject();
        for (Map.Entry entry : commitRoot.entrySet()) {
            cr.put(((Revision)entry.getKey()).toString(), entry.getValue());
        }
        BasicDBObject update = new BasicDBObject();
        update.put("$set", (Object)new BasicDBObject(NodeDocumentHelper.commitRoot(), cr));
        update.put("$inc", (Object)new BasicDBObject("_modCount", (Object)1L));
        WriteResult result = col.update(query, update);
        if (result.getN() == 1) {
            int num = NodeDocumentHelper.getLocalCommitRoot(doc).size() - commitRoot.size();
            System.out.println("Removed " + num + " _commitRoot entries on " + path);
        } else {
            System.out.println("Unable to repair " + path + " (concurrent update).");
        }
    }

    public static <T extends Document> DBCollection getDBCollection(MongoDocumentStore store, Collection<T> c) {
        return store.getDBCollection(c);
    }

    public static <T extends Document> T convertFromDBObject(MongoDocumentStore store, Collection<T> col, DBObject obj) {
        return store.convertFromDBObject(col, obj);
    }
}

