/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;

public class MongoMissingLastRevSeeker
extends MissingLastRevSeeker {
    private final MongoDocumentStore store;

    public MongoMissingLastRevSeeker(MongoDocumentStore store) {
        super(store);
        this.store = store;
    }

    public CloseableIterable<NodeDocument> getCandidates(long startTime) {
        DBObject query = QueryBuilder.start("_modified").greaterThanEquals(NodeDocument.getModifiedInSecs(startTime)).get();
        BasicDBObject sortFields = new BasicDBObject("_modified", (Object)-1);
        DBCursor cursor = this.getNodeCollection().find(query).sort(sortFields).setReadPreference(ReadPreference.primary());
        return CloseableIterable.wrap(Iterables.transform(cursor, new Function<DBObject, NodeDocument>(){

            @Override
            public NodeDocument apply(DBObject input) {
                return MongoMissingLastRevSeeker.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), cursor);
    }

    @Override
    public boolean isRecoveryNeeded(long currentTime) {
        QueryBuilder query = QueryBuilder.start("state").is(ClusterNodeInfo.ClusterNodeState.ACTIVE.name()).put("leaseEnd").lessThan(currentTime).put("recoveryLock").notEquals(ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
        return this.getClusterNodeCollection().findOne(query.get()) != null;
    }

    private DBCollection getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }

    private DBCollection getClusterNodeCollection() {
        return this.store.getDBCollection(Collection.CLUSTER_NODES);
    }
}

