/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Preconditions;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.bson.BSONObject;

public class RevisionEntry
implements DBObject {
    private final Revision revision;
    private final Object value;

    public RevisionEntry(@Nonnull Revision revision, @Nullable Object value) {
        this.revision = Preconditions.checkNotNull(revision);
        this.value = value;
    }

    @Override
    public void markAsPartialObject() {
    }

    @Override
    public boolean isPartialObject() {
        return false;
    }

    @Override
    public Object put(String key, Object v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(String key) {
        return this.revision.toString().equals(key) ? this.value : null;
    }

    @Override
    public Map toMap() {
        return Collections.singletonMap(this.revision.toString(), this.value);
    }

    @Override
    public Object removeField(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(String s) {
        return this.containsField(s);
    }

    @Override
    public boolean containsField(String s) {
        return this.revision.toString().equals(s);
    }

    @Override
    public Set<String> keySet() {
        return Collections.singleton(this.revision.toString());
    }

    public String toString() {
        return JSON.serialize(this);
    }
}

