/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;

class InvalidateCacheAction<K, V>
implements CacheAction<K, V> {
    private final PersistentCache cache;
    private final Map<K, V> map;
    private final CacheWriteQueue<K, V> owner;
    private final Iterable<K> keys;

    InvalidateCacheAction(CacheWriteQueue<K, V> cacheWriteQueue, Iterable<K> keys) {
        this.owner = cacheWriteQueue;
        this.keys = keys;
        this.cache = cacheWriteQueue.getCache();
        this.map = cacheWriteQueue.getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            if (this.map != null) {
                for (K key : this.keys) {
                    this.cache.switchGenerationIfNeeded();
                    this.map.remove(key);
                }
            }
        }
        finally {
            this.decrement();
        }
    }

    @Override
    public void cancel() {
        this.decrement();
    }

    @Override
    public CacheWriteQueue<K, V> getOwner() {
        return this.owner;
    }

    @Override
    public Iterable<K> getAffectedKeys() {
        return this.keys;
    }

    private void decrement() {
        for (K key : this.keys) {
            this.owner.remove(key);
        }
    }
}

