/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.util.MapFactory;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class MapDBMapFactory
extends MapFactory {
    private final AtomicInteger counter = new AtomicInteger();
    private final DB db = ((DBMaker)((DBMaker)((DBMaker)((DBMaker)DBMaker.newTempFileDB().deleteFilesAfterClose()).closeOnJvmShutdown()).transactionDisable()).asyncWriteEnable()).make();

    public BTreeMap<String, Revision> create() {
        return this.db.createTreeMap(String.valueOf(this.counter.incrementAndGet())).valueSerializer(new RevisionSerializer()).counterEnable().makeStringMap();
    }

    private static class RevisionSerializer
    implements Serializer<Revision>,
    Serializable {
        private static final long serialVersionUID = 8648365575103098316L;
        private int size = 17;

        private RevisionSerializer() {
        }

        @Override
        public void serialize(DataOutput o, Revision r) throws IOException {
            o.writeLong(r.getTimestamp());
            o.writeInt(r.getCounter());
            o.writeInt(r.getClusterId());
            o.writeBoolean(r.isBranch());
        }

        @Override
        public Revision deserialize(DataInput i, int available) throws IOException {
            return new Revision(i.readLong(), i.readInt(), i.readInt(), i.readBoolean());
        }

        @Override
        public int fixedSize() {
            return this.size;
        }
    }
}

