/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;

public final class RevisionsKey
implements CacheValue,
Comparable<RevisionsKey> {
    private final RevisionVector r1;
    private final RevisionVector r2;

    public RevisionsKey(RevisionVector r1, RevisionVector r2) {
        this.r1 = Preconditions.checkNotNull(r1);
        this.r2 = Preconditions.checkNotNull(r2);
    }

    @Override
    public int getMemory() {
        return 32 + this.r1.getMemory() + this.r2.getMemory();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RevisionsKey)) {
            return false;
        }
        RevisionsKey other = (RevisionsKey)obj;
        return this.r1.equals(other.r1) && this.r2.equals(other.r2);
    }

    public int hashCode() {
        return this.r1.hashCode() ^ this.r2.hashCode();
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.r1 + "/" + this.r2;
    }

    @Override
    public int compareTo(@Nonnull RevisionsKey k) {
        int c = this.r1.compareTo(k.r1);
        if (c != 0) {
            return c;
        }
        return this.r2.compareTo(k.r2);
    }

    public static RevisionsKey fromString(String s) {
        int idx = s.indexOf(47);
        if (idx == -1) {
            throw new IllegalArgumentException(s);
        }
        return new RevisionsKey(RevisionVector.fromString(s.substring(0, idx)), RevisionVector.fromString(s.substring(idx + 1)));
    }
}

