/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.ApproximateCounter;

public class NodeCounterEditor
implements Editor {
    public static final String DATA_NODE_NAME = ":index";
    public static final String COUNT_PROPERTY_NAME = ":count";
    public static final int DEFAULT_RESOLUTION = 1000;
    private final NodeCounterRoot root;
    private final NodeCounterEditor parent;
    private final String name;
    private long countOffset;

    public NodeCounterEditor(NodeCounterRoot root, NodeCounterEditor parent, String name) {
        this.parent = parent;
        this.root = root;
        this.name = name;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        long offset = ApproximateCounter.calculateOffset(this.countOffset, this.root.resolution);
        if (offset == 0L) {
            return;
        }
        NodeBuilder builder = this.getBuilder();
        PropertyState p = builder.getProperty(COUNT_PROPERTY_NAME);
        long count = p == null ? 0L : p.getValue(Type.LONG);
        offset = ApproximateCounter.adjustOffset(count, offset, this.root.resolution);
        if (offset == 0L) {
            return;
        }
        this.root.callback.indexUpdate();
        if ((count += offset) == 0L) {
            if (builder.getChildNodeCount(1L) >= 0L) {
                builder.removeProperty(COUNT_PROPERTY_NAME);
            } else {
                builder.remove();
            }
        } else {
            builder.setProperty(COUNT_PROPERTY_NAME, count);
        }
    }

    private NodeBuilder getBuilder() {
        if (this.parent == null) {
            return this.root.definition.child(DATA_NODE_NAME);
        }
        return this.parent.getBuilder().child(this.name);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
    }

    @Override
    @CheckForNull
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.getChildIndexEditor(this, name);
    }

    @Override
    @CheckForNull
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        this.count(1);
        return this.getChildIndexEditor(this, name);
    }

    @Override
    @CheckForNull
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        this.count(-1);
        return this.getChildIndexEditor(this, name);
    }

    private void count(int offset) {
        this.countOffset += (long)offset;
        if (this.parent != null) {
            this.parent.count(offset);
        }
    }

    private Editor getChildIndexEditor(NodeCounterEditor nodeCounterEditor, String name) {
        return new NodeCounterEditor(this.root, this, name);
    }

    public static class NodeCounterRoot {
        int resolution = 1000;
        NodeBuilder definition;
        NodeState root;
        IndexUpdateCallback callback;
    }
}

