/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.LucenePropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetHelper;
import org.apache.jackrabbit.oak.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.lucene.index.IndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexPlanner {
    private static final Logger log = LoggerFactory.getLogger(IndexPlanner.class);
    private final IndexDefinition definition;
    private final Filter filter;
    private final String indexPath;
    private final List<QueryIndex.OrderEntry> sortOrder;
    private IndexNode indexNode;
    private PlanResult result;

    public IndexPlanner(IndexNode indexNode, String indexPath, Filter filter, List<QueryIndex.OrderEntry> sortOrder) {
        this.indexNode = indexNode;
        this.indexPath = indexPath;
        this.definition = indexNode.getDefinition();
        this.filter = filter;
        this.sortOrder = sortOrder;
    }

    QueryIndex.IndexPlan getPlan() {
        QueryIndex.IndexPlan.Builder builder = this.getPlanBuilder();
        if (this.definition.isTestMode()) {
            if (builder == null) {
                if (this.notSupportedFeature()) {
                    return null;
                }
                String msg = String.format("No plan found for filter [%s] while using definition [%s] and testMode is found to be enabled", this.filter, this.definition);
                throw new IllegalStateException(msg);
            }
            builder.setEstimatedEntryCount(1L).setCostPerExecution(0.001).setCostPerEntry(0.001);
        }
        return builder != null ? builder.build() : null;
    }

    public String toString() {
        return "IndexPlanner{indexPath='" + this.indexPath + '\'' + ", filter=" + this.filter + ", sortOrder=" + this.sortOrder + '}';
    }

    private QueryIndex.IndexPlan.Builder getPlanBuilder() {
        log.trace("Evaluating plan with index definition {}", (Object)this.definition);
        FullTextExpression ft = this.filter.getFullTextConstraint();
        if (!this.definition.getVersion().isAtLeast(IndexFormatVersion.V2)) {
            log.trace("Index is old format. Not supported");
            return null;
        }
        if (ft != null && !this.definition.isFullTextEnabled()) {
            return null;
        }
        IndexDefinition.IndexingRule indexingRule = this.getApplicableRule();
        if (indexingRule == null) {
            return null;
        }
        if (ft != null && !indexingRule.isFulltextEnabled()) {
            return null;
        }
        if (!this.checkForQueryPaths()) {
            log.trace("Opting out due mismatch between path restriction {} and query paths {}", (Object)this.filter.getPath(), (Object)this.definition.getQueryPaths());
            return null;
        }
        this.result = new PlanResult(this.indexPath, this.definition, indexingRule);
        if (this.definition.hasFunctionDefined() && this.filter.getPropertyRestriction(this.definition.getFunctionName()) != null) {
            return this.getNativeFunctionPlanBuilder(indexingRule.getBaseNodeType());
        }
        ArrayList<String> indexedProps = Lists.newArrayListWithCapacity(this.filter.getPropertyRestrictions().size());
        LinkedList<String> facetFields = new LinkedList<String>();
        if (indexingRule.propertyIndexEnabled) {
            for (Filter.PropertyRestriction pr : this.filter.getPropertyRestrictions()) {
                PropertyDefinition pd;
                String name = pr.propertyName;
                if (":localname".equals(name)) continue;
                if ("rep:facet".equals(pr.propertyName)) {
                    String value = pr.first.getValue(Type.STRING);
                    facetFields.add(FacetHelper.parseFacetField(value));
                }
                if ((pd = indexingRule.getConfig(pr.propertyName)) == null || !pd.propertyIndexEnabled() || pr.isNullRestriction() && !pd.nullCheckEnabled) continue;
                indexedProps.add(name);
                this.result.propDefns.put(name, pd);
            }
        }
        boolean evalNodeTypeRestrictions = this.canEvalNodeTypeRestrictions(indexingRule);
        boolean evalPathRestrictions = this.canEvalPathRestrictions(indexingRule);
        boolean canEvalAlFullText = this.canEvalAllFullText(indexingRule, ft);
        boolean canEvalNodeNameRestriction = this.canEvalNodeNameRestriction(indexingRule);
        if (ft != null && !canEvalAlFullText) {
            return null;
        }
        List<QueryIndex.OrderEntry> sortOrder = this.createSortOrder(indexingRule);
        boolean canSort = IndexPlanner.canSortByProperty(sortOrder);
        if (!indexedProps.isEmpty() || canSort || ft != null || evalPathRestrictions || evalNodeTypeRestrictions || canEvalNodeNameRestriction) {
            int costPerEntryFactor = indexedProps.size();
            costPerEntryFactor += sortOrder.size();
            QueryIndex.IndexPlan.Builder plan = this.defaultPlan();
            if (!sortOrder.isEmpty()) {
                plan.setSortOrder(sortOrder);
            }
            if (costPerEntryFactor == 0) {
                costPerEntryFactor = 1;
            }
            if (facetFields.size() > 0) {
                plan.setAttribute("oak.facet.fields", facetFields);
            }
            if (ft == null) {
                this.result.enableNonFullTextConstraints();
            }
            if (evalNodeTypeRestrictions) {
                this.result.enableNodeTypeEvaluation();
            }
            if (canEvalNodeNameRestriction) {
                this.result.enableNodeNameRestriction();
            }
            return plan.setCostPerEntry(this.definition.getCostPerEntry() / (double)costPerEntryFactor);
        }
        return null;
    }

    private QueryIndex.IndexPlan.Builder getNativeFunctionPlanBuilder(String indexingRuleBaseNodeType) {
        boolean canHandleNativeFunction = true;
        PropertyValue pv = this.filter.getPropertyRestriction((String)this.definition.getFunctionName()).first;
        String query = pv.getValue(Type.STRING);
        if (query.startsWith("suggest?term=")) {
            canHandleNativeFunction = this.definition.isSuggestEnabled() ? indexingRuleBaseNodeType.equals(this.filter.getNodeType()) : false;
        } else if (query.startsWith("spellcheck?term=")) {
            canHandleNativeFunction = this.definition.isSpellcheckEnabled() ? indexingRuleBaseNodeType.equals(this.filter.getNodeType()) : false;
        }
        if (canHandleNativeFunction) {
            this.result.disableUniquePaths();
        }
        return canHandleNativeFunction ? this.defaultPlan().setEstimatedEntryCount(1L) : null;
    }

    private boolean checkForQueryPaths() {
        String[] queryPaths = this.definition.getQueryPaths();
        if (queryPaths == null) {
            return true;
        }
        String pathRestriction = this.filter.getPath();
        for (String queryPath : queryPaths) {
            if (!queryPath.equals(pathRestriction) && !PathUtils.isAncestor(queryPath, pathRestriction)) continue;
            return true;
        }
        return false;
    }

    private boolean canEvalNodeNameRestriction(IndexDefinition.IndexingRule indexingRule) {
        Filter.PropertyRestriction pr = this.filter.getPropertyRestriction(":localname");
        if (pr == null) {
            return false;
        }
        return indexingRule.isNodeNameIndexed();
    }

    private static boolean canSortByProperty(List<QueryIndex.OrderEntry> sortOrder) {
        if (sortOrder.isEmpty()) {
            return false;
        }
        return sortOrder.size() != 1 || !"jcr:score".equals(sortOrder.get(0).getPropertyName());
    }

    private boolean canEvalAllFullText(final IndexDefinition.IndexingRule indexingRule, FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final HashSet relPaths = new HashSet();
        final HashSet nonIndexedPaths = new HashSet();
        final AtomicBoolean relativeParentsFound = new AtomicBoolean();
        final AtomicBoolean nodeScopedCondition = new AtomicBoolean();
        ft.accept(new FullTextVisitor.FullTextVisitorBase(){

            @Override
            public boolean visit(FullTextContains contains) {
                this.visitTerm(contains.getPropertyName());
                return true;
            }

            @Override
            public boolean visit(FullTextTerm term) {
                this.visitTerm(term.getPropertyName());
                return true;
            }

            private void visitTerm(String propertyName) {
                String p = propertyName;
                String propertyPath = null;
                String nodePath = null;
                if (p == null) {
                    relPaths.add("");
                } else if (p.startsWith("../") || p.startsWith("./")) {
                    relPaths.add(p);
                    relativeParentsFound.set(true);
                } else if (PathUtils.getDepth(p) > 1) {
                    String parent = PathUtils.getParentPath(p);
                    if (LucenePropertyIndex.isNodePath(p)) {
                        nodePath = parent;
                    } else {
                        propertyPath = p;
                    }
                    relPaths.add(parent);
                } else {
                    propertyPath = p;
                    relPaths.add("");
                }
                if (nodePath != null && !indexingRule.isAggregated(nodePath)) {
                    nonIndexedPaths.add(p);
                } else if (propertyPath != null && !indexingRule.isIndexed(propertyPath)) {
                    nonIndexedPaths.add(p);
                }
                if (IndexPlanner.nodeScopedTerm(propertyName)) {
                    nodeScopedCondition.set(true);
                }
            }
        });
        if (nodeScopedCondition.get() && !indexingRule.isNodeFullTextIndexed()) {
            return false;
        }
        if (relativeParentsFound.get()) {
            log.debug("Relative parents found {} which are not supported", (Object)relPaths);
            return false;
        }
        if (!nonIndexedPaths.isEmpty()) {
            if (relPaths.size() > 1) {
                log.debug("Following relative  property paths are not index", (Object)relPaths);
                return false;
            }
            this.result.setParentPath(Iterables.getOnlyElement(relPaths, ""));
            return this.definition.indexesAllTypes();
        }
        this.result.setParentPath("");
        return true;
    }

    private boolean canEvalPathRestrictions(IndexDefinition.IndexingRule rule) {
        if (this.filter.getPathRestriction() == Filter.PathRestriction.NO_RESTRICTION || this.filter.getPathRestriction() == Filter.PathRestriction.ALL_CHILDREN && PathUtils.denotesRoot(this.filter.getPath())) {
            return false;
        }
        return this.definition.evaluatePathRestrictions() && rule.indexesAllNodesOfMatchingType();
    }

    private boolean canEvalNodeTypeRestrictions(IndexDefinition.IndexingRule rule) {
        if (this.filter.matchesAllTypes()) {
            return false;
        }
        return rule.indexesAllNodesOfMatchingType() && !rule.isBasedOnNtBase();
    }

    private QueryIndex.IndexPlan.Builder defaultPlan() {
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(this.definition.getCostPerExecution()).setCostPerEntry(this.definition.getCostPerEntry()).setFulltextIndex(this.definition.isFullTextEnabled()).setIncludesNodeData(false).setFilter(this.filter).setPathPrefix(this.getPathPrefix()).setDelayed(true).setAttribute("oak.lucene.planResult", this.result).setEstimatedEntryCount(this.estimatedEntryCount()).setPlanName(this.indexPath);
    }

    private long estimatedEntryCount() {
        FullTextExpression ft = this.filter.getFullTextConstraint();
        if (ft != null && this.definition.isFullTextEnabled()) {
            return this.definition.getFulltextEntryCount(this.getReader().numDocs());
        }
        return Math.min(this.definition.getEntryCount(), (long)this.getReader().numDocs());
    }

    private String getPathPrefix() {
        String parentPath = PathUtils.getAncestorPath(this.indexPath, 2);
        return PathUtils.denotesRoot(parentPath) ? "" : parentPath;
    }

    private IndexReader getReader() {
        return this.indexNode.getSearcher().getIndexReader();
    }

    private List<QueryIndex.OrderEntry> createSortOrder(IndexDefinition.IndexingRule rule) {
        if (this.sortOrder == null) {
            return Collections.emptyList();
        }
        ArrayList<QueryIndex.OrderEntry> orderEntries = Lists.newArrayListWithCapacity(this.sortOrder.size());
        for (QueryIndex.OrderEntry o : this.sortOrder) {
            PropertyDefinition pd = rule.getConfig(o.getPropertyName());
            if (pd != null && pd.ordered && o.getPropertyType() != null && !o.getPropertyType().isArray()) {
                orderEntries.add(o);
                this.result.sortedProperties.add(pd);
                continue;
            }
            if (!o.getPropertyName().equals(IndexDefinition.NATIVE_SORT_ORDER.getPropertyName())) continue;
            orderEntries.add(IndexDefinition.NATIVE_SORT_ORDER);
        }
        return orderEntries;
    }

    @CheckForNull
    private IndexDefinition.IndexingRule getApplicableRule() {
        if (this.filter.matchesAllTypes()) {
            return this.definition.getApplicableIndexingRule("nt:base");
        }
        for (IndexDefinition.IndexingRule rule : this.definition.getDefinedRules()) {
            IndexDefinition.IndexingRule matchingRule;
            if (this.filter.getSupertypes().contains(rule.getNodeTypeName()) && (matchingRule = this.definition.getApplicableIndexingRule(rule.getNodeTypeName())) != null) {
                log.debug("Applicable IndexingRule found {}", (Object)matchingRule);
                return rule;
            }
            if (!rule.getNodeTypeName().equals("nt:base")) continue;
            return rule;
        }
        log.trace("No applicable IndexingRule found for any of the superTypes {}", (Object)this.filter.getSupertypes());
        return null;
    }

    private boolean notSupportedFeature() {
        return this.filter.getPathRestriction() == Filter.PathRestriction.NO_RESTRICTION && this.filter.matchesAllTypes() && this.filter.getPropertyRestrictions().isEmpty();
    }

    private static boolean nodeScopedTerm(String propertyName) {
        return propertyName == null || ".".equals(propertyName) || "*".equals(propertyName);
    }

    public static class PlanResult {
        final String indexPath;
        final IndexDefinition indexDefinition;
        final IndexDefinition.IndexingRule indexingRule;
        private List<PropertyDefinition> sortedProperties = Lists.newArrayList();
        private Map<String, PropertyDefinition> propDefns = Maps.newHashMap();
        private boolean nonFullTextConstraints;
        private int parentDepth;
        private String parentPathSegment;
        private boolean relativize;
        private boolean nodeTypeRestrictions;
        private boolean nodeNameRestriction;
        private boolean uniquePathsRequired = true;

        public PlanResult(String indexPath, IndexDefinition defn, IndexDefinition.IndexingRule indexingRule) {
            this.indexPath = indexPath;
            this.indexDefinition = defn;
            this.indexingRule = indexingRule;
        }

        public PropertyDefinition getPropDefn(Filter.PropertyRestriction pr) {
            return this.propDefns.get(pr.propertyName);
        }

        public PropertyDefinition getOrderedProperty(int index) {
            return this.sortedProperties.get(index);
        }

        public boolean isPathTransformed() {
            return this.relativize;
        }

        public boolean isUniquePathsRequired() {
            return this.uniquePathsRequired;
        }

        @CheckForNull
        public String transformPath(String path) {
            if (this.isPathTransformed()) {
                if (!path.endsWith(this.parentPathSegment)) {
                    return null;
                }
                return PathUtils.getAncestorPath(path, this.parentDepth);
            }
            return path;
        }

        public boolean evaluateNonFullTextConstraints() {
            return this.nonFullTextConstraints;
        }

        public boolean evaluateNodeTypeRestriction() {
            return this.nodeTypeRestrictions;
        }

        public boolean evaluateNodeNameRestriction() {
            return this.nodeNameRestriction;
        }

        private void setParentPath(String relativePath) {
            this.parentPathSegment = "/" + relativePath;
            if (relativePath.isEmpty()) {
                this.enableNonFullTextConstraints();
            } else {
                this.relativize = true;
                this.parentDepth = PathUtils.getDepth(relativePath);
            }
        }

        private void enableNonFullTextConstraints() {
            this.nonFullTextConstraints = true;
        }

        private void enableNodeTypeEvaluation() {
            this.nodeTypeRestrictions = true;
        }

        private void enableNodeNameRestriction() {
            this.nodeNameRestriction = true;
        }

        private void disableUniquePaths() {
            this.uniquePathsRequired = false;
        }
    }
}

