/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.io.LazyInputStream;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.PathFilter;
import org.apache.jackrabbit.oak.plugins.index.fulltext.ExtractedText;
import org.apache.jackrabbit.oak.plugins.index.lucene.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.BlobByteSource;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.WriteOutContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditor
implements IndexEditor,
Aggregate.AggregateRoot {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditor.class);
    static final String TEXT_EXTRACTION_ERROR = "TextExtractionError";
    private final LuceneIndexEditorContext context;
    private final String name;
    private final LuceneIndexEditor parent;
    private String path;
    private boolean propertiesChanged = false;
    private List<PropertyState> propertiesModified = Lists.newArrayList();
    private final NodeState root;
    private final boolean isDeleted;
    private Tree afterTree;
    private Tree beforeTree;
    private IndexDefinition.IndexingRule indexingRule;
    private List<Aggregate.Matcher> currentMatchers = Collections.emptyList();
    private final MatcherState matcherState;
    private final PathFilter.Result pathFilterResult;

    LuceneIndexEditor(NodeState root, NodeBuilder definition, IndexUpdateCallback updateCallback, @Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache, IndexAugmentorFactory augmentorFactory) throws CommitFailedException {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.context = new LuceneIndexEditorContext(root, definition, updateCallback, indexCopier, extractedTextCache, augmentorFactory);
        this.root = root;
        this.isDeleted = false;
        this.matcherState = MatcherState.NONE;
        this.pathFilterResult = this.context.getDefinition().getPathFilter().filter(this.getPath());
    }

    private LuceneIndexEditor(LuceneIndexEditor parent, String name, MatcherState matcherState, PathFilter.Result pathFilterResult, boolean isDeleted) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.context = parent.context;
        this.root = parent.root;
        this.isDeleted = isDeleted;
        this.matcherState = matcherState;
        this.pathFilterResult = pathFilterResult;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        if (EmptyNodeState.MISSING_NODE == before && this.parent == null) {
            this.context.enableReindexMode();
        }
        if (this.parent == null) {
            this.afterTree = TreeFactory.createReadOnlyTree(after);
            this.beforeTree = TreeFactory.createReadOnlyTree(before);
        } else {
            this.afterTree = this.parent.afterTree.getChild(this.name);
            this.beforeTree = this.parent.beforeTree.getChild(this.name);
        }
        if (this.pathFilterResult == PathFilter.Result.INCLUDE) {
            Tree current = this.afterTree.exists() ? this.afterTree : this.beforeTree;
            this.indexingRule = this.getDefinition().getApplicableIndexingRule(current);
            if (this.indexingRule != null) {
                this.currentMatchers = this.indexingRule.getAggregate().createMatchers(this);
            }
        }
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        long indexed;
        String path;
        if ((this.propertiesChanged || !before.exists()) && this.addOrUpdate(path = this.getPath(), after, before.exists()) && (indexed = this.context.incIndexedNodes()) % 1000L == 0L) {
            log.debug("[{}] => Indexed {} nodes...", (Object)this.getIndexName(), (Object)indexed);
        }
        for (Aggregate.Matcher m : this.matcherState.affectedMatchers) {
            m.markRootDirty();
        }
        if (this.parent == null) {
            try {
                this.context.closeWriter();
            }
            catch (IOException e) {
                throw new CommitFailedException("Lucene", 4, "Failed to close the Lucene index", e);
            }
            if (this.context.getIndexedNodes() > 0L) {
                log.debug("[{}] => Indexed {} nodes, done.", (Object)this.getIndexName(), (Object)this.context.getIndexedNodes());
            }
        }
    }

    @Override
    public void propertyAdded(PropertyState after) {
        this.markPropertyChanged(after.getName());
        this.checkAggregates(after.getName());
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        this.markPropertyChanged(before.getName());
        this.propertiesModified.add(before);
        this.checkAggregates(before.getName());
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        this.markPropertyChanged(before.getName());
        this.propertiesModified.add(before);
        this.checkAggregates(before.getName());
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult != PathFilter.Result.EXCLUDE) {
            return new LuceneIndexEditor(this, name, this.getMatcherState(name, after), filterResult, false);
        }
        return null;
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult != PathFilter.Result.EXCLUDE) {
            return new LuceneIndexEditor(this, name, this.getMatcherState(name, after), filterResult, false);
        }
        return null;
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        MatcherState ms;
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult == PathFilter.Result.EXCLUDE) {
            return null;
        }
        if (!this.isDeleted) {
            String path = PathUtils.concat(this.getPath(), name);
            try {
                IndexWriter writer = this.context.getWriter();
                writer.deleteDocuments(TermFactory.newPathTerm(path));
                writer.deleteDocuments((Query)new PrefixQuery(TermFactory.newPathTerm(path + "/")));
                this.context.indexUpdate();
            }
            catch (IOException e) {
                throw new CommitFailedException("Lucene", 5, "Failed to remove the index entries of the removed subtree " + path, e);
            }
        }
        if (!(ms = this.getMatcherState(name, before)).isEmpty()) {
            return new LuceneIndexEditor(this, name, ms, filterResult, true);
        }
        return null;
    }

    private boolean addOrUpdate(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        try {
            Document d = this.makeDocument(path, state, isUpdate);
            if (d != null) {
                if (log.isTraceEnabled()) {
                    log.trace("[{}] Indexed document for {} is {}", this.getIndexName(), path, d);
                }
                this.context.indexUpdate();
                this.context.getWriter().updateDocument(TermFactory.newPathTerm(path), d);
                return true;
            }
        }
        catch (IOException e) {
            throw new CommitFailedException("Lucene", 3, "Failed to index the node " + path, e);
        }
        catch (IllegalArgumentException ie) {
            log.warn("Failed to index the node [{}]", (Object)path, (Object)ie);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Document makeDocument(String path, NodeState state, boolean isUpdate) throws IOException {
        void var9_12;
        if (!this.isIndexable()) {
            return null;
        }
        boolean facet = false;
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean dirty = false;
        StringPropertyState nodenamePS = new StringPropertyState(":nodeName", PathUtils.getName(path));
        for (PropertyState propertyState : Iterables.concat(state.getProperties(), Collections.singleton(nodenamePS))) {
            PropertyDefinition pd;
            String pname = propertyState.getName();
            if (!LuceneIndexEditor.isVisible(pname) && !":nodeName".equals(pname) || (pd = this.indexingRule.getConfig(pname)) == null || !pd.index) continue;
            if (pd.ordered) {
                dirty |= this.addTypedOrderedFields(fields, propertyState, pname, pd);
            }
            dirty |= this.indexProperty(path, fields, state, propertyState, pname, pd);
            facet |= pd.facet;
        }
        dirty |= this.indexAggregates(path, fields, state);
        dirty |= this.indexNullCheckEnabledProps(path, fields, state);
        dirty |= this.indexNotNullCheckEnabledProps(path, fields, state);
        if (!(dirty |= this.augmentCustomFields(path, fields, state))) {
            dirty = this.indexIfSinglePropertyRemoved();
        }
        if (isUpdate && !dirty) {
            return null;
        }
        String name = PathUtils.getName(path);
        if (this.indexingRule.isNodeNameIndexed()) {
            LuceneIndexEditor.addNodeNameField(fields, name);
            dirty = true;
        }
        if (!this.indexingRule.indexesAllNodesOfMatchingType() && !dirty) {
            return null;
        }
        Document document = new Document();
        document.add(FieldFactory.newPathField(path));
        if (this.indexingRule.isFulltextEnabled()) {
            document.add(FieldFactory.newFulltextField(name));
        }
        if (this.getDefinition().evaluatePathRestrictions()) {
            document.add(FieldFactory.newAncestorsField(PathUtils.getParentPath(path)));
            document.add(FieldFactory.newDepthField(path));
        }
        Field suggestField = null;
        for (Field f : fields) {
            if (":suggest".equals(f.name())) {
                if (suggestField == null) {
                    suggestField = FieldFactory.newSuggestField(f.stringValue());
                    continue;
                }
                suggestField = FieldFactory.newSuggestField(suggestField.stringValue(), f.stringValue());
                continue;
            }
            document.add(f);
        }
        if (suggestField != null) {
            document.add(suggestField);
        }
        if (facet) {
            Document document2 = this.context.getFacetsConfig().build(document);
        }
        return var9_12;
    }

    private boolean addFacetFields(List<Field> fields, PropertyState property, String pname, PropertyDefinition pd) {
        String facetFieldName = FieldNames.createFacetFieldName(pname);
        this.context.getFacetsConfig().setIndexFieldName(pname, facetFieldName);
        int tag = property.getType().tag();
        int idxDefinedTag = pd.getType();
        if (tag != idxDefinedTag) {
            log.debug("[{}] Facet property defined with type {} differs from property {} with type {} in path {}", this.getIndexName(), Type.fromTag(idxDefinedTag, false), property.toString(), Type.fromTag(tag, false), this.getPath());
            tag = idxDefinedTag;
        }
        boolean fieldAdded = false;
        try {
            String value;
            if (tag == Type.STRINGS.tag() && property.isArray()) {
                this.context.getFacetsConfig().setMultiValued(pname, true);
                Iterable<String> values = property.getValue(Type.STRINGS);
                for (String value2 : values) {
                    if (value2 == null || value2.length() <= 0) continue;
                    fields.add(new SortedSetDocValuesFacetField(pname, value2));
                }
                fieldAdded = true;
            } else if (tag == Type.STRING.tag() && (value = property.getValue(Type.STRING)).length() > 0) {
                fields.add(new SortedSetDocValuesFacetField(pname, value));
                fieldAdded = true;
            }
        }
        catch (Throwable e) {
            log.warn("[{}] Ignoring facet property. Could not convert property {} of type {} to type {} for path {}", this.getIndexName(), pname, Type.fromTag(property.getType().tag(), false), Type.fromTag(tag, false), this.getPath(), e);
        }
        return fieldAdded;
    }

    private boolean indexProperty(String path, List<Field> fields, NodeState state, PropertyState property, String pname, PropertyDefinition pd) {
        boolean includeTypeForFullText = this.indexingRule.includePropertyType(property.getType().tag());
        boolean dirty = false;
        if (Type.BINARY.tag() == property.getType().tag() && includeTypeForFullText) {
            fields.addAll(this.newBinary(property, state, null, path + "@" + pname));
            dirty = true;
        } else {
            if (pd.propertyIndex && pd.includePropertyType(property.getType().tag())) {
                dirty |= this.addTypedFields(fields, property, pname);
            }
            if (pd.fulltextEnabled() && includeTypeForFullText) {
                for (String value : property.getValue(Type.STRINGS)) {
                    if (pd.analyzed && pd.includePropertyType(property.getType().tag())) {
                        String analyzedPropName = this.constructAnalyzedPropertyName(pname);
                        fields.add(FieldFactory.newPropertyField(analyzedPropName, value, !pd.skipTokenization(pname), pd.stored));
                    }
                    if (pd.useInSuggest) {
                        fields.add(FieldFactory.newSuggestField(value));
                    }
                    if (pd.useInSpellcheck) {
                        fields.add(FieldFactory.newPropertyField(":spellcheck", value, true, false));
                    }
                    if (pd.nodeScopeIndex) {
                        Field field = FieldFactory.newFulltextField(value);
                        fields.add(field);
                    }
                    dirty = true;
                }
            }
            if (pd.facet) {
                dirty |= this.addFacetFields(fields, property, pname, pd);
            }
        }
        return dirty;
    }

    private String constructAnalyzedPropertyName(String pname) {
        if (this.context.getDefinition().getVersion().isAtLeast(IndexFormatVersion.V2)) {
            return FieldNames.createAnalyzedFieldName(pname);
        }
        return pname;
    }

    private boolean addTypedFields(List<Field> fields, PropertyState property, String pname) {
        int tag = property.getType().tag();
        boolean fieldAdded = false;
        for (int i = 0; i < property.count(); ++i) {
            Field f;
            if (tag == Type.LONG.tag()) {
                f = new LongField(pname, (long)property.getValue(Type.LONG, i), Field.Store.NO);
            } else if (tag == Type.DATE.tag()) {
                String date = property.getValue(Type.DATE, i);
                f = new LongField(pname, (long)FieldFactory.dateToLong(date), Field.Store.NO);
            } else {
                f = tag == Type.DOUBLE.tag() ? new DoubleField(pname, (double)property.getValue(Type.DOUBLE, i), Field.Store.NO) : (tag == Type.BOOLEAN.tag() ? new StringField(pname, property.getValue(Type.BOOLEAN, i).toString(), Field.Store.NO) : new StringField(pname, property.getValue(Type.STRING, i), Field.Store.NO));
            }
            fields.add(f);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean addTypedOrderedFields(List<Field> fields, PropertyState property, String pname, PropertyDefinition pd) {
        int idxDefinedTag;
        if (property.getType().isArray()) {
            log.warn("[{}] Ignoring ordered property {} of type {} for path {} as multivalued ordered property not supported", this.getIndexName(), pname, Type.fromTag(property.getType().tag(), true), this.getPath());
            return false;
        }
        int tag = property.getType().tag();
        if (tag != (idxDefinedTag = pd.getType())) {
            log.debug("[{}] Ordered property defined with type {} differs from property {} with type {} in path {}", this.getIndexName(), Type.fromTag(idxDefinedTag, false), property.toString(), Type.fromTag(tag, false), this.getPath());
            tag = idxDefinedTag;
        }
        String name = FieldNames.createDocValFieldName(pname);
        boolean fieldAdded = false;
        Field f = null;
        try {
            if (tag == Type.LONG.tag()) {
                f = new NumericDocValuesField(name, property.getValue(Type.LONG));
            } else if (tag == Type.DATE.tag()) {
                String date = property.getValue(Type.DATE);
                f = new NumericDocValuesField(name, FieldFactory.dateToLong(date));
            } else if (tag == Type.DOUBLE.tag()) {
                f = new DoubleDocValuesField(name, property.getValue(Type.DOUBLE));
            } else if (tag == Type.BOOLEAN.tag()) {
                f = new SortedDocValuesField(name, new BytesRef(property.getValue(Type.BOOLEAN).toString()));
            } else if (tag == Type.STRING.tag()) {
                f = new SortedDocValuesField(name, new BytesRef(property.getValue(Type.STRING)));
            }
            if (f != null) {
                fields.add(f);
                fieldAdded = true;
            }
        }
        catch (Exception e) {
            log.warn("[{}] Ignoring ordered property. Could not convert property {} of type {} to type {} for path {}", this.getIndexName(), pname, Type.fromTag(property.getType().tag(), false), Type.fromTag(tag, false), this.getPath(), e);
        }
        return fieldAdded;
    }

    private static boolean isVisible(String name) {
        return name.charAt(0) != ':';
    }

    private List<Field> newBinary(PropertyState property, NodeState state, String nodePath, String path) {
        String encoding;
        ArrayList<Field> fields = new ArrayList<Field>();
        Metadata metadata = new Metadata();
        String type = state.getString("jcr:mimeType");
        if (type == null || !this.isSupportedMediaType(type)) {
            log.trace("[{}] Ignoring binary content for node {} due to unsupported (or null) jcr:mimeType [{}]", this.getIndexName(), path, type);
            return fields;
        }
        metadata.set("Content-Type", type);
        if ("jcr:data".equals(property.getName()) && (encoding = state.getString("jcr:encoding")) != null) {
            metadata.set("Content-Encoding", encoding);
        }
        for (Blob v : property.getValue(Type.BINARIES)) {
            String value = this.parseStringValue(v, metadata, path, property.getName());
            if (value == null) continue;
            if (nodePath != null) {
                fields.add(FieldFactory.newFulltextField(nodePath, value, true));
                continue;
            }
            fields.add(FieldFactory.newFulltextField(value, true));
        }
        return fields;
    }

    private boolean augmentCustomFields(String path, List<Field> fields, NodeState document) {
        boolean dirty = false;
        IndexAugmentorFactory augmentorFactory = this.context.getAugmentorFactory();
        if (augmentorFactory != null) {
            IndexDefinition defn = this.getDefinition();
            Iterable<Field> augmentedFields = augmentorFactory.getIndexFieldProvider(this.indexingRule.getNodeTypeName()).getAugmentedFields(path, document, defn.getDefinitionNodeState());
            for (Field field : augmentedFields) {
                fields.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    private boolean indexNotNullCheckEnabledProps(String path, List<Field> fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNotNullCheckEnabledProperties()) {
            if (!this.isPropertyNotNull(state, pd)) continue;
            fields.add(new StringField(":notNullProps", pd.name, Field.Store.NO));
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean indexNullCheckEnabledProps(String path, List<Field> fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNullCheckEnabledProperties()) {
            if (!this.isPropertyNull(state, pd)) continue;
            fields.add(new StringField(":nullProps", pd.name, Field.Store.NO));
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean indexIfSinglePropertyRemoved() {
        boolean dirty = false;
        for (PropertyState ps : this.propertiesModified) {
            PropertyDefinition pd = this.indexingRule.getConfig(ps.getName());
            if (pd == null || !pd.index || !pd.includePropertyType(ps.getType().tag()) && !this.indexingRule.includePropertyType(ps.getType().tag())) continue;
            dirty = true;
            break;
        }
        return dirty;
    }

    private boolean isPropertyNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = LuceneIndexEditor.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return !propertyNode.hasProperty(pd.nonRelativeName);
    }

    private boolean isPropertyNotNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = LuceneIndexEditor.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return propertyNode.hasProperty(pd.nonRelativeName);
    }

    private static NodeState getPropertyNode(NodeState nodeState, PropertyDefinition pd) {
        if (!pd.relative) {
            return nodeState;
        }
        NodeState node = nodeState;
        for (String name : pd.ancestors) {
            node = node.getChildNode(name);
        }
        return node;
    }

    @Override
    public void markDirty() {
        this.propertiesChanged = true;
    }

    private MatcherState getMatcherState(String name, NodeState after) {
        ArrayList<Aggregate.Matcher> matched = Lists.newArrayList();
        ArrayList<Aggregate.Matcher> inherited = Lists.newArrayList();
        for (Aggregate.Matcher m : Iterables.concat(this.matcherState.inherited, this.currentMatchers)) {
            Aggregate.Matcher result = m.match(name, after);
            if (result.getStatus() == Aggregate.Matcher.Status.MATCH_FOUND) {
                matched.add(result);
            }
            if (result.getStatus() == Aggregate.Matcher.Status.FAIL) continue;
            inherited.addAll(result.nextSet());
        }
        if (!matched.isEmpty() || !inherited.isEmpty()) {
            return new MatcherState(matched, inherited);
        }
        return MatcherState.NONE;
    }

    private boolean indexAggregates(final String path, final List<Field> fields, final NodeState state) {
        final AtomicBoolean dirtyFlag = new AtomicBoolean();
        this.indexingRule.getAggregate().collectAggregates(state, new Aggregate.ResultCollector(){

            @Override
            public void onResult(Aggregate.NodeIncludeResult result) {
                boolean dirty = LuceneIndexEditor.this.indexAggregatedNode(path, fields, result);
                if (dirty) {
                    dirtyFlag.set(true);
                }
            }

            @Override
            public void onResult(Aggregate.PropertyIncludeResult result) {
                boolean dirty = false;
                if (result.pd.ordered) {
                    dirty |= LuceneIndexEditor.this.addTypedOrderedFields(fields, result.propertyState, result.propertyPath, result.pd);
                }
                if (dirty |= LuceneIndexEditor.this.indexProperty(path, fields, state, result.propertyState, result.propertyPath, result.pd)) {
                    dirtyFlag.set(true);
                }
            }
        });
        return dirtyFlag.get();
    }

    private boolean indexAggregatedNode(String path, List<Field> fields, Aggregate.NodeIncludeResult result) {
        IndexDefinition.IndexingRule ruleAggNode = this.context.getDefinition().getApplicableIndexingRule(ConfigUtil.getPrimaryTypeName(result.nodeState));
        boolean dirty = false;
        for (PropertyState propertyState : result.nodeState.getProperties()) {
            String pname = propertyState.getName();
            String propertyPath = PathUtils.concat(result.nodePath, pname);
            if (!LuceneIndexEditor.isVisible(pname)) continue;
            int type = propertyState.getType().tag();
            if (ruleAggNode == null ? !this.indexingRule.includePropertyType(type) : !ruleAggNode.includePropertyType(type)) continue;
            PropertyDefinition pdForRootNode = this.indexingRule.getConfig(propertyPath);
            if (pdForRootNode != null && (!pdForRootNode.index || pdForRootNode.excludeFromAggregate)) continue;
            if (Type.BINARY == propertyState.getType()) {
                String aggreagtedNodePath = PathUtils.concat(path, result.nodePath);
                String nodePath = result.isRelativeNode() ? result.rootIncludePath : null;
                fields.addAll(this.newBinary(propertyState, result.nodeState, nodePath, aggreagtedNodePath + "@" + pname));
                dirty = true;
                continue;
            }
            PropertyDefinition pd = null;
            if (ruleAggNode != null) {
                pd = ruleAggNode.getConfig(pname);
            }
            if (pd != null && !pd.nodeScopeIndex) continue;
            for (String value : propertyState.getValue(Type.STRINGS)) {
                Field field;
                Field field2 = field = result.isRelativeNode() ? FieldFactory.newFulltextField(result.rootIncludePath, value) : FieldFactory.newFulltextField(value);
                if (pd != null) {
                    field.setBoost(pd.boost);
                }
                fields.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    private void checkAggregates(String name) {
        for (Aggregate.Matcher m : this.matcherState.matched) {
            if (this.matcherState.affectedMatchers.contains(m) || !m.aggregatesProperty(name)) continue;
            this.matcherState.affectedMatchers.add(m);
        }
    }

    private void markPropertyChanged(String name) {
        if (this.isIndexable() && !this.propertiesChanged && this.indexingRule.isIndexed(name)) {
            this.propertiesChanged = true;
        }
    }

    private IndexDefinition getDefinition() {
        return this.context.getDefinition();
    }

    private boolean isIndexable() {
        return this.indexingRule != null;
    }

    private PathFilter.Result getPathFilterResult(String childNodeName) {
        return this.context.getDefinition().getPathFilter().filter(PathUtils.concat(this.getPath(), childNodeName));
    }

    private boolean isSupportedMediaType(String type) {
        return this.context.isSupportedMediaType(type);
    }

    private String parseStringValue(Blob v, Metadata metadata, String path, String propertyName) {
        String text = this.context.getExtractedTextCache().get(path, propertyName, v, this.context.isReindex());
        if (text == null) {
            text = this.parseStringValue0(v, metadata, path);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseStringValue0(Blob v, Metadata metadata, String path) {
        long bytesRead;
        long start;
        WriteOutContentHandler handler;
        block7: {
            handler = new WriteOutContentHandler(this.context.getDefinition().getMaxExtractLength());
            start = System.currentTimeMillis();
            bytesRead = 0L;
            try {
                CountingInputStream stream = new CountingInputStream(new LazyInputStream(new BlobByteSource(v)));
                try {
                    this.context.getParser().parse(stream, handler, metadata, new ParseContext());
                }
                finally {
                    bytesRead = stream.getCount();
                    stream.close();
                }
            }
            catch (LinkageError e) {
            }
            catch (Throwable t) {
                if (handler.isWriteLimitReached(t)) break block7;
                log.debug("[{}] Failed to extract text from a binary property: {}. This is a fairly common case, and nothing to worry about. The stack trace is included to help improve the text extraction feature.", this.getIndexName(), path, t);
                this.context.getExtractedTextCache().put(v, ExtractedText.ERROR);
                return TEXT_EXTRACTION_ERROR;
            }
        }
        String result = handler.toString();
        if (bytesRead > 0L) {
            this.context.recordTextExtractionStats(System.currentTimeMillis() - start, bytesRead, result.length());
        }
        this.context.getExtractedTextCache().put(v, new ExtractedText(ExtractedText.ExtractionResult.SUCCESS, result));
        return result;
    }

    private String getIndexName() {
        return this.context.getDefinition().getIndexName();
    }

    private static void addNodeNameField(List<Field> fields, String name) {
        int colon = name.indexOf(58);
        String value = colon < 0 ? name : name.substring(colon + 1);
        fields.add(new StringField(":nodeName", value, Field.Store.NO));
    }

    private static class MatcherState {
        static final MatcherState NONE = new MatcherState(Collections.<Aggregate.Matcher>emptyList(), Collections.<Aggregate.Matcher>emptyList());
        final List<Aggregate.Matcher> matched;
        final List<Aggregate.Matcher> inherited;
        final Set<Aggregate.Matcher> affectedMatchers;

        public MatcherState(List<Aggregate.Matcher> matched, List<Aggregate.Matcher> inherited) {
            this.matched = matched;
            this.inherited = inherited;
            this.affectedMatchers = matched.isEmpty() ? Collections.emptySet() : Sets.newIdentityHashSet();
        }

        public boolean isEmpty() {
            return this.matched.isEmpty() && this.inherited.isEmpty();
        }
    }
}

