/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.reference;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class ReferenceEditor
extends DefaultEditor
implements IndexEditor {
    private static final ContentMirrorStoreStrategy STORE = new ContentMirrorStoreStrategy();
    private final ReferenceEditor parent;
    private final String name;
    private String path;
    private final NodeState root;
    private final NodeBuilder definition;
    private final Map<String, Set<String>> newRefs;
    private final Map<String, Set<String>> rmRefs;
    private final Map<String, Set<String>> newWeakRefs;
    private final Map<String, Set<String>> rmWeakRefs;
    private final Set<String> rmIds;
    private final Set<String> newIds;
    private boolean isReindex;

    public ReferenceEditor(NodeBuilder definition, NodeState root) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.definition = definition;
        this.root = root;
        this.newRefs = Maps.newHashMap();
        this.rmRefs = Maps.newHashMap();
        this.newWeakRefs = Maps.newHashMap();
        this.rmWeakRefs = Maps.newHashMap();
        this.rmIds = Sets.newHashSet();
        this.newIds = Sets.newHashSet();
    }

    private ReferenceEditor(ReferenceEditor parent, String name) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.definition = parent.definition;
        this.root = parent.root;
        this.newRefs = parent.newRefs;
        this.rmRefs = parent.rmRefs;
        this.newWeakRefs = parent.newWeakRefs;
        this.rmWeakRefs = parent.rmWeakRefs;
        this.rmIds = parent.rmIds;
        this.newIds = parent.newIds;
        this.isReindex = parent.isReindex;
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        if (EmptyNodeState.MISSING_NODE == before && this.parent == null) {
            this.isReindex = true;
        }
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.parent == null) {
            Set<String> rm;
            Set<String> add;
            Set<String> add2;
            Set<String> rm2;
            String uuid;
            for (Map.Entry<String, Set<String>> ref : this.rmRefs.entrySet()) {
                uuid = ref.getKey();
                rm2 = ref.getValue();
                add2 = Collections.emptySet();
                if (this.newRefs.containsKey(uuid)) {
                    add2 = this.newRefs.remove(uuid);
                }
                ReferenceEditor.update(this.definition, ":references", uuid, add2, rm2);
            }
            for (Map.Entry<String, Set<String>> ref : this.newRefs.entrySet()) {
                uuid = ref.getKey();
                if (this.rmIds.contains(uuid)) continue;
                add = ref.getValue();
                rm = Collections.emptySet();
                ReferenceEditor.update(this.definition, ":references", uuid, add, rm);
            }
            ReferenceEditor.checkReferentialIntegrity(this.root, this.definition.getNodeState(), Sets.difference(this.rmIds, this.newIds));
            for (Map.Entry<String, Set<String>> ref : this.rmWeakRefs.entrySet()) {
                uuid = ref.getKey();
                rm2 = ref.getValue();
                add2 = Collections.emptySet();
                if (this.newWeakRefs.containsKey(uuid)) {
                    add2 = this.newWeakRefs.remove(uuid);
                }
                ReferenceEditor.update(this.definition, ":weakreferences", uuid, add2, rm2);
            }
            for (Map.Entry<String, Set<String>> ref : this.newWeakRefs.entrySet()) {
                uuid = ref.getKey();
                add = ref.getValue();
                rm = Collections.emptySet();
                ReferenceEditor.update(this.definition, ":weakreferences", uuid, add, rm);
            }
        }
    }

    @Override
    public void propertyAdded(PropertyState after) {
        this.propertyChanged(null, after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        if (before != null) {
            if (before.getType().tag() == 9 && !ReferenceEditor.isVersionStorePath(this.getPath())) {
                ReferenceEditor.put(this.rmRefs, before.getValue(Type.STRINGS), PathUtils.concat(this.getPath(), before.getName()));
            }
            if (before.getType().tag() == 10) {
                ReferenceEditor.put(this.rmWeakRefs, before.getValue(Type.STRINGS), PathUtils.concat(this.getPath(), before.getName()));
            }
            if ("jcr:uuid".equals(before.getName())) {
                this.rmIds.add(before.getValue(Type.STRING));
            }
        }
        if (after != null) {
            if (after.getType().tag() == 9 && !ReferenceEditor.isVersionStorePath(this.getPath())) {
                ReferenceEditor.put(this.newRefs, after.getValue(Type.STRINGS), PathUtils.concat(this.getPath(), after.getName()));
            }
            if (after.getType().tag() == 10) {
                ReferenceEditor.put(this.newWeakRefs, after.getValue(Type.STRINGS), PathUtils.concat(this.getPath(), after.getName()));
            }
            if ("jcr:uuid".equals(after.getName())) {
                this.newIds.add(after.getValue(Type.STRING));
            }
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        this.propertyChanged(before, null);
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        String uuid = after.getString("jcr:uuid");
        if (!this.isReindex && uuid != null) {
            this.newIds.add(uuid);
        }
        return new ReferenceEditor(this, name);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new ReferenceEditor(this, name);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        String uuid = before.getString("jcr:uuid");
        if (uuid != null) {
            this.rmIds.add(uuid);
        }
        return new ReferenceEditor(this, name);
    }

    private static boolean isVersionStorePath(String oakPath) {
        return oakPath != null && oakPath.startsWith("/jcr:system/jcr:versionStorage");
    }

    private static void put(Map<String, Set<String>> map, Iterable<String> keys, String value) {
        String asRelative = PathUtils.isAbsolute(value) ? value.substring(1) : value;
        for (String key : keys) {
            Set<String> values = map.get(key);
            if (values == null) {
                values = Sets.newHashSet();
            }
            values.add(asRelative);
            map.put(key, values);
        }
    }

    private static void update(NodeBuilder child, String name, String key, Set<String> add, Set<String> rm) {
        NodeBuilder index = child.child(name);
        ImmutableSet<String> empty = ImmutableSet.of();
        for (String p : rm) {
            STORE.update(index, p, name, child, ImmutableSet.of(key), empty);
        }
        for (String p : add) {
            STORE.update(index, p, name, child, empty, ImmutableSet.of(key));
        }
    }

    private static boolean hasReferences(NodeState root, NodeState definition, String name, String key) {
        return definition.hasChildNode(name) && STORE.count(root, definition, name, ImmutableSet.of(key), 1) > 0L;
    }

    private static void checkReferentialIntegrity(NodeState root, NodeState definition, Set<String> idsOfRemovedNodes) throws CommitFailedException {
        for (String id : idsOfRemovedNodes) {
            if (!ReferenceEditor.hasReferences(root, definition, ":references", id)) continue;
            throw new CommitFailedException("Integrity", 1, "Unable to delete referenced node");
        }
    }
}

