/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;

public class NodeStateSolrServerProvider
implements SolrServerProvider {
    private final NodeState nodeState;
    private SolrServerProvider provider;

    public NodeStateSolrServerProvider(NodeState nodeState) {
        this.nodeState = nodeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProviderInitialization() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        NodeState nodeState = this.nodeState;
        synchronized (nodeState) {
            if (this.provider == null) {
                this.provider = new NodeStateSolrServerConfigurationProvider(this.nodeState).getSolrServerConfiguration().getProvider();
            }
        }
    }

    @Override
    public SolrServer getSolrServer() throws Exception {
        this.checkProviderInitialization();
        return this.provider.getSolrServer();
    }

    @Override
    public SolrServer getIndexingSolrServer() throws Exception {
        this.checkProviderInitialization();
        return this.provider.getIndexingSolrServer();
    }

    @Override
    public SolrServer getSearchingSolrServer() throws Exception {
        this.checkProviderInitialization();
        return this.provider.getSearchingSolrServer();
    }

    @Override
    public void close() throws IOException {
        try {
            this.getSolrServer().shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getIndexingSolrServer().shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.getSearchingSolrServer().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "NodeStateSolrServerProvider{nodeStateChildren=" + Iterables.toString(this.nodeState.getChildNodeNames()) + ", provider=" + this.provider + '}';
    }
}

