/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrUtils;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.WriteOutContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrIndexEditor
implements IndexEditor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrIndexEditor parent;
    private final String name;
    private String path;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;
    private boolean propertiesChanged = false;
    private final IndexUpdateCallback updateCallback;
    private static final Parser parser = new AutoDetectParser();

    SolrIndexEditor(SolrServer solrServer, OakSolrConfiguration configuration, IndexUpdateCallback callback) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.solrServer = solrServer;
        this.configuration = configuration;
        this.updateCallback = callback;
    }

    private SolrIndexEditor(SolrIndexEditor parent, String name) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.solrServer = parent.solrServer;
        this.configuration = parent.configuration;
        this.updateCallback = parent.updateCallback;
    }

    String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void enter(NodeState before, NodeState after) {
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.propertiesChanged || !before.exists()) {
            this.updateCallback.indexUpdate();
            try {
                this.solrServer.add(this.docFromState(after));
            }
            catch (SolrServerException e) {
                throw new CommitFailedException("Solr", 2, "Failed to add a document to Solr", e);
            }
            catch (IOException e) {
                throw new CommitFailedException("Solr", 6, "Failed to send data to Solr", e);
            }
        }
        if (this.parent == null) {
            try {
                this.commitByPolicy(this.solrServer, this.configuration.getCommitPolicy());
            }
            catch (SolrServerException e) {
                throw new CommitFailedException("Solr", 3, "Failed to commit changes to Solr", e);
            }
            catch (IOException e) {
                throw new CommitFailedException("Solr", 6, "Failed to send data to Solr", e);
            }
        }
    }

    private void commitByPolicy(SolrServer solrServer, OakSolrConfiguration.CommitPolicy commitPolicy) throws IOException, SolrServerException {
        switch (commitPolicy) {
            case HARD: {
                solrServer.commit();
                break;
            }
            case SOFT: {
                solrServer.commit(false, false, true);
                break;
            }
        }
    }

    @Override
    public void propertyAdded(PropertyState after) {
        this.propertiesChanged = true;
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        this.propertiesChanged = true;
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        this.propertiesChanged = true;
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        return new SolrIndexEditor(this, name);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new SolrIndexEditor(this, name);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        String path = SolrUtils.partialEscape(PathUtils.concat(this.getPath(), name)).toString();
        try {
            String formattedQuery = String.format("%s:%s*", this.configuration.getPathField(), path);
            if (this.log.isDebugEnabled()) {
                this.log.debug("deleting by query {}", (Object)formattedQuery);
            }
            this.solrServer.deleteByQuery(formattedQuery);
            this.updateCallback.indexUpdate();
        }
        catch (SolrServerException e) {
            throw new CommitFailedException("Solr", 5, "Failed to remove documents from Solr", e);
        }
        catch (IOException e) {
            throw new CommitFailedException("Solr", 6, "Failed to send data to Solr", e);
        }
        return null;
    }

    private SolrInputDocument docFromState(NodeState state) {
        int jcrContentIndex;
        SolrInputDocument inputDocument = new SolrInputDocument();
        String path = this.getPath();
        inputDocument.addField(this.configuration.getPathField(), path);
        inputDocument.addField(this.configuration.getPathDepthField(), PathUtils.getDepth(path));
        if (this.configuration.collapseJcrContentNodes() && (jcrContentIndex = path.lastIndexOf("jcr:content")) >= 0) {
            int n = jcrContentIndex + "jcr:content".length();
            String collapsedPath = path.substring(0, n);
            inputDocument.addField(this.configuration.getCollapsedPathField(), collapsedPath);
        }
        for (PropertyState propertyState : state.getProperties()) {
            Object sortValue;
            Object fieldValue;
            if ((this.configuration.getUsedProperties().size() <= 0 || !this.configuration.getUsedProperties().contains(propertyState.getName())) && this.configuration.getIgnoredProperties().contains(propertyState.getName())) continue;
            String fieldName = this.configuration.getFieldNameFor(propertyState.getType());
            if (fieldName != null) {
                fieldValue = propertyState.getValue(propertyState.getType());
            } else {
                fieldName = propertyState.getName();
                fieldValue = Type.BINARY.tag() == propertyState.getType().tag() ? this.extractTextValues(propertyState, state) : (propertyState.isArray() ? propertyState.getValue(Type.STRINGS) : propertyState.getValue(Type.STRING));
            }
            inputDocument.addField(fieldName, fieldValue);
            if (fieldValue instanceof Iterable) {
                Iterable values = (Iterable)fieldValue;
                StringBuilder builder = new StringBuilder();
                String stringValue = null;
                for (Object value : values) {
                    builder.append(value);
                    if (builder.length() <= 1024) continue;
                    stringValue = builder.substring(0, 1024);
                    break;
                }
                if (stringValue == null) {
                    stringValue = builder.toString();
                }
                sortValue = stringValue;
            } else {
                sortValue = fieldValue.toString().length() > 1024 ? fieldValue.toString().substring(0, 1024) : fieldValue;
            }
            inputDocument.addField(SolrUtils.getSortingField(propertyState.getType().tag(), propertyState.getName()), sortValue);
        }
        return inputDocument;
    }

    private List<String> extractTextValues(PropertyState property, NodeState state) {
        LinkedList<String> values = new LinkedList<String>();
        Metadata metadata = new Metadata();
        if ("jcr:data".equals(property.getName())) {
            String encoding;
            String type = state.getString("jcr:mimeType");
            if (type != null) {
                metadata.set("Content-Type", type);
            }
            if ((encoding = state.getString("jcr:encoding")) != null) {
                metadata.set("Content-Encoding", encoding);
            }
        }
        for (Blob v : property.getValue(Type.BINARIES)) {
            values.add(this.parseStringValue(v, metadata));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseStringValue(Blob v, Metadata metadata) {
        WriteOutContentHandler handler;
        block6: {
            handler = new WriteOutContentHandler();
            try {
                InputStream stream = v.getNewStream();
                try {
                    parser.parse(stream, handler, metadata, new ParseContext());
                }
                finally {
                    stream.close();
                }
            }
            catch (LinkageError e) {
            }
            catch (Throwable t) {
                if (handler.isWriteLimitReached(t)) break block6;
                this.log.debug("Failed to extract text from a binary property:  This is a fairly common case, and nothing to worry about. The stack trace is included to help improve the text extraction feature.", t);
                return "TextExtractionError";
            }
        }
        return handler.toString();
    }
}

