/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.nodestate.NodeStateSolrServersObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, immediate=true, label="Apache Jackrabbit Oak Solr persisted configuration observer")
public class NodeStateSolrServersObserverService {
    private final NodeStateSolrServersObserver nodeStateSolrServersObserver = new NodeStateSolrServersObserver();
    private WhiteboardExecutor executor;
    private BackgroundObserver backgroundObserver;
    private List<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
    @Property(boolValue={false}, label="enabled", description="enable persisted configuration observer")
    private static final String ENABLED = "enabled";

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        boolean enabled = PropertiesUtil.toBoolean(componentContext.getProperties().get(ENABLED), false);
        if (enabled) {
            BundleContext bundleContext = componentContext.getBundleContext();
            OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
            this.executor = new WhiteboardExecutor();
            this.executor.start(whiteboard);
            this.backgroundObserver = new BackgroundObserver(this.nodeStateSolrServersObserver, this.executor, 5);
            this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)this.backgroundObserver, null));
        }
    }

    @Deactivate
    protected void deactivate() throws Exception {
        for (ServiceRegistration reg : this.regs) {
            reg.unregister();
        }
        if (this.backgroundObserver != null) {
            this.backgroundObserver.close();
        }
        if (this.executor != null) {
            this.executor.stop();
        }
    }
}

