/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Collection;
import java.util.List;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndex;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrUtils;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.solr.client.solrj.SolrQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilterQueryParser {
    private static final Logger log = LoggerFactory.getLogger(FilterQueryParser.class);

    FilterQueryParser() {
    }

    static SolrQuery getQuery(Filter filter, QueryIndex.IndexPlan plan, OakSolrConfiguration configuration) {
        Filter.PathRestriction pathRestriction;
        Collection<Filter.PropertyRestriction> propertyRestrictions;
        SolrQuery solrQuery = new SolrQuery();
        FilterQueryParser.setDefaults(solrQuery, configuration);
        StringBuilder queryBuilder = new StringBuilder();
        FullTextExpression ft = filter.getFullTextConstraint();
        if (ft != null) {
            queryBuilder.append(FilterQueryParser.parseFullTextExpression(ft, configuration));
            queryBuilder.append(' ');
        } else if (filter.getFulltextConditions() != null) {
            Collection<String> fulltextConditions = filter.getFulltextConditions();
            for (String fulltextCondition : fulltextConditions) {
                queryBuilder.append(fulltextCondition).append(" ");
            }
        }
        List<QueryIndex.OrderEntry> sortOrder = plan.getSortOrder();
        if (sortOrder != null) {
            for (QueryIndex.OrderEntry orderEntry : sortOrder) {
                String sortingField;
                SolrQuery.ORDER order = QueryIndex.OrderEntry.Order.ASCENDING.equals((Object)orderEntry.getOrder()) ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
                if ("jcr:path".equals(orderEntry.getPropertyName())) {
                    sortingField = SolrUtils.partialEscape(configuration.getPathField()).toString();
                } else if ("jcr:score".equals(orderEntry.getPropertyName())) {
                    sortingField = "score";
                } else {
                    if (orderEntry.getPropertyName().indexOf(47) >= 0) {
                        log.warn("cannot sort on relative properties, ignoring {} clause", (Object)orderEntry);
                        continue;
                    }
                    sortingField = SolrUtils.partialEscape(SolrUtils.getSortingField(orderEntry.getPropertyType().tag(), orderEntry.getPropertyName())).toString();
                }
                solrQuery.addOrUpdateSort(sortingField, order);
            }
        }
        if ((propertyRestrictions = filter.getPropertyRestrictions()) != null && !propertyRestrictions.isEmpty()) {
            for (Filter.PropertyRestriction pr : propertyRestrictions) {
                if (pr.isNullRestriction()) continue;
                if ("rep:facet".equals(pr.propertyName)) {
                    solrQuery.setFacetMinCount(1);
                    solrQuery.setFacet(true);
                    String value = pr.first.getValue(Type.STRING);
                    solrQuery.addFacetField(value.substring("rep:facet".length() + 1, value.length() - 1) + "_facet");
                }
                if ("native*solr".equals(pr.propertyName) || "native*lucene".equals(pr.propertyName)) {
                    String nativeQueryString = String.valueOf(pr.first.getValue(pr.first.getType()));
                    if (FilterQueryParser.isSupportedHttpRequest(nativeQueryString)) {
                        String requestHandlerString = nativeQueryString.substring(0, nativeQueryString.indexOf(63));
                        if (!"select".equals(requestHandlerString)) {
                            if (requestHandlerString.charAt(0) != '/') {
                                requestHandlerString = "/" + requestHandlerString;
                            }
                            solrQuery.setRequestHandler(requestHandlerString);
                        }
                        String parameterString = nativeQueryString.substring(nativeQueryString.indexOf(63) + 1);
                        for (String param : parameterString.split("&")) {
                            String[] kv = param.split("=");
                            if (kv.length != 2) {
                                throw new RuntimeException("Unparsable native HTTP Solr query");
                            }
                            if ("/mlt".equals(requestHandlerString)) {
                                if ("stream.body".equals(kv[0])) {
                                    kv[0] = "q";
                                    String mltFlString = "mlt.fl=";
                                    int mltFlIndex = parameterString.indexOf(mltFlString);
                                    if (mltFlIndex > -1) {
                                        int beginIndex = mltFlIndex + mltFlString.length();
                                        int endIndex = parameterString.indexOf(38, beginIndex);
                                        String fields = endIndex > beginIndex ? parameterString.substring(beginIndex, endIndex) : parameterString.substring(beginIndex);
                                        kv[1] = "_query_:\"{!dismax qf=" + fields + " q.op=OR}" + kv[1] + "\"";
                                    }
                                }
                                if ("mlt.fl".equals(kv[0]) && ":path".equals(kv[1])) {
                                    kv[1] = configuration.getCatchAllField();
                                }
                            }
                            if ("/spellcheck".equals(requestHandlerString)) {
                                if ("term".equals(kv[0])) {
                                    kv[0] = "spellcheck.q";
                                }
                                solrQuery.setParam("spellcheck", true);
                            }
                            if ("/suggest".equals(requestHandlerString)) {
                                if ("term".equals(kv[0])) {
                                    kv[0] = "suggest.q";
                                }
                                solrQuery.setParam("suggest", true);
                            }
                            solrQuery.setParam(kv[0], kv[1]);
                        }
                        return solrQuery;
                    }
                    queryBuilder.append(nativeQueryString);
                } else {
                    String prField;
                    CharSequence fieldName;
                    if (SolrQueryIndex.isIgnoredProperty(pr, configuration)) continue;
                    String first = null;
                    if (pr.first != null) {
                        first = SolrUtils.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType()))).toString();
                    }
                    String last = null;
                    if (pr.last != null) {
                        last = SolrUtils.partialEscape(String.valueOf(pr.last.getValue(pr.last.getType()))).toString();
                    }
                    if ("jcr\\:path".equals((fieldName = SolrUtils.partialEscape((prField = configuration.getFieldForPropertyRestriction(pr)) != null ? prField : pr.propertyName)).toString())) {
                        queryBuilder.append(configuration.getPathField());
                        queryBuilder.append(':');
                        queryBuilder.append(first);
                    } else if (pr.first != null && pr.last != null && pr.first.equals(pr.last)) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(first);
                    } else if (pr.first == null && pr.last == null) {
                        if (!queryBuilder.toString().contains(fieldName + ":")) {
                            queryBuilder.append(fieldName).append(':');
                            queryBuilder.append('*');
                        }
                    } else if (pr.first != null && pr.last == null || pr.last != null && pr.first == null || !pr.first.equals(pr.last)) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(FilterQueryParser.createRangeQuery(first, last, pr.firstIncluding, pr.lastIncluding));
                    } else if (pr.isLike) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(SolrUtils.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType())).replace('%', '*').replace('_', '?')));
                    } else {
                        throw new RuntimeException("[unexpected!] not handled case");
                    }
                }
                queryBuilder.append(" ");
            }
        }
        if (configuration.useForPrimaryTypes()) {
            String[] pts = filter.getPrimaryTypes().toArray(new String[filter.getPrimaryTypes().size()]);
            StringBuilder ptQueryBuilder = new StringBuilder();
            for (int i = 0; i < pts.length; ++i) {
                String pt = pts[i];
                if (i == 0) {
                    ptQueryBuilder.append("(");
                }
                if (i > 0 && i < pts.length) {
                    ptQueryBuilder.append("OR ");
                }
                ptQueryBuilder.append("jcr\\:primaryType").append(':').append(SolrUtils.partialEscape(pt)).append(" ");
                if (i != pts.length - 1) continue;
                ptQueryBuilder.append(")");
                ptQueryBuilder.append(' ');
            }
            solrQuery.addFilterQuery(ptQueryBuilder.toString());
        }
        if (filter.getQueryStatement() != null && filter.getQueryStatement().contains("rep:excerpt") && !solrQuery.getHighlight()) {
            solrQuery.setHighlight(true);
            solrQuery.set("hl.fl", "*");
            solrQuery.set("hl.encoder", "html");
            solrQuery.set("hl.mergeContiguous", true);
            solrQuery.setHighlightSimplePre("<strong>");
            solrQuery.setHighlightSimplePost("</strong>");
        }
        if (configuration.useForPathRestrictions() && (pathRestriction = filter.getPathRestriction()) != null) {
            String path = FilterQueryParser.purgePath(filter, plan.getPathPrefix());
            String fieldName = configuration.getFieldForPathRestriction(pathRestriction);
            if (fieldName != null) {
                if (pathRestriction.equals((Object)Filter.PathRestriction.ALL_CHILDREN)) {
                    solrQuery.addFilterQuery(fieldName + ':' + path);
                } else {
                    queryBuilder.append(fieldName);
                    queryBuilder.append(':');
                    queryBuilder.append(path);
                }
            }
        }
        if (configuration.collapseJcrContentNodes()) {
            solrQuery.addFilterQuery("{!collapse field=" + configuration.getCollapsedPathField() + " min=" + configuration.getPathDepthField() + " hint=top_fc nullPolicy=expand}");
        }
        if (queryBuilder.length() == 0) {
            queryBuilder.append("*:*");
        }
        String escapedQuery = queryBuilder.toString();
        solrQuery.setQuery(escapedQuery);
        if (log.isDebugEnabled()) {
            log.debug("JCR query {} has been converted to Solr query {}", (Object)filter.getQueryStatement(), (Object)solrQuery.toString());
        }
        return solrQuery;
    }

    private static String parseFullTextExpression(FullTextExpression ft, final OakSolrConfiguration configuration) {
        final StringBuilder fullTextString = new StringBuilder();
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextOr or) {
                fullTextString.append('(');
                for (int i = 0; i < or.list.size(); ++i) {
                    if (i > 0 && i < or.list.size()) {
                        fullTextString.append(" OR ");
                    }
                    FullTextExpression e = or.list.get(i);
                    String orTerm = FilterQueryParser.parseFullTextExpression(e, configuration);
                    fullTextString.append(orTerm);
                }
                fullTextString.append(')');
                fullTextString.append(' ');
                return true;
            }

            @Override
            public boolean visit(FullTextContains contains) {
                return contains.getBase().accept(this);
            }

            @Override
            public boolean visit(FullTextAnd and) {
                fullTextString.append('(');
                for (int i = 0; i < and.list.size(); ++i) {
                    if (i > 0 && i < and.list.size()) {
                        fullTextString.append(" AND ");
                    }
                    FullTextExpression e = and.list.get(i);
                    String andTerm = FilterQueryParser.parseFullTextExpression(e, configuration);
                    fullTextString.append(andTerm);
                }
                fullTextString.append(')');
                fullTextString.append(' ');
                return true;
            }

            @Override
            public boolean visit(FullTextTerm term) {
                String boost;
                String p;
                if (term.isNot()) {
                    fullTextString.append('-');
                }
                if ((p = term.getPropertyName()) != null && p.indexOf(47) >= 0) {
                    p = PathUtils.getName(p);
                }
                if (p == null || "*".equals(p)) {
                    p = configuration.getCatchAllField();
                }
                fullTextString.append(SolrUtils.partialEscape(p));
                fullTextString.append(':');
                String termText = term.getText();
                if (termText.indexOf(32) > 0) {
                    fullTextString.append('\"');
                }
                fullTextString.append(termText.replace("/", "\\/").replace(":", "\\:"));
                if (termText.indexOf(32) > 0) {
                    fullTextString.append('\"');
                }
                if ((boost = term.getBoost()) != null) {
                    fullTextString.append('^');
                    fullTextString.append(boost);
                }
                fullTextString.append(' ');
                return true;
            }
        });
        return fullTextString.toString();
    }

    private static boolean isSupportedHttpRequest(String nativeQueryString) {
        return nativeQueryString.matches("(suggest|spellcheck|mlt|query|select|get)\\\\?.*");
    }

    private static void setDefaults(SolrQuery solrQuery, OakSolrConfiguration configuration) {
        solrQuery.setParam("q.op", "AND");
        solrQuery.setParam("fl", configuration.getPathField() + " score");
        String catchAllField = configuration.getCatchAllField();
        if (catchAllField != null && catchAllField.length() > 0) {
            solrQuery.setParam("df", catchAllField);
        }
        solrQuery.setParam("rows", String.valueOf(configuration.getRows()));
    }

    private static String createRangeQuery(String first, String last, boolean firstIncluding, boolean lastIncluding) {
        return "[" + (first != null ? first : "*") + " TO " + (last != null ? last : "*") + "]";
    }

    private static String purgePath(Filter filter, String pathPrefix) {
        String path = filter.getPath();
        if (pathPrefix != null && pathPrefix.length() > 1 && path.startsWith(pathPrefix) && (path = path.substring(pathPrefix.length())).length() == 0) {
            path = "/";
        }
        return SolrUtils.partialEscape(path).toString();
    }
}

