/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.util.SolrIndexInitializer;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class SolrIndexLookup {
    private final NodeState root;

    public SolrIndexLookup(NodeState root) {
        this.root = root;
    }

    public Collection<String> collectIndexNodePaths(Filter filter) {
        return this.collectIndexNodePaths(filter, true);
    }

    private Collection<String> collectIndexNodePaths(Filter filter, boolean recurse) {
        HashSet<String> paths = Sets.newHashSet();
        SolrIndexLookup.collectIndexNodePaths(this.root, "/", paths);
        if (recurse) {
            StringBuilder sb = new StringBuilder();
            NodeState nodeState = this.root;
            for (String element : PathUtils.elements(filter.getPath())) {
                nodeState = nodeState.getChildNode(element);
                SolrIndexLookup.collectIndexNodePaths(nodeState, sb.append("/").append(element).toString(), paths);
            }
        }
        return paths;
    }

    private static void collectIndexNodePaths(NodeState nodeState, String parentPath, Collection<String> paths) {
        NodeState state = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            if (!SolrIndexInitializer.isSolrIndexNode(childNodeEntry.getNodeState())) continue;
            paths.add(SolrIndexLookup.createIndexNodePath(parentPath, childNodeEntry.getName()));
        }
    }

    private static String createIndexNodePath(String parentPath, String name) {
        return PathUtils.concat(parentPath, "oak:index", name);
    }
}

