/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedSolrServerProvider
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EmbeddedSolrServerConfiguration solrServerConfiguration;

    public EmbeddedSolrServerProvider(EmbeddedSolrServerConfiguration solrServerConfiguration) {
        this.solrServerConfiguration = solrServerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrServer createSolrServer() throws Exception {
        this.log.info("creating new embedded solr server with config: {}", (Object)this.solrServerConfiguration);
        String solrHomePath = this.solrServerConfiguration.getSolrHomePath();
        String coreName = this.solrServerConfiguration.getCoreName();
        EmbeddedSolrServerConfiguration.HttpConfiguration httpConfiguration = this.solrServerConfiguration.getHttpConfiguration();
        if (solrHomePath != null && coreName != null) {
            this.checkSolrConfiguration(solrHomePath, coreName);
            if (httpConfiguration != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("starting embedded Solr server with http bindings");
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(JettySolrRunner.class.getClassLoader());
                Integer httpPort = httpConfiguration.getHttpPort();
                String context = httpConfiguration.getContext();
                JettySolrRunner jettySolrRunner = null;
                try {
                    jettySolrRunner = new JettySolrRunner(solrHomePath, context, httpPort, "solrconfig.xml", "schema.xml", true);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Jetty runner instantiated");
                    }
                    jettySolrRunner.start(true);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Jetty runner started");
                    }
                }
                catch (Exception t) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("an error has occurred while starting Solr Jetty", t);
                    }
                }
                finally {
                    block30: {
                        if (jettySolrRunner != null && !jettySolrRunner.isRunning()) {
                            try {
                                jettySolrRunner.stop();
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Jetty runner stopped");
                                }
                            }
                            catch (Exception e) {
                                if (!this.log.isErrorEnabled()) break block30;
                                this.log.error("error while stopping the Jetty runner", e);
                            }
                        }
                    }
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("starting HTTP Solr server");
                }
                return new HttpWithJettySolrServer("http://127.0.0.1:" + httpPort + context + '/' + coreName, jettySolrRunner);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CoreContainer.class.getClassLoader());
            CoreContainer coreContainer = new CoreContainer(solrHomePath);
            try {
                if (!coreContainer.isLoaded(coreName)) {
                    coreContainer.load();
                }
            }
            catch (Exception e) {
                this.log.error("cannot load core {}, shutting down embedded Solr..", (Object)coreName, (Object)e);
                try {
                    coreContainer.shutdown();
                }
                catch (Exception se) {
                    this.log.error("could not shutdown embedded Solr", se);
                }
                SolrServer solrServer = null;
                return solrServer;
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            EmbeddedSolrServer server = new EmbeddedSolrServer(coreContainer, coreName);
            if (server.ping().getStatus() == 0) {
                return server;
            }
            throw new IOException("the embedded Solr server is not alive");
        }
        throw new Exception("SolrServer configuration proprties not set");
    }

    private void checkSolrConfiguration(String solrHomePath, String coreName) throws IOException {
        File solrHomePathFile = new File(solrHomePath);
        this.log.info("checking configuration at {}", (Object)solrHomePathFile.getAbsolutePath());
        if (!solrHomePathFile.exists()) {
            if (!solrHomePathFile.mkdirs()) {
                throw new IOException("could not create solrHomePath directory");
            }
            this.copy("/solr/solr.xml", solrHomePath);
            this.copy("/solr/zoo.cfg", solrHomePath);
        } else if (!solrHomePathFile.isDirectory()) {
            throw new IOException("a non directory file with the specified name already exists for the given solrHomePath '" + solrHomePath);
        }
        File solrCorePathFile = new File(solrHomePathFile, coreName);
        if (!solrCorePathFile.exists()) {
            if (!new File(solrCorePathFile, "conf").mkdirs()) {
                throw new IOException("could not create nested core directory in solrHomePath/solrCoreName/conf");
            }
            String solrCoreDir = solrCorePathFile.getAbsolutePath();
            File coreProperties = new File(new File(solrCoreDir), "core.properties");
            assert (coreProperties.createNewFile());
            FileOutputStream out = new FileOutputStream(coreProperties);
            IOUtils.writeBytes(out, ("name=" + coreName).getBytes("UTF-8"));
            out.flush();
            out.close();
            String coreConfDir = solrCoreDir + "/conf/";
            this.copy("/solr/oak/conf/currency.xml", coreConfDir);
            this.copy("/solr/oak/conf/schema.xml", coreConfDir);
            this.copy("/solr/oak/conf/solrconfig.xml", coreConfDir);
        } else if (!solrCorePathFile.isDirectory()) {
            throw new IOException("a non directory file with the specified name already exists for the given Solr core path'" + solrCorePathFile.getAbsolutePath());
        }
        File solrDataPathFile = new File(solrHomePathFile + "/" + coreName + "/data/index");
        if (solrDataPathFile.exists()) {
            this.log.debug("deleting stale lock files");
            File[] locks = solrDataPathFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "write.lock".equals(name);
                }
            });
            this.log.debug("found {} lock files", (Object)locks.length);
            if (locks.length > 0) {
                for (File f : locks) {
                    FileUtils.forceDelete(f);
                    this.log.debug("deleted {}", (Object)f.getAbsolutePath());
                }
            }
        }
        Object[] files = solrHomePathFile.list();
        Arrays.sort(files);
        if (Arrays.binarySearch(files, coreName) < 0) {
            throw new IOException("could not find a directory with the coreName '" + coreName + "' in the solrHomePath '" + solrHomePath + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String resource, String dir) throws IOException {
        String fileName = dir + resource.substring(resource.lastIndexOf("/"));
        File outputFile = new File(fileName);
        if (outputFile.createNewFile()) {
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(resource);
                outputStream = new FileOutputStream(outputFile);
                IOUtils.copy(inputStream, outputStream);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    @Override
    @CheckForNull
    public SolrServer getSolrServer() throws Exception {
        return this.createSolrServer();
    }

    @Override
    @CheckForNull
    public SolrServer getIndexingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    @Override
    @CheckForNull
    public SolrServer getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    @Override
    public void close() throws IOException {
    }

    private class HttpWithJettySolrServer
    extends HttpSolrServer {
        private final JettySolrRunner jettySolrRunner;

        public HttpWithJettySolrServer(String s, JettySolrRunner jettySolrRunner) {
            super(s);
            this.jettySolrRunner = jettySolrRunner;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            try {
                if (this.jettySolrRunner != null && this.jettySolrRunner.isRunning()) {
                    this.jettySolrRunner.stop();
                }
            }
            catch (Exception e) {
                EmbeddedSolrServerProvider.this.log.warn("could not stop JettySolrRunner {}", (Object)this.jettySolrRunner);
            }
        }
    }
}

