/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.RemoteSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSolrServerProvider
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(RemoteSolrServerProvider.class);
    private final RemoteSolrServerConfiguration remoteSolrServerConfiguration;

    public RemoteSolrServerProvider(RemoteSolrServerConfiguration remoteSolrServerConfiguration) {
        this.remoteSolrServerConfiguration = remoteSolrServerConfiguration;
    }

    @Override
    @CheckForNull
    public SolrServer getSolrServer() throws Exception {
        SolrServer solrServer = null;
        if (this.remoteSolrServerConfiguration.getSolrZkHost() != null && this.remoteSolrServerConfiguration.getSolrZkHost().length() > 0) {
            try {
                solrServer = this.initializeWithCloudSolrServer();
            }
            catch (Exception e) {
                this.log.warn("unable to initialize SolrCloud client for {}", (Object)this.remoteSolrServerConfiguration.getSolrZkHost(), (Object)e);
            }
        }
        if (solrServer == null && this.remoteSolrServerConfiguration.getSolrHttpUrls() != null && this.remoteSolrServerConfiguration.getSolrHttpUrls().length == 1 && this.remoteSolrServerConfiguration.getSolrHttpUrls()[0] != null && this.remoteSolrServerConfiguration.getSolrHttpUrls()[0].length() > 0) {
            try {
                solrServer = this.initializeWithExistingHttpServer();
            }
            catch (Exception e1) {
                this.log.warn("unable to initialize Solr HTTP client for {}", (Object)this.remoteSolrServerConfiguration.getSolrHttpUrls(), (Object)e1);
            }
        }
        if (solrServer == null) {
            throw new IOException("could not connect to any remote Solr server");
        }
        return solrServer;
    }

    @Override
    @CheckForNull
    public SolrServer getIndexingSolrServer() throws Exception {
        SolrServer server = this.getSolrServer();
        if (server instanceof HttpSolrServer) {
            String url = ((HttpSolrServer)server).getBaseURL();
            server = new ConcurrentUpdateSolrServer(url, 1000, Runtime.getRuntime().availableProcessors());
        }
        return server;
    }

    @Override
    @CheckForNull
    public SolrServer getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    private SolrServer initializeWithExistingHttpServer() throws IOException, SolrServerException {
        HttpSolrServer httpSolrServer = new HttpSolrServer(this.remoteSolrServerConfiguration.getSolrHttpUrls()[0]);
        SolrPingResponse ping = httpSolrServer.ping();
        if (ping != null && 0 == ping.getStatus()) {
            return httpSolrServer;
        }
        throw new IOException("the found HTTP Solr server is not alive");
    }

    private SolrServer initializeWithCloudSolrServer() throws IOException {
        CloudSolrServer cloudSolrServer = new CloudSolrServer(this.remoteSolrServerConfiguration.getSolrZkHost());
        cloudSolrServer.setZkConnectTimeout(100);
        if (this.connectToZK(cloudSolrServer)) {
            block10: {
                cloudSolrServer.setDefaultCollection("collection1");
                try {
                    this.createCollectionIfNeeded(cloudSolrServer);
                }
                catch (Throwable t) {
                    if (!this.log.isWarnEnabled()) break block10;
                    this.log.warn("could not create the collection on {}", (Object)this.remoteSolrServerConfiguration.getSolrZkHost(), (Object)t);
                }
            }
            cloudSolrServer.setDefaultCollection(this.remoteSolrServerConfiguration.getSolrCollection());
            for (int i = 0; i < 3; ++i) {
                try {
                    SolrPingResponse ping = cloudSolrServer.ping();
                    if (ping != null && 0 == ping.getStatus()) {
                        return cloudSolrServer;
                    }
                    throw new IOException("the found SolrCloud server is not alive");
                }
                catch (Exception e) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("server is not alive yet, wait a bit", e);
                        }
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    continue;
                }
            }
            throw new IOException("the found SolrCloud server is not alive");
        }
        throw new IOException("could not connect to Zookeeper hosted at " + this.remoteSolrServerConfiguration.getSolrZkHost());
    }

    private boolean connectToZK(CloudSolrServer cloudSolrServer) {
        boolean connected = false;
        for (int i = 0; i < 3; ++i) {
            try {
                cloudSolrServer.connect();
                connected = true;
                break;
            }
            catch (Exception e) {
                this.log.warn("could not connect to ZK", e);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        return connected;
    }

    private void createCollectionIfNeeded(CloudSolrServer cloudSolrServer) throws SolrServerException {
        String solrCollection = this.remoteSolrServerConfiguration.getSolrCollection();
        try {
            ZkStateReader zkStateReader = cloudSolrServer.getZkStateReader();
            SolrZkClient zkClient = zkStateReader.getZkClient();
            if (zkClient.isConnected() && !zkClient.exists("/configs/" + solrCollection, false).booleanValue()) {
                String solrConfDir = this.remoteSolrServerConfiguration.getSolrConfDir();
                File dir = solrConfDir != null && solrConfDir.length() > 0 ? new File(solrConfDir) : new File(this.getClass().getResource("/solr/oak/conf").getFile());
                ZkController.uploadConfigDir(zkClient, dir, solrCollection);
                UpdateRequest req = new UpdateRequest("/admin/collections");
                req.setParam("action", "CREATE");
                req.setParam("numShards", String.valueOf(this.remoteSolrServerConfiguration.getSolrShardsNo()));
                req.setParam("replicationFactor", String.valueOf(this.remoteSolrServerConfiguration.getSolrReplicationFactor()));
                req.setParam("collection.configName", solrCollection);
                req.setParam("name", solrCollection);
                cloudSolrServer.request(req);
            }
        }
        catch (Exception e) {
            this.log.warn("could not create collection {}", (Object)solrCollection);
            throw new SolrServerException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

