/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.util;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SolrIndexInitializer
implements RepositoryInitializer {
    private static final String SOLR_IDX = "solr";
    private static final String ASYNC = "async";
    private final String async;
    private final String name;
    private final boolean reindex;

    public SolrIndexInitializer() {
        this.name = SOLR_IDX;
        this.async = ASYNC;
        this.reindex = true;
    }

    public SolrIndexInitializer(String name) {
        this.name = name;
        this.async = ASYNC;
        this.reindex = true;
    }

    public SolrIndexInitializer(boolean async) {
        this.name = SOLR_IDX;
        this.async = async ? ASYNC : null;
        this.reindex = true;
    }

    public SolrIndexInitializer(boolean async, String name, boolean reindex) {
        this.name = name;
        this.async = async ? ASYNC : null;
        this.reindex = reindex;
    }

    @Override
    public void initialize(@Nonnull NodeBuilder builder) {
        NodeBuilder indexDefinitionsNode;
        if (builder.hasChildNode("oak:index") && !builder.getChildNode("oak:index").hasChildNode(SOLR_IDX) && !(indexDefinitionsNode = builder.getChildNode("oak:index")).hasChildNode(this.name)) {
            NodeBuilder solrIndexDefinitionNode = indexDefinitionsNode.child(this.name);
            solrIndexDefinitionNode.setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", SOLR_IDX).setProperty("reindex", this.reindex);
            if (this.async != null) {
                solrIndexDefinitionNode.setProperty(ASYNC, this.async);
            }
        }
    }

    public static boolean isSolrIndexNode(NodeState node) {
        return SOLR_IDX.equals(node.getString("type"));
    }
}

