/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public final class EmptyNodeState
implements NodeState {
    public static final NodeState EMPTY_NODE = new EmptyNodeState(true);
    public static final NodeState MISSING_NODE = new EmptyNodeState(false);
    private final boolean exists;

    private EmptyNodeState(boolean exists) {
        this.exists = exists;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public long getPropertyCount() {
        return 0L;
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        return false;
    }

    @Override
    @CheckForNull
    public PropertyState getProperty(@Nonnull String name) {
        return null;
    }

    @Override
    public boolean getBoolean(@Nonnull String name) {
        return false;
    }

    @Override
    public long getLong(String name) {
        return 0L;
    }

    @Override
    public String getString(String name) {
        return null;
    }

    @Override
    @Nonnull
    public Iterable<String> getStrings(@Nonnull String name) {
        return Collections.emptyList();
    }

    @Override
    @CheckForNull
    public String getName(@Nonnull String name) {
        return null;
    }

    @Override
    @Nonnull
    public Iterable<String> getNames(@Nonnull String name) {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public long getChildNodeCount(long max) {
        return 0L;
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        return false;
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) {
        AbstractNodeState.checkValidName(name);
        return MISSING_NODE;
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        return new MemoryNodeBuilder(this);
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (base != EMPTY_NODE && base.exists()) {
            for (PropertyState propertyState : base.getProperties()) {
                if (diff.propertyDeleted(propertyState)) continue;
                return false;
            }
            for (ChildNodeEntry childNodeEntry : base.getChildNodeEntries()) {
                if (diff.childNodeDeleted(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean compareAgainstEmptyState(NodeState state, NodeStateDiff diff) {
        if (state != EMPTY_NODE && state.exists()) {
            for (PropertyState propertyState : state.getProperties()) {
                if (diff.propertyAdded(propertyState)) continue;
                return false;
            }
            for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
                if (diff.childNodeAdded(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmptyState(NodeState state) {
        return state == EMPTY_NODE || state == MISSING_NODE;
    }

    public String toString() {
        if (this.exists) {
            return "{ }";
        }
        return "{N/A}";
    }

    public boolean equals(Object object) {
        if (object == EMPTY_NODE || object == MISSING_NODE) {
            return this.exists == (object == EMPTY_NODE);
        }
        if (object instanceof NodeState) {
            NodeState that = (NodeState)object;
            return that.getPropertyCount() == 0L && that.getChildNodeCount(1L) == 0L && this.exists == that.exists();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

