/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.metric;

import com.codahale.metrics.Clock;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.commons.jmx.JmxUtil;
import org.apache.jackrabbit.oak.plugins.metric.CompositeStats;
import org.apache.jackrabbit.oak.plugins.metric.CounterImpl;
import org.apache.jackrabbit.oak.plugins.metric.HistogramImpl;
import org.apache.jackrabbit.oak.plugins.metric.MeterImpl;
import org.apache.jackrabbit.oak.plugins.metric.TimerImpl;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.SimpleStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.Stats;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricStatisticsProvider
implements StatisticsProvider,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MetricStatisticsProvider.class);
    private static final String JMX_TYPE_METRICS = "Metrics";
    private final Map<String, Stats> statsRegistry = Maps.newHashMap();
    private final MetricRegistry registry;
    private final JmxReporter reporter;
    private final RepositoryStatisticsImpl repoStats;
    private final Clock.Fast clock;
    private final Clock metricsClock;

    public MetricStatisticsProvider(MBeanServer server, ScheduledExecutorService executor) {
        this.clock = new Clock.Fast(executor);
        this.metricsClock = new OakMetricClock(this.clock);
        this.registry = new MetricRegistry();
        this.repoStats = new RepositoryStatisticsImpl(executor);
        this.reporter = JmxReporter.forRegistry(this.registry).inDomain("org.apache.jackrabbit.oak").registerWith(server).createsObjectNamesWith(new OakNameFactory()).build();
        this.reporter.start();
        this.registerAverages();
    }

    static String typeToName(RepositoryStatistics.Type type) {
        return type.name();
    }

    @Override
    public void close() {
        this.clock.close();
        if (this.reporter != null) {
            this.reporter.close();
        }
    }

    @Override
    public RepositoryStatistics getStats() {
        return this.repoStats;
    }

    @Override
    public MeterStats getMeter(String name, StatsOptions options) {
        return this.getStats(name, StatsBuilder.METERS, options);
    }

    @Override
    public CounterStats getCounterStats(String name, StatsOptions options) {
        return this.getStats(name, StatsBuilder.COUNTERS, options);
    }

    @Override
    public TimerStats getTimer(String name, StatsOptions options) {
        return this.getStats(name, StatsBuilder.TIMERS, options);
    }

    @Override
    public HistogramStats getHistogram(String name, StatsOptions options) {
        return this.getStats(name, StatsBuilder.HISTOGRAMS, options);
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    RepositoryStatisticsImpl getRepoStats() {
        return this.repoStats;
    }

    private synchronized <T extends Stats> T getStats(String name, StatsBuilder<T> builder, StatsOptions options) {
        Stats stats = this.statsRegistry.get(name);
        if (stats == null) {
            stats = options.isOnlyMetricEnabled() ? builder.newMetric(this, name) : (options.isOnlyTimeSeriesEnabled() ? new SimpleStats(this.getTimerSeriesStats(name, builder), builder.getType()) : builder.newComposite(this.getTimerSeriesStats(name, builder), this, name));
            this.statsRegistry.put(name, stats);
        }
        if (builder.isInstance(stats)) {
            return (T)stats;
        }
        throw new IllegalStateException();
    }

    private AtomicLong getTimerSeriesStats(String name, StatsBuilder builder) {
        AtomicLong counter;
        RepositoryStatistics.Type enumType = RepositoryStatistics.Type.getType(name);
        if (enumType != null) {
            counter = this.repoStats.getCounter(enumType);
        } else {
            boolean resetValueEachSecond = builder != StatsBuilder.COUNTERS;
            counter = this.repoStats.getCounter(name, resetValueEachSecond);
        }
        return counter;
    }

    private void registerAverages() {
        this.registry.register(MetricStatisticsProvider.typeToName(RepositoryStatistics.Type.OBSERVATION_EVENT_AVERAGE), new AvgGauge(this.compStats(RepositoryStatistics.Type.OBSERVATION_EVENT_COUNTER, StatsBuilder.METERS).getMeter(), this.compStats(RepositoryStatistics.Type.OBSERVATION_EVENT_DURATION, StatsBuilder.TIMERS).getTimer()));
    }

    private CompositeStats compStats(RepositoryStatistics.Type type, StatsBuilder builder) {
        Object stats = this.getStats(MetricStatisticsProvider.typeToName(type), builder, StatsOptions.DEFAULT);
        return (CompositeStats)stats;
    }

    private static class OakMetricClock
    extends Clock {
        private final org.apache.jackrabbit.oak.stats.Clock clock;

        public OakMetricClock(org.apache.jackrabbit.oak.stats.Clock clock) {
            this.clock = clock;
        }

        @Override
        public long getTick() {
            return TimeUnit.NANOSECONDS.convert(this.clock.getTime(), TimeUnit.MILLISECONDS);
        }
    }

    private static class OakNameFactory
    implements ObjectNameFactory {
        private OakNameFactory() {
        }

        @Override
        public ObjectName createName(String type, String domain, String name) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("type", MetricStatisticsProvider.JMX_TYPE_METRICS);
            table.put("name", JmxUtil.quoteValueIfRequired(name));
            try {
                return new ObjectName(domain, table);
            }
            catch (MalformedObjectNameException e) {
                log.warn("Unable to register {} {}", type, name, e);
                throw new RuntimeException(e);
            }
        }
    }

    private static class AvgGauge
    extends RatioGauge {
        private final Meter meter;
        private final Timer timer;

        private AvgGauge(Meter meter, Timer timer) {
            this.meter = meter;
            this.timer = timer;
        }

        @Override
        protected RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of(this.meter.getFifteenMinuteRate(), this.timer.getFifteenMinuteRate());
        }
    }

    private static interface StatsBuilder<T extends Stats> {
        public static final StatsBuilder<CounterStats> COUNTERS = new StatsBuilder<CounterStats>(){

            @Override
            public CompositeStats newComposite(AtomicLong delegate, MetricStatisticsProvider provider, String name) {
                return new CompositeStats(delegate, provider.registry.counter(name));
            }

            @Override
            public Stats newMetric(MetricStatisticsProvider provider, String name) {
                return new CounterImpl(provider.registry.counter(name));
            }

            @Override
            public boolean isInstance(Stats metric) {
                return CounterStats.class.isInstance(metric);
            }

            @Override
            public SimpleStats.Type getType() {
                return SimpleStats.Type.COUNTER;
            }
        };
        public static final StatsBuilder<MeterStats> METERS = new StatsBuilder<MeterStats>(){

            @Override
            public CompositeStats newComposite(AtomicLong delegate, MetricStatisticsProvider provider, String name) {
                return new CompositeStats(delegate, this.getMeter(provider, name));
            }

            @Override
            public Stats newMetric(MetricStatisticsProvider provider, String name) {
                return new MeterImpl(this.getMeter(provider, name));
            }

            @Override
            public boolean isInstance(Stats metric) {
                return MeterStats.class.isInstance(metric);
            }

            @Override
            public SimpleStats.Type getType() {
                return SimpleStats.Type.METER;
            }

            private Meter getMeter(MetricStatisticsProvider provider, String name) {
                Meter meter = new Meter(provider.metricsClock);
                provider.registry.register(name, meter);
                return meter;
            }
        };
        public static final StatsBuilder<TimerStats> TIMERS = new StatsBuilder<TimerStats>(){

            @Override
            public CompositeStats newComposite(AtomicLong delegate, MetricStatisticsProvider provider, String name) {
                return new CompositeStats(delegate, provider.registry.timer(name));
            }

            @Override
            public Stats newMetric(MetricStatisticsProvider provider, String name) {
                return new TimerImpl(provider.registry.timer(name));
            }

            @Override
            public boolean isInstance(Stats metric) {
                return TimerStats.class.isInstance(metric);
            }

            @Override
            public SimpleStats.Type getType() {
                return SimpleStats.Type.TIMER;
            }
        };
        public static final StatsBuilder<HistogramStats> HISTOGRAMS = new StatsBuilder<HistogramStats>(){

            @Override
            public CompositeStats newComposite(AtomicLong delegate, MetricStatisticsProvider provider, String name) {
                return new CompositeStats(delegate, provider.registry.histogram(name));
            }

            @Override
            public Stats newMetric(MetricStatisticsProvider provider, String name) {
                return new HistogramImpl(provider.registry.histogram(name));
            }

            @Override
            public boolean isInstance(Stats metric) {
                return HistogramStats.class.isInstance(metric);
            }

            @Override
            public SimpleStats.Type getType() {
                return SimpleStats.Type.HISTOGRAM;
            }
        };

        public CompositeStats newComposite(AtomicLong var1, MetricStatisticsProvider var2, String var3);

        public Stats newMetric(MetricStatisticsProvider var1, String var2);

        public boolean isInstance(Stats var1);

        public SimpleStats.Type getType();
    }
}

