/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.List;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;

class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static final Value[] NO_VALUES = new Value[0];

    PropertyDefinitionImpl(Tree definition, NodeType type, NamePathMapper mapper) {
        super(definition, type, mapper);
    }

    public static int valueFromName(String name) {
        Type<?> type = Type.fromString(name);
        if (type.isArray()) {
            throw new IllegalStateException("unknown property type: " + name);
        }
        return type.tag();
    }

    @Override
    public int getRequiredType() {
        String string = this.getString("jcr:requiredType");
        if (string != null) {
            return PropertyDefinitionImpl.valueFromName(string);
        }
        return 0;
    }

    @Override
    public String[] getValueConstraints() {
        String[] valConstraints = this.getStrings("jcr:valueConstraints");
        if (valConstraints != null) {
            return valConstraints;
        }
        return new String[0];
    }

    @Override
    public Value[] getDefaultValues() {
        PropertyState property = this.definition.getProperty("jcr:defaultValues");
        if (property == null) {
            return null;
        }
        if (property.isArray()) {
            List<Value> values = ValueFactoryImpl.createValues(property, this.mapper);
            return values.toArray(NO_VALUES);
        }
        Value value = ValueFactoryImpl.createValue(property, this.mapper);
        return new Value[]{value};
    }

    @Override
    public boolean isMultiple() {
        return this.getBoolean("jcr:multiple");
    }

    @Override
    public String[] getAvailableQueryOperators() {
        String[] operators = this.getStrings("jcr:availableQueryOperators");
        if (operators == null) {
            operators = new String[]{"jcr.operator.equal.to", "jcr.operator.not.equal.to", "jcr.operator.greater.than", "jcr.operator.greater.than.or.equal.to", "jcr.operator.less.than", "jcr.operator.less.than.or.equal.to", "jcr.operator.like"};
        }
        return operators;
    }

    @Override
    public boolean isFullTextSearchable() {
        return this.getBoolean("jcr:isFullTextSearchable");
    }

    @Override
    public boolean isQueryOrderable() {
        return this.getBoolean("jcr:isQueryOrderable");
    }
}

