/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.observation.EventHandler;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.LoggerFactory;

public class EventGenerator {
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger(EventGenerator.class.getName() + ".perf"));
    private static final int MAX_CHANGES_PER_CONTINUATION = 10000;
    private static final int MAX_QUEUED_CONTINUATIONS = 1000;
    private final LinkedList<Continuation> continuations = Lists.newLinkedList();

    public EventGenerator() {
    }

    public EventGenerator(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull EventHandler handler) {
        this.continuations.addFirst(new Continuation(handler, before, after, 0));
    }

    public void addHandler(NodeState before, NodeState after, EventHandler handler) {
        this.continuations.addFirst(new Continuation(handler, before, after, 0));
    }

    public boolean isDone() {
        return this.continuations.isEmpty();
    }

    public void generate() {
        if (!this.continuations.isEmpty()) {
            Continuation c = this.continuations.removeFirst();
            long start = perfLogger.start("generate: Starting event generation");
            c.run();
            perfLogger.end(start, 1L, "generate: Generated {} events", (Object)c.counter);
        }
    }

    private class Continuation
    implements NodeStateDiff,
    Runnable {
        private final EventHandler handler;
        private final NodeState before;
        private final NodeState after;
        private final int skip;
        private int counter = 0;

        private Continuation(EventHandler handler, NodeState before, NodeState after, int skip) {
            this.handler = handler;
            this.before = before;
            this.after = after;
            this.skip = skip;
        }

        @Override
        public void run() {
            if (this.skip == 0) {
                this.handler.enter(this.before, this.after);
            }
            if (this.after.compareAgainstBaseState(this.before, this)) {
                this.handler.leave(this.before, this.after);
            }
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            if (this.beforeEvent()) {
                this.handler.propertyAdded(after);
                return this.afterEvent();
            }
            return true;
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            if (this.beforeEvent()) {
                if (":childOrder".equals(before.getName())) {
                    ArrayList<String> beforeNames = Lists.newArrayList(before.getValue(Type.NAMES));
                    ArrayList<String> afterNames = Lists.newArrayList(after.getValue(Type.NAMES));
                    beforeNames.retainAll(Sets.newHashSet(afterNames));
                    afterNames.retainAll(Sets.newHashSet(beforeNames));
                    for (int a = 0; a < afterNames.size() - 1; ++a) {
                        String beforeName = (String)beforeNames.get(a);
                        String afterName = (String)afterNames.get(a);
                        if (afterName.equals(beforeName)) continue;
                        int b = a + 1;
                        while (!afterName.equals(beforeNames.get(b))) {
                            ++b;
                        }
                        beforeNames.set(b, beforeName);
                        String destName = null;
                        Iterator<String> iterator = after.getValue(Type.NAMES).iterator();
                        while (destName == null && iterator.hasNext()) {
                            if (!afterName.equals(iterator.next()) || !iterator.hasNext()) continue;
                            destName = iterator.next();
                        }
                        this.handler.nodeReordered(destName, afterName, this.after.getChildNode(afterName));
                    }
                }
                this.handler.propertyChanged(before, after);
                return this.afterEvent();
            }
            return true;
        }

        @Override
        public boolean propertyDeleted(PropertyState before) {
            if (this.beforeEvent()) {
                this.handler.propertyDeleted(before);
                return this.afterEvent();
            }
            return true;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            if (this.fullQueue()) {
                return false;
            }
            if (this.beforeEvent()) {
                PropertyState sourceProperty = after.getProperty(":source-path");
                if (sourceProperty != null) {
                    String sourcePath = sourceProperty.getValue(Type.STRING);
                    this.handler.nodeMoved(sourcePath, name, after);
                }
                this.handler.nodeAdded(name, after);
                this.addChildDiff(name, EmptyNodeState.MISSING_NODE, after);
                return this.afterEvent();
            }
            return true;
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (this.fullQueue()) {
                return false;
            }
            if (this.beforeEvent()) {
                this.addChildDiff(name, before, after);
                return this.afterEvent();
            }
            return true;
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            if (this.fullQueue()) {
                return false;
            }
            if (this.beforeEvent()) {
                this.handler.nodeDeleted(name, before);
                this.addChildDiff(name, before, EmptyNodeState.MISSING_NODE);
                return this.afterEvent();
            }
            return true;
        }

        private void addChildDiff(String name, NodeState before, NodeState after) {
            EventHandler h = this.handler.getChildHandler(name, before, after);
            if (h != null) {
                EventGenerator.this.continuations.addFirst(new Continuation(h, before, after, 0));
            }
        }

        private boolean beforeEvent() {
            return ++this.counter > this.skip;
        }

        private boolean fullQueue() {
            if (this.counter > this.skip && EventGenerator.this.continuations.size() >= 1000) {
                EventGenerator.this.continuations.add(new Continuation(this.handler, this.before, this.after, this.counter));
                return true;
            }
            return false;
        }

        private boolean afterEvent() {
            if (this.counter >= this.skip + 10000) {
                EventGenerator.this.continuations.addFirst(new Continuation(this.handler, this.before, this.after, this.counter));
                return false;
            }
            return true;
        }
    }
}

