/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class FileStoreDiff {
    public static void main(String[] args) throws Exception {
        File store;
        if (args.length == 0) {
            System.out.println("java -jar oak-run-*.jar tarmkdiff <path/to/repository> [--list] [--diff=R0..R1] [--incremental] [--ignore-snfes] [--output=/path/to/output/file]");
            System.exit(0);
        }
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        NonOptionArgumentSpec<File> storeO = parser.nonOptions("Path to segment store (required)").ofType(File.class);
        ArgumentAcceptingOptionSpec<File> outO = parser.accepts("output", "Output file").withRequiredArg().ofType(File.class).defaultsTo(new File("diff_" + System.currentTimeMillis() + ".log"), (File[])new File[0]);
        OptionSpecBuilder listOnlyO = parser.accepts("list", "Lists available revisions");
        ArgumentAcceptingOptionSpec<String> intervalO = parser.accepts("diff", "Revision diff interval. Ex '--diff=R0..R1'. 'HEAD' can be used to reference the latest head revision, ie. '--diff=R0..HEAD'").withRequiredArg().ofType(String.class);
        OptionSpecBuilder incrementalO = parser.accepts("incremental", "Runs diffs between each subsequent revisions in the provided interval");
        ArgumentAcceptingOptionSpec<String> pathO = parser.accepts("path", "Filter diff by given path").withRequiredArg().ofType(String.class).defaultsTo("/", (String[])new String[0]);
        OptionSpecBuilder isgnoreSNFEsO = parser.accepts("ignore-snfes", "Ignores SegmentNotFoundExceptions and continues running the diff (experimental)");
        OptionSet options = parser.parse(args);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if ((store = (File)storeO.value(options)) == null) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        File out = (File)outO.value(options);
        if (options.has(listOnlyO)) {
            FileStoreDiff.listRevs(store, out);
        } else {
            FileStoreDiff.diff(store, (String)intervalO.value(options), options.has(incrementalO), out, (String)pathO.value(options), options.has(isgnoreSNFEsO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listRevs(File store, File out) throws IOException {
        System.out.println("Store " + store);
        System.out.println("Writing revisions to " + out);
        List<String> revs = FileStoreHelper.readRevisions(store);
        if (revs.isEmpty()) {
            System.out.println("No revisions found.");
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        try {
            for (String r : revs) {
                pw.println(r);
            }
        }
        finally {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void diff(File dir, String interval, boolean incremental, File out, String filter, boolean ignoreSNFEs) throws IOException {
        long start;
        block13: {
            System.out.println("Store " + dir);
            System.out.println("Writing diff to " + out);
            String[] tokens = interval.trim().split("\\.\\.");
            if (tokens.length != 2) {
                System.out.println("Error parsing revision interval '" + interval + "'.");
                return;
            }
            FileStore.ReadOnlyStore store = new FileStore.ReadOnlyStore(dir, FileStoreHelper.newBasicReadOnlyBlobStore());
            RecordId idL = null;
            RecordId idR = null;
            try {
                idL = tokens[0].equalsIgnoreCase("head") ? store.getHead().getRecordId() : RecordId.fromString(store.getTracker(), tokens[0]);
                idR = tokens[1].equalsIgnoreCase("head") ? store.getHead().getRecordId() : RecordId.fromString(store.getTracker(), tokens[1]);
            }
            catch (IllegalArgumentException ex) {
                System.out.println("Error parsing revision interval '" + interval + "': " + ex.getMessage());
                ex.printStackTrace();
                return;
            }
            start = System.currentTimeMillis();
            PrintWriter pw = new PrintWriter(out);
            try {
                if (incremental) {
                    List<String> revs = FileStoreHelper.readRevisions(dir);
                    System.out.println("Generating diff between " + idL + " and " + idR + " incrementally. Found " + revs.size() + " revisions.");
                    int s = revs.indexOf(idL.toString10());
                    int e = revs.indexOf(idR.toString10());
                    if (s == -1 || e == -1) {
                        System.out.println("Unable to match input revisions with FileStore.");
                        return;
                    }
                    List<String> revDiffs = revs.subList(Math.min(s, e), Math.max(s, e) + 1);
                    if (s > e) {
                        revDiffs = Lists.reverse(revDiffs);
                    }
                    if (revDiffs.size() < 2) {
                        System.out.println("Nothing to diff: " + revDiffs);
                        return;
                    }
                    Iterator<String> revDiffsIt = revDiffs.iterator();
                    RecordId idLt = RecordId.fromString(store.getTracker(), revDiffsIt.next());
                    while (revDiffsIt.hasNext()) {
                        RecordId idRt = RecordId.fromString(store.getTracker(), revDiffsIt.next());
                        boolean good = FileStoreDiff.diff(store, idLt, idRt, filter, pw);
                        idLt = idRt;
                        if (good || ignoreSNFEs) continue;
                        break block13;
                    }
                    break block13;
                }
                System.out.println("Generating diff between " + idL + " and " + idR);
                FileStoreDiff.diff(store, idL, idR, filter, pw);
            }
            finally {
                pw.close();
            }
        }
        long dur = System.currentTimeMillis() - start;
        System.out.println("Finished in " + dur + " ms.");
    }

    private static boolean diff(FileStore.ReadOnlyStore store, RecordId idL, RecordId idR, String filter, PrintWriter pw) throws IOException {
        pw.println("rev " + idL + ".." + idR);
        try {
            NodeState before = new SegmentNodeState(idL).getChildNode("root");
            NodeState after = new SegmentNodeState(idR).getChildNode("root");
            for (String name : PathUtils.elements(filter)) {
                before = before.getChildNode(name);
                after = after.getChildNode(name);
            }
            after.compareAgainstBaseState(before, new PrintingDiff(pw, filter));
            return true;
        }
        catch (SegmentNotFoundException ex) {
            System.out.println(ex.getMessage());
            pw.println("#SNFE " + ex.getSegmentId());
            return false;
        }
    }

    private static class BlobLengthF
    implements Function<Blob, String> {
        private BlobLengthF() {
        }

        @Override
        public String apply(Blob b) {
            return BlobLengthF.safeGetLength(b);
        }

        public static String safeGetLength(Blob b) {
            try {
                return FileUtils.byteCountToDisplaySize(b.length());
            }
            catch (IllegalStateException illegalStateException) {
                return "[N/A]";
            }
        }
    }

    private static final class PrintingDiff
    implements NodeStateDiff {
        private final PrintWriter pw;
        private final String path;
        private final boolean skipProps;

        public PrintingDiff(PrintWriter pw, String path) {
            this(pw, path, false);
        }

        private PrintingDiff(PrintWriter pw, String path, boolean skipProps) {
            this.pw = pw;
            this.path = path;
            this.skipProps = skipProps;
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            if (!this.skipProps) {
                this.pw.println("    + " + PrintingDiff.toString(after));
            }
            return true;
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            if (!this.skipProps) {
                this.pw.println("    ^ " + before.getName());
                this.pw.println("      - " + PrintingDiff.toString(before));
                this.pw.println("      + " + PrintingDiff.toString(after));
            }
            return true;
        }

        @Override
        public boolean propertyDeleted(PropertyState before) {
            if (!this.skipProps) {
                this.pw.println("    - " + PrintingDiff.toString(before));
            }
            return true;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            String p = PathUtils.concat(this.path, name);
            this.pw.println("+ " + p);
            return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new PrintingDiff(this.pw, p));
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            String p = PathUtils.concat(this.path, name);
            this.pw.println("^ " + p);
            return after.compareAgainstBaseState(before, new PrintingDiff(this.pw, p));
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            String p = PathUtils.concat(this.path, name);
            this.pw.println("- " + p);
            return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, new PrintingDiff(this.pw, p, true));
        }

        private static String toString(PropertyState ps) {
            StringBuilder val = new StringBuilder();
            if (ps.getType() == Type.BINARY) {
                String v = new BlobLengthF().apply(ps.getValue(Type.BINARY));
                val.append(" = {" + v + "}");
            } else if (ps.getType() == Type.BINARIES) {
                String v = Iterables.transform(ps.getValue(Type.BINARIES), new BlobLengthF()).toString();
                val.append("[" + ps.count() + "] = " + v);
            } else if (ps.isArray()) {
                val.append("[" + ps.count() + "] = ");
                val.append(ps.getValue(Type.STRINGS));
            } else {
                val.append(" = " + ps.getValue(Type.STRING));
            }
            return ps.getName() + "<" + ps.getType() + ">" + val.toString();
        }
    }
}

