/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.JournalReader;
import org.apache.jackrabbit.oak.plugins.segment.file.tooling.BasicReadOnlyBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public final class FileStoreHelper {
    public static final String newline = "\n";
    public static final boolean TAR_STORAGE_MEMORY_MAPPED = Boolean.getBoolean("tar.memoryMapped");
    public static final int TAR_SEGMENT_CACHE_SIZE = Integer.getInteger("cache", 256);

    private FileStoreHelper() {
    }

    public static SegmentVersion getSegmentVersion(FileStore fileStore) {
        return fileStore.getHead().getRecordId().getSegment().getSegmentVersion();
    }

    public static List<String> getTarFiles(FileStore store) {
        ArrayList<String> files = Lists.newArrayList();
        for (String p : store.getTarReaderIndex().keySet()) {
            files.add(new File(p).getName());
        }
        Collections.sort(files, Collections.reverseOrder());
        return files;
    }

    public static void getGcRoots(FileStore store, UUID uuidIn, Map<UUID, Set<Map.Entry<UUID, String>>> links) throws IOException {
        ArrayDeque<UUID> todos = new ArrayDeque<UUID>();
        todos.add(uuidIn);
        HashSet<UUID> visited = Sets.newHashSet();
        while (!todos.isEmpty()) {
            UUID uuid = (UUID)todos.remove();
            if (!visited.add(uuid)) continue;
            for (String f : FileStoreHelper.getTarFiles(store)) {
                Map<UUID, List<UUID>> graph = store.getTarGraph(f);
                for (Map.Entry<UUID, List<UUID>> g : graph.entrySet()) {
                    UUID uuidP;
                    if (g.getValue() == null || !g.getValue().contains(uuid) || todos.contains(uuidP = g.getKey())) continue;
                    todos.add(uuidP);
                    Set<Map.Entry<UUID, String>> deps = links.get(uuid);
                    if (deps == null) {
                        deps = Sets.newHashSet();
                        links.put(uuid, deps);
                    }
                    deps.add(new AbstractMap.SimpleImmutableEntry<UUID, String>(uuidP, f));
                }
            }
        }
    }

    public static void printGcRoots(StringBuilder sb, Map<UUID, Set<Map.Entry<UUID, String>>> links, UUID uuid, String space, String inc) {
        Set<Map.Entry<UUID, String>> roots = links.remove(uuid);
        if (roots == null || roots.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, String> r : roots) {
            sb.append(space + r.getKey() + "[" + r.getValue() + "]");
            sb.append(newline);
            FileStoreHelper.printGcRoots(sb, links, r.getKey(), space + inc, inc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readRevisions(File store) {
        File journal = new File(store, "journal.log");
        if (!journal.exists()) {
            return Lists.newArrayList();
        }
        ArrayList<String> revs = Lists.newArrayList();
        JournalReader journalReader = null;
        try {
            journalReader = new JournalReader(journal);
            try {
                revs = Lists.newArrayList(journalReader.iterator());
            }
            finally {
                journalReader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (journalReader != null) {
                    journalReader.close();
                }
            }
            catch (IOException e) {}
        }
        return revs;
    }

    public static File isValidFileStoreOrFail(File store) {
        Preconditions.checkArgument(FileStoreHelper.isValidFileStore(store), "Invalid FileStore directory " + store);
        return store;
    }

    public static boolean isValidFileStore(File store) {
        if (!store.exists()) {
            return false;
        }
        if (!store.isDirectory()) {
            return false;
        }
        for (String f : store.list()) {
            if (!"journal.log".equals(f)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkFileStoreVersionOrFail(String path, boolean force) throws IOException {
        File directory;
        block5: {
            directory = new File(path);
            if (!directory.exists()) {
                return directory;
            }
            FileStore.ReadOnlyStore store = FileStoreHelper.openReadOnlyFileStore(directory);
            try {
                SegmentVersion segmentVersion = FileStoreHelper.getSegmentVersion(store);
                if (segmentVersion == SegmentVersion.LATEST_VERSION) break block5;
                if (force) {
                    System.out.printf("Segment version mismatch. Found %s, expected %s. Forcing execution.\n", new Object[]{segmentVersion, SegmentVersion.LATEST_VERSION});
                    break block5;
                }
                throw new RuntimeException(String.format("Segment version mismatch. Found %s, expected %s. Aborting.", new Object[]{segmentVersion, SegmentVersion.LATEST_VERSION}));
            }
            finally {
                store.close();
            }
        }
        return directory;
    }

    public static FileStore openFileStore(String directory) throws IOException {
        return FileStoreHelper.openFileStore(directory, false);
    }

    public static FileStore openFileStore(String directory, boolean force) throws IOException {
        return FileStore.newFileStore(FileStoreHelper.checkFileStoreVersionOrFail(directory, force)).withCacheSize(TAR_SEGMENT_CACHE_SIZE).withMemoryMapping(TAR_STORAGE_MEMORY_MAPPED).create();
    }

    public static FileStore openFileStore(String directory, boolean force, BlobStore blobStore) throws IOException {
        return FileStore.newFileStore(FileStoreHelper.checkFileStoreVersionOrFail(directory, force)).withCacheSize(TAR_SEGMENT_CACHE_SIZE).withMemoryMapping(TAR_STORAGE_MEMORY_MAPPED).withBlobStore(blobStore).create();
    }

    public static FileStore.ReadOnlyStore openReadOnlyFileStore(File directory) throws IOException {
        return new FileStore.ReadOnlyStore(FileStoreHelper.isValidFileStoreOrFail(directory), TAR_SEGMENT_CACHE_SIZE, TAR_STORAGE_MEMORY_MAPPED);
    }

    public static FileStore.ReadOnlyStore openReadOnlyFileStore(File directory, BlobStore blobStore) throws IOException {
        return new FileStore.ReadOnlyStore(FileStoreHelper.isValidFileStoreOrFail(directory), TAR_SEGMENT_CACHE_SIZE, TAR_STORAGE_MEMORY_MAPPED, blobStore);
    }

    public static BlobStore newBasicReadOnlyBlobStore() {
        return new BasicReadOnlyBlobStore();
    }
}

