/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.RecordType;
import org.apache.jackrabbit.oak.plugins.segment.RecordUsageAnalyser;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;

public class PCMAnalyser
extends RecordUsageAnalyser {
    private final List<Deque<PCMInfo>> pcms;
    private final Set<String> errors = Sets.newHashSet();

    private static List<Deque<PCMInfo>> readPCMHistory(FileStore store) {
        ArrayList<Deque<PCMInfo>> pcms = Lists.newArrayList();
        ArrayDeque<PCMInfo> chain = Queues.newArrayDeque();
        Map<String, Set<UUID>> index = store.getTarReaderIndex();
        for (String path : index.keySet()) {
            Set<UUID> segments = index.get(path);
            String name = new File(path).getName();
            for (UUID id : segments) {
                if (!SegmentId.isDataSegmentId(id.getLeastSignificantBits())) continue;
                Segment s = PCMAnalyser.readSegment(store, id);
                for (int r = 0; r < s.getRootCount(); ++r) {
                    RecordId nodeId;
                    String v;
                    PCMInfo pcm;
                    if (s.getRootType(r) != RecordType.VALUE || (pcm = PCMAnalyser.parsePCMInfo(v = Segment.readString(nodeId = new RecordId(s.getSegmentId(), s.getRootOffset(r))), store, name)) == null) continue;
                    if (!pcm.sameMap((PCMInfo)chain.peekLast())) {
                        pcms.add(chain);
                        chain = Queues.newArrayDeque();
                    }
                    chain.addLast(pcm);
                }
            }
        }
        if (!chain.isEmpty()) {
            pcms.add(chain);
        }
        return pcms;
    }

    private static PCMInfo parsePCMInfo(String mapInfo, FileStore store, String file) {
        if (mapInfo == null || !mapInfo.startsWith("PersistedCompactionMap")) {
            return null;
        }
        SegmentTracker tracker = store.getTracker();
        int idStartIndex = mapInfo.indexOf("id=") + 3;
        int idEndIndex = mapInfo.indexOf(",", idStartIndex);
        String id = mapInfo.substring(idStartIndex, idEndIndex);
        RecordId rid = null;
        try {
            rid = RecordId.fromString(tracker, id);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        int baseStartIndex = mapInfo.indexOf("baseId=") + 7;
        String base = mapInfo.substring(baseStartIndex, mapInfo.length() - 1);
        RecordId bid = null;
        if (!"null".equals(base)) {
            try {
                bid = RecordId.fromString(tracker, base);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return new PCMInfo(rid, bid, file);
    }

    private static Segment readSegment(FileStore store, UUID id) {
        return store.readSegment(new SegmentId(store.getTracker(), id.getMostSignificantBits(), id.getLeastSignificantBits()));
    }

    public PCMAnalyser(FileStore store) {
        this.pcms = PCMAnalyser.readPCMHistory(store);
        for (Deque<PCMInfo> pcm : this.pcms) {
            try {
                this.onPCM(pcm.getFirst().getId());
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
                this.errors.add(ex.getMessage());
            }
        }
    }

    private void onPCM(RecordId recordId) {
        Segment s = recordId.getSegment();
        MapRecord map = s.readMap(recordId);
        this.parseMap(null, recordId, map);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        if (this.pcms.isEmpty()) {
            formatter.format("No persisted compaction map found.%n", new Object[0]);
        } else {
            formatter.format("Persisted compaction map info:%n", new Object[0]);
            for (Deque<PCMInfo> pcm : this.pcms) {
                formatter.format("%s%n", pcm);
            }
            formatter.format("Persisted compaction map size:%n", new Object[0]);
            sb.append(super.toString());
            formatter.format("%n", new Object[0]);
            for (String e : this.errors) {
                formatter.format("%s%n", e);
            }
        }
        return sb.toString();
    }

    private static class PCMInfo {
        private final RecordId id;
        private final RecordId baseId;
        private final String file;

        public PCMInfo(RecordId id, RecordId baseId, String file) {
            this.id = Preconditions.checkNotNull(id);
            this.baseId = baseId;
            this.file = file;
        }

        public String toString() {
            return this.id + "[" + this.file + "]";
        }

        public RecordId getId() {
            return this.id;
        }

        public RecordId getBaseId() {
            return this.baseId;
        }

        public boolean sameMap(PCMInfo o) {
            if (o == null) {
                return true;
            }
            return this.id.equals(o.getBaseId());
        }
    }
}

