/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;

public class SegmentNodeStoreBuilder {
    private final SegmentStore store;
    private boolean isCreated;
    private boolean hasCompactionStrategy;
    private boolean pauseCompaction;
    private boolean cloneBinaries;
    private String cleanup;
    private long cleanupTs;
    private byte memoryThreshold;
    private int lockWaitTime;
    private int retryCount;
    private boolean forceAfterFail;
    private boolean persistCompactionMap;
    private byte gainThreshold;
    private CompactionStrategy compactionStrategy;

    static SegmentNodeStoreBuilder newSegmentNodeStore(SegmentStore store) {
        return new SegmentNodeStoreBuilder(store);
    }

    private SegmentNodeStoreBuilder(@Nonnull SegmentStore store) {
        this.store = store;
    }

    @Deprecated
    public SegmentNodeStoreBuilder withCompactionStrategy(boolean pauseCompaction, boolean cloneBinaries, String cleanup, long cleanupTs, byte memoryThreshold, int lockWaitTime, int retryCount, boolean forceAfterFail, boolean persistCompactionMap) {
        return this.withCompactionStrategy(pauseCompaction, cloneBinaries, cleanup, cleanupTs, memoryThreshold, lockWaitTime, retryCount, forceAfterFail, persistCompactionMap, (byte)10);
    }

    public SegmentNodeStoreBuilder withCompactionStrategy(boolean pauseCompaction, boolean cloneBinaries, String cleanup, long cleanupTs, byte memoryThreshold, int lockWaitTime, int retryCount, boolean forceAfterFail, boolean persistCompactionMap, byte gainThreshold) {
        this.hasCompactionStrategy = true;
        this.pauseCompaction = pauseCompaction;
        this.cloneBinaries = cloneBinaries;
        this.cleanup = cleanup;
        this.cleanupTs = cleanupTs;
        this.memoryThreshold = memoryThreshold;
        this.lockWaitTime = lockWaitTime;
        this.retryCount = retryCount;
        this.forceAfterFail = forceAfterFail;
        this.persistCompactionMap = persistCompactionMap;
        this.gainThreshold = gainThreshold;
        return this;
    }

    public CompactionStrategy getCompactionStrategy() {
        Preconditions.checkState(this.isCreated);
        return this.compactionStrategy;
    }

    @Nonnull
    public SegmentNodeStore create() {
        Preconditions.checkState(!this.isCreated);
        this.isCreated = true;
        final SegmentNodeStore segmentStore = new SegmentNodeStore(this.store, true);
        if (this.hasCompactionStrategy) {
            this.compactionStrategy = new CompactionStrategy(this.pauseCompaction, this.cloneBinaries, CompactionStrategy.CleanupType.valueOf(this.cleanup), this.cleanupTs, this.memoryThreshold){

                @Override
                public boolean compacted(Callable<Boolean> setHead) throws Exception {
                    return segmentStore.locked(setHead, SegmentNodeStoreBuilder.this.lockWaitTime, TimeUnit.SECONDS);
                }
            };
            this.compactionStrategy.setRetryCount(this.retryCount);
            this.compactionStrategy.setForceAfterFail(this.forceAfterFail);
            this.compactionStrategy.setPersistCompactionMap(this.persistCompactionMap);
            this.compactionStrategy.setGainThreshold(this.gainThreshold);
        } else {
            this.compactionStrategy = CompactionStrategy.NO_COMPACTION;
        }
        return segmentStore;
    }
}

