/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.segment.MapEntry;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.RecordWriters;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStream;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.Template;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentWriter.class);
    static final int BLOCK_SIZE = 4096;
    private final SegmentBufferWriterPool segmentBufferWriterPool = new SegmentBufferWriterPool();
    private static final int STRING_RECORDS_CACHE_SIZE = Integer.getInteger("oak.segment.writer.stringsCacheSize", 15000);
    final Map<String, RecordId> stringCache = SegmentWriter.newItemsCache(STRING_RECORDS_CACHE_SIZE);
    private static final int TPL_RECORDS_CACHE_SIZE = Integer.getInteger("oak.segment.writer.templatesCacheSize", 3000);
    final Map<Template, RecordId> templateCache = SegmentWriter.newItemsCache(TPL_RECORDS_CACHE_SIZE);
    private final SegmentStore store;
    private final SegmentVersion version;
    private final String wid;

    private static final <T> Map<T, RecordId> newItemsCache(final int size) {
        final boolean disabled = size <= 0;
        int safeSize = size <= 0 ? 0 : (int)((double)size * 1.2);
        return new LinkedHashMap<T, RecordId>(safeSize, 0.9f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, RecordId> e) {
                return this.size() > size;
            }

            @Override
            public synchronized RecordId get(Object key) {
                if (disabled) {
                    return null;
                }
                return (RecordId)super.get(key);
            }

            @Override
            public synchronized RecordId put(T key, RecordId value) {
                if (disabled) {
                    return null;
                }
                return super.put(key, value);
            }

            @Override
            public synchronized void clear() {
                super.clear();
            }
        };
    }

    public SegmentWriter(SegmentStore store, SegmentVersion version, String wid) {
        this.store = store;
        this.version = version;
        this.wid = wid;
    }

    public void flush() throws IOException {
        this.segmentBufferWriterPool.flush();
    }

    public void dropCache() {
        this.stringCache.clear();
        this.templateCache.clear();
    }

    MapRecord writeMap(MapRecord base, Map<String, RecordId> changes) throws IOException {
        MapEntry mapEntry;
        Map.Entry<String, RecordId> change;
        RecordId value;
        if (base != null && base.isDiff()) {
            Segment segment = base.getSegment();
            RecordId key = segment.readRecordId(base.getOffset(8));
            String string = Segment.readString(key);
            if (!changes.containsKey(string)) {
                changes.put(string, segment.readRecordId(base.getOffset(8, 1)));
            }
            base = new MapRecord(segment.readRecordId(base.getOffset(8, 2)));
        }
        if (base != null && changes.size() == 1 && (value = (change = changes.entrySet().iterator().next()).getValue()) != null && (mapEntry = base.getEntry(change.getKey())) != null) {
            if (value.equals(mapEntry.getValue())) {
                return base;
            }
            return this.writeRecord(RecordWriters.newMapBranchWriter(mapEntry.getHash(), Arrays.asList(mapEntry.getKey(), value, base.getRecordId())));
        }
        ArrayList<MapEntry> entries = Lists.newArrayList();
        for (Map.Entry<String, RecordId> entry : changes.entrySet()) {
            MapEntry e;
            String key = entry.getKey();
            RecordId keyId = null;
            if (base != null && (e = base.getEntry(key)) != null) {
                keyId = e.getKey();
            }
            if (keyId == null && entry.getValue() != null) {
                keyId = this.writeString(key);
            }
            if (keyId == null) continue;
            entries.add(new MapEntry(key, keyId, entry.getValue()));
        }
        return this.writeMapBucket(base, entries, 0);
    }

    private MapRecord writeMapLeaf(int level, Collection<MapEntry> entries) throws IOException {
        Preconditions.checkNotNull(entries);
        int size = entries.size();
        Preconditions.checkElementIndex(size, MapRecord.MAX_SIZE);
        Preconditions.checkPositionIndex(level, 7);
        Preconditions.checkArgument(size != 0 || level == 7);
        return this.writeRecord(RecordWriters.newMapLeafWriter(level, entries));
    }

    private MapRecord writeMapBranch(int level, int size, MapRecord[] buckets) throws IOException {
        int bitmap = 0;
        ArrayList<RecordId> bucketIds = Lists.newArrayListWithCapacity(buckets.length);
        for (int i = 0; i < buckets.length; ++i) {
            if (buckets[i] == null) continue;
            bitmap = (int)((long)bitmap | 1L << i);
            bucketIds.add(buckets[i].getRecordId());
        }
        return this.writeRecord(RecordWriters.newMapBranchWriter(level, size, bitmap, bucketIds));
    }

    private MapRecord writeMapBucket(MapRecord base, Collection<MapEntry> entries, int level) throws IOException {
        if (entries == null || entries.isEmpty()) {
            if (base != null) {
                return base;
            }
            if (level == 0) {
                return this.writeRecord(RecordWriters.newMapLeafWriter());
            }
            return null;
        }
        if (base == null) {
            if (entries.size() <= 32 || level == 7) {
                return this.writeMapLeaf(level, entries);
            }
            MapRecord[] buckets = new MapRecord[32];
            List<List<MapEntry>> changes = SegmentWriter.splitToBuckets(entries, level);
            for (int i = 0; i < 32; ++i) {
                buckets[i] = this.writeMapBucket(null, (Collection<MapEntry>)changes.get(i), level + 1);
            }
            return this.writeMapBranch(level, entries.size(), buckets);
        }
        if (base.isLeaf()) {
            HashMap<String, MapEntry> map = Maps.newHashMap();
            for (MapEntry entry : base.getEntries()) {
                map.put(entry.getName(), entry);
            }
            for (MapEntry entry : entries) {
                if (entry.getValue() != null) {
                    map.put(entry.getName(), entry);
                    continue;
                }
                map.remove(entry.getName());
            }
            return this.writeMapBucket(null, map.values(), level);
        }
        int newSize = 0;
        int newCount = 0;
        MapRecord[] buckets = base.getBuckets();
        List<List<MapEntry>> changes = SegmentWriter.splitToBuckets(entries, level);
        for (int i = 0; i < 32; ++i) {
            buckets[i] = this.writeMapBucket(buckets[i], (Collection<MapEntry>)changes.get(i), level + 1);
            if (buckets[i] == null) continue;
            newSize += buckets[i].size();
            ++newCount;
        }
        if (newSize > 32) {
            return this.writeMapBranch(level, newSize, buckets);
        }
        if (newCount <= 1) {
            for (MapRecord bucket : buckets) {
                if (bucket == null) continue;
                return bucket;
            }
            return this.writeMapBucket(null, null, level);
        }
        ArrayList<MapEntry> list = Lists.newArrayList();
        for (MapRecord bucket : buckets) {
            if (bucket == null) continue;
            Iterables.addAll(list, bucket.getEntries());
        }
        return this.writeMapLeaf(level, list);
    }

    public RecordId writeList(List<RecordId> list) throws IOException {
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument(!list.isEmpty());
        List<RecordId> thisLevel = list;
        while (thisLevel.size() > 1) {
            ArrayList<RecordId> nextLevel = Lists.newArrayList();
            for (List<RecordId> bucket : Lists.partition(thisLevel, 255)) {
                if (bucket.size() > 1) {
                    nextLevel.add(this.writeListBucket(bucket));
                    continue;
                }
                nextLevel.add(bucket.get(0));
            }
            thisLevel = nextLevel;
        }
        return thisLevel.iterator().next();
    }

    private RecordId writeListBucket(List<RecordId> bucket) throws IOException {
        Preconditions.checkArgument(bucket.size() > 1);
        return this.writeRecord(RecordWriters.newListBucketWriter(bucket));
    }

    private static List<List<MapEntry>> splitToBuckets(Collection<MapEntry> entries, int level) {
        Object empty = null;
        int mask = 31;
        int shift = 32 - (level + 1) * 5;
        ArrayList<Object> buckets = Lists.newArrayList(Collections.nCopies(32, empty));
        for (MapEntry entry : entries) {
            int index = entry.getHash() >> shift & mask;
            ArrayList<MapEntry> bucket = (ArrayList<MapEntry>)buckets.get(index);
            if (bucket == null) {
                bucket = Lists.newArrayList();
                buckets.set(index, bucket);
            }
            bucket.add(entry);
        }
        return buckets;
    }

    private RecordId writeValueRecord(long length, RecordId blocks) throws IOException {
        long len = length - 16512L | 0xC000000000000000L;
        return this.writeRecord(RecordWriters.newValueWriter(blocks, len));
    }

    private RecordId writeValueRecord(int length, byte[] data) throws IOException {
        Preconditions.checkArgument(length < 16512);
        return this.writeRecord(RecordWriters.newValueWriter(length, data));
    }

    public RecordId writeString(String string) throws IOException {
        RecordId id = this.stringCache.get(string);
        if (id != null) {
            return id;
        }
        byte[] data = string.getBytes(Charsets.UTF_8);
        if (data.length < 16512) {
            id = this.writeValueRecord(data.length, data);
            this.stringCache.put(string, id);
            return id;
        }
        int pos = 0;
        ArrayList<RecordId> blockIds = Lists.newArrayListWithExpectedSize(data.length / 4096 + 1);
        while (pos + 262144 <= data.length) {
            SegmentId bulkId = this.store.getTracker().newBulkSegmentId();
            this.store.writeSegment(bulkId, data, pos, 262144);
            for (int i = 0; i < 262144; i += 4096) {
                blockIds.add(new RecordId(bulkId, i));
            }
            pos += 262144;
        }
        while (pos < data.length) {
            int len = Math.min(4096, data.length - pos);
            blockIds.add(this.writeBlock(data, pos, len));
            pos += len;
        }
        return this.writeValueRecord((long)data.length, this.writeList(blockIds));
    }

    public SegmentBlob writeBlob(Blob blob) throws IOException {
        if (blob instanceof SegmentBlob && this.store.containsSegment(((SegmentBlob)blob).getRecordId().getSegmentId())) {
            return (SegmentBlob)blob;
        }
        String reference = blob.getReference();
        if (reference != null && this.store.getBlobStore() != null) {
            String blobId = this.store.getBlobStore().getBlobId(reference);
            if (blobId != null) {
                RecordId id = this.writeBlobId(blobId);
                return new SegmentBlob(id);
            }
            LOG.debug("No blob found for reference {}, inlining...", (Object)reference);
        }
        return this.writeStream(blob.getNewStream());
    }

    private RecordId writeBlobId(String blobId) throws IOException {
        byte[] data = blobId.getBytes(Charsets.UTF_8);
        if (data.length < 4096) {
            return this.writeRecord(RecordWriters.newBlobIdWriter(data));
        }
        return this.writeRecord(RecordWriters.newBlobIdWriter(this.writeString(blobId)));
    }

    RecordId writeBlock(byte[] bytes, int offset, int length) throws IOException {
        Preconditions.checkNotNull(bytes);
        Preconditions.checkPositionIndexes(offset, offset + length, bytes.length);
        return this.writeRecord(RecordWriters.newBlockWriter(bytes, offset, length));
    }

    SegmentBlob writeExternalBlob(String blobId) throws IOException {
        RecordId id = this.writeBlobId(blobId);
        return new SegmentBlob(id);
    }

    SegmentBlob writeLargeBlob(long length, List<RecordId> list) throws IOException {
        RecordId id = this.writeValueRecord(length, this.writeList(list));
        return new SegmentBlob(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentBlob writeStream(InputStream stream) throws IOException {
        boolean threw = true;
        try {
            RecordId id = SegmentStream.getRecordIdIfAvailable(stream, this.store);
            if (id == null) {
                id = this.internalWriteStream(stream);
            }
            threw = false;
            SegmentBlob segmentBlob = new SegmentBlob(id);
            return segmentBlob;
        }
        finally {
            Closeables.close(stream, threw);
        }
    }

    private RecordId internalWriteStream(InputStream stream) throws IOException {
        BlobStore blobStore = this.store.getBlobStore();
        byte[] data = new byte[16512];
        int n = ByteStreams.read(stream, data, 0, data.length);
        if (n < 16512) {
            return this.writeValueRecord(n, data);
        }
        if (blobStore != null) {
            String blobId = blobStore.writeBlob(new SequenceInputStream(new ByteArrayInputStream(data, 0, n), stream));
            return this.writeBlobId(blobId);
        }
        data = Arrays.copyOf(data, 262144);
        n += ByteStreams.read(stream, data, n, 262144 - n);
        long length = n;
        ArrayList<RecordId> blockIds = Lists.newArrayListWithExpectedSize(2 * n / 4096);
        while (n != 0) {
            SegmentId bulkId = this.store.getTracker().newBulkSegmentId();
            int len = Segment.align(n, 4);
            LOG.debug("Writing bulk segment {} ({} bytes)", (Object)bulkId, (Object)n);
            this.store.writeSegment(bulkId, data, 0, len);
            for (int i = 0; i < n; i += 4096) {
                blockIds.add(new RecordId(bulkId, data.length - len + i));
            }
            n = ByteStreams.read(stream, data, 0, data.length);
            length += (long)n;
        }
        return this.writeValueRecord(length, this.writeList(blockIds));
    }

    public RecordId writeProperty(PropertyState state) throws IOException {
        Map<String, RecordId> previousValues = Collections.emptyMap();
        return this.writeProperty(state, previousValues);
    }

    private RecordId writeProperty(PropertyState state, Map<String, RecordId> previousValues) throws IOException {
        Type<?> type = state.getType();
        int count = state.count();
        ArrayList<RecordId> valueIds = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            if (type.tag() == 2) {
                try {
                    SegmentBlob blob = this.writeBlob(state.getValue(Type.BINARY, i));
                    valueIds.add(blob.getRecordId());
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unexpected IOException", e);
                }
            }
            String value = state.getValue(Type.STRING, i);
            RecordId valueId = previousValues.get(value);
            if (valueId == null) {
                valueId = this.writeString(value);
            }
            valueIds.add(valueId);
        }
        if (!type.isArray()) {
            return (RecordId)valueIds.iterator().next();
        }
        if (count == 0) {
            return this.writeRecord(RecordWriters.newListWriter());
        }
        return this.writeRecord(RecordWriters.newListWriter(count, this.writeList(valueIds)));
    }

    public RecordId writeTemplate(Template template) throws IOException {
        Preconditions.checkNotNull(template);
        RecordId id = this.templateCache.get(template);
        if (id != null) {
            return id;
        }
        ArrayList<RecordId> ids = Lists.newArrayList();
        int head = 0;
        RecordId primaryId = null;
        PropertyState primaryType = template.getPrimaryType();
        if (primaryType != null) {
            head |= Integer.MIN_VALUE;
            primaryId = this.writeString(primaryType.getValue(Type.NAME));
            ids.add(primaryId);
        }
        ArrayList<RecordId> mixinIds = null;
        PropertyState mixinTypes = template.getMixinTypes();
        if (mixinTypes != null) {
            head |= 0x40000000;
            mixinIds = Lists.newArrayList();
            for (String mixin : mixinTypes.getValue(Type.NAMES)) {
                mixinIds.add(this.writeString(mixin));
            }
            ids.addAll(mixinIds);
            Preconditions.checkState(mixinIds.size() < 1024);
            head |= mixinIds.size() << 18;
        }
        RecordId childNameId = null;
        String childName = template.getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            head |= 0x20000000;
        } else if (childName == "") {
            head |= 0x10000000;
        } else {
            childNameId = this.writeString(childName);
            ids.add(childNameId);
        }
        PropertyTemplate[] properties = template.getPropertyTemplates();
        RecordId[] propertyNames = new RecordId[properties.length];
        byte[] propertyTypes = new byte[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            propertyNames[i] = this.writeString(properties[i].getName());
            Type<?> type = properties[i].getType();
            propertyTypes[i] = type.isArray() ? (byte)(-type.tag()) : (byte)type.tag();
        }
        RecordId propNamesId = null;
        if (this.version.onOrAfter(SegmentVersion.V_11)) {
            if (propertyNames.length > 0) {
                propNamesId = this.writeList(Arrays.asList(propertyNames));
                ids.add(propNamesId);
            }
        } else {
            ids.addAll(Arrays.asList(propertyNames));
        }
        Preconditions.checkState(propertyNames.length < 262144);
        RecordId tid = this.writeRecord(RecordWriters.newTemplateWriter(ids, propertyNames, propertyTypes, head |= propertyNames.length, primaryId, mixinIds, childNameId, propNamesId, this.version));
        this.templateCache.put(template, tid);
        return tid;
    }

    /*
     * WARNING - void declaration
     */
    public SegmentNodeState writeNode(NodeState state) throws IOException {
        void var12_15;
        SegmentNodeState sns;
        NodeState base;
        SegmentNodeState sns2;
        if (state instanceof SegmentNodeState && ((sns2 = this.uncompact((SegmentNodeState)state)) != state || this.store.containsSegment(sns2.getRecordId().getSegmentId()))) {
            return sns2;
        }
        SegmentNodeState before = null;
        Template beforeTemplate = null;
        ModifiedNodeState after = null;
        if (state instanceof ModifiedNodeState && (base = (after = (ModifiedNodeState)state).getBaseState()) instanceof SegmentNodeState && ((sns = this.uncompact((SegmentNodeState)base)) != base || this.store.containsSegment(sns.getRecordId().getSegmentId()))) {
            before = sns;
            beforeTemplate = before.getTemplate();
        }
        Template template = new Template(state);
        RecordId templateId = before != null && template.equals(beforeTemplate) ? before.getTemplateId() : this.writeTemplate(template);
        ArrayList<RecordId> ids = Lists.newArrayList();
        ids.add(templateId);
        String childName = template.getChildName();
        if (childName == "") {
            MapRecord base2;
            Map<String, RecordId> childNodes;
            if (before != null && before.getChildNodeCount(2L) > 1L && after.getChildNodeCount(2L) > 1L) {
                MapRecord base3 = before.getChildNodeMap();
                childNodes = new ChildNodeCollectorDiff().diff(before, after);
            } else {
                base2 = null;
                childNodes = Maps.newHashMap();
                for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
                    childNodes.put(childNodeEntry.getName(), this.writeNode(childNodeEntry.getNodeState()).getRecordId());
                }
            }
            ids.add(this.writeMap(base2, childNodes).getRecordId());
        } else if (childName != Template.ZERO_CHILD_NODES) {
            ids.add(this.writeNode(state.getChildNode(template.getChildName())).getRecordId());
        }
        ArrayList<RecordId> pIds = Lists.newArrayList();
        PropertyTemplate[] arr$ = template.getPropertyTemplates();
        int len$ = arr$.length;
        boolean bl = false;
        while (var12_15 < len$) {
            PropertyTemplate pt = arr$[var12_15];
            String name = pt.getName();
            PropertyState property = state.getProperty(name);
            if (property instanceof SegmentPropertyState && this.store.containsSegment(((SegmentPropertyState)property).getRecordId().getSegmentId())) {
                pIds.add(((SegmentPropertyState)property).getRecordId());
            } else if (before == null || !this.store.containsSegment(before.getRecordId().getSegmentId())) {
                pIds.add(this.writeProperty(property));
            } else {
                PropertyTemplate bt = beforeTemplate.getPropertyTemplate(name);
                if (bt == null) {
                    pIds.add(this.writeProperty(property));
                } else {
                    SegmentPropertyState bp = beforeTemplate.getProperty(before.getRecordId(), bt.getIndex());
                    if (property.equals(bp)) {
                        pIds.add(bp.getRecordId());
                    } else if (bp.isArray() && bp.getType() != Type.BINARIES) {
                        pIds.add(this.writeProperty(property, bp.getValueRecords()));
                    } else {
                        pIds.add(this.writeProperty(property));
                    }
                }
            }
            ++var12_15;
        }
        if (!pIds.isEmpty()) {
            if (this.version.onOrAfter(SegmentVersion.V_11)) {
                ids.add(this.writeList(pIds));
            } else {
                ids.addAll(pIds);
            }
        }
        return this.writeRecord(RecordWriters.newNodeStateWriter(ids));
    }

    private SegmentNodeState uncompact(SegmentNodeState state) {
        RecordId id = this.store.getTracker().getCompactionMap().get(state.getRecordId());
        if (id != null) {
            return new SegmentNodeState(id);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T writeRecord(RecordWriters.RecordWriter<T> recordWriter) throws IOException {
        SegmentBufferWriter writer = this.segmentBufferWriterPool.borrowWriter(Thread.currentThread());
        try {
            T t = recordWriter.write(writer);
            return t;
        }
        finally {
            this.segmentBufferWriterPool.returnWriter(Thread.currentThread(), writer);
        }
    }

    private class ChildNodeCollectorDiff
    extends DefaultNodeStateDiff {
        private final Map<String, RecordId> childNodes = Maps.newHashMap();
        private IOException exception;

        private ChildNodeCollectorDiff() {
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            try {
                this.childNodes.put(name, SegmentWriter.this.writeNode(after).getRecordId());
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
            return true;
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            try {
                this.childNodes.put(name, SegmentWriter.this.writeNode(after).getRecordId());
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
            return true;
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            this.childNodes.put(name, null);
            return true;
        }

        public Map<String, RecordId> diff(SegmentNodeState before, ModifiedNodeState after) throws IOException {
            after.compareAgainstBaseState(before, this);
            if (this.exception != null) {
                throw new IOException(this.exception);
            }
            return this.childNodes;
        }
    }

    private class SegmentBufferWriterPool {
        private final Set<SegmentBufferWriter> borrowed = Sets.newHashSet();
        private final Map<Object, SegmentBufferWriter> writers = Maps.newHashMap();
        private short writerId = (short)-1;

        private SegmentBufferWriterPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ArrayList<SegmentBufferWriter> toFlush = Lists.newArrayList();
            SegmentBufferWriterPool segmentBufferWriterPool = this;
            synchronized (segmentBufferWriterPool) {
                toFlush.addAll(this.writers.values());
                this.writers.clear();
                this.borrowed.clear();
            }
            for (SegmentBufferWriter writer : toFlush) {
                writer.flush();
            }
        }

        public synchronized SegmentBufferWriter borrowWriter(Object key) throws IOException {
            SegmentBufferWriter writer = this.writers.remove(key);
            if (writer == null) {
                writer = new SegmentBufferWriter(SegmentWriter.this.store, SegmentWriter.this.version, SegmentWriter.this.wid + "." + this.getWriterId());
            }
            this.borrowed.add(writer);
            return writer;
        }

        public void returnWriter(Object key, SegmentBufferWriter writer) throws IOException {
            if (!this.tryReturn(key, writer)) {
                writer.flush();
            }
        }

        private synchronized boolean tryReturn(Object key, SegmentBufferWriter writer) {
            if (this.borrowed.remove(writer)) {
                this.writers.put(key, writer);
                return true;
            }
            return false;
        }

        private synchronized String getWriterId() {
            this.writerId = (short)(this.writerId + 1);
            if (this.writerId > 9999) {
                this.writerId = 0;
            }
            if (this.writerId < 10) {
                return "000" + this.writerId;
            }
            if (this.writerId < 100) {
                return "00" + this.writerId;
            }
            if (this.writerId < 1000) {
                return "0" + this.writerId;
            }
            return String.valueOf(this.writerId);
        }
    }
}

