/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Function;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.StringUtils;

public class StringCache {
    private final FastCache fastCache;
    private final CacheLIRS<StringCacheKey, String> cache;

    StringCache(long maxSize) {
        if (maxSize >= 0L) {
            this.fastCache = new FastCache();
            this.cache = CacheLIRS.newBuilder().module("StringCache").maximumWeight(maxSize).averageWeight(250).build();
        } else {
            this.fastCache = null;
            this.cache = CacheLIRS.newBuilder().module("StringCache").maximumSize(1L).build();
        }
    }

    @Nonnull
    public CacheStats getStats() {
        return new CacheStats(this.cache, "String Cache", null, -1L);
    }

    public String getString(long msb, long lsb, int offset, Function<Integer, String> loader) {
        int hash = StringCache.getEntryHash(msb, lsb, offset);
        if (this.fastCache == null) {
            return loader.apply(offset);
        }
        String s = this.fastCache.getString(hash, msb, lsb, offset);
        if (s != null) {
            return s;
        }
        StringCacheKey key = new StringCacheKey(hash, msb, lsb, offset);
        s = this.cache.getIfPresent(key);
        if (s == null) {
            s = loader.apply(offset);
            this.cache.put(key, s, StringCache.getMemory(s));
        }
        if (FastCache.isSmall(s)) {
            this.fastCache.addString(hash, new FastCacheEntry(hash, msb, lsb, offset, s));
        }
        return s;
    }

    public void clear() {
        if (this.fastCache != null) {
            this.cache.invalidateAll();
            this.fastCache.clear();
        }
    }

    private static int getMemory(String s) {
        int size = 168;
        size += 40;
        return size += StringUtils.estimateMemoryUsage(s);
    }

    private static int getEntryHash(long lsb, long msb, int offset) {
        int hash = (int)(msb ^ lsb) + offset;
        hash = (hash >>> 16 ^ hash) * 73244475;
        return hash >>> 16 ^ hash;
    }

    private static class FastCacheEntry {
        private final int hash;
        private final long msb;
        private final long lsb;
        private final int offset;
        private final String string;

        FastCacheEntry(int hash, long msb, long lsb, int offset, String string) {
            this.hash = hash;
            this.msb = msb;
            this.lsb = lsb;
            this.offset = offset;
            this.string = string;
        }

        boolean matches(long msb, long lsb, int offset) {
            return this.offset == offset && this.msb == msb && this.lsb == lsb;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof FastCacheEntry)) {
                return false;
            }
            FastCacheEntry o = (FastCacheEntry)other;
            return o.hash == this.hash && o.msb == this.msb && o.lsb == this.lsb && o.offset == this.offset;
        }
    }

    private static class StringCacheKey {
        private final int hash;
        private final long msb;
        private final long lsb;
        private final int offset;

        StringCacheKey(int hash, long msb, long lsb, int offset) {
            this.hash = hash;
            this.msb = msb;
            this.lsb = lsb;
            this.offset = offset;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof StringCacheKey)) {
                return false;
            }
            StringCacheKey o = (StringCacheKey)other;
            return o.hash == this.hash && o.msb == this.msb && o.lsb == this.lsb && o.offset == this.offset;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(Long.toHexString(this.msb)).append(':').append(Long.toHexString(this.lsb)).append('+').append(Integer.toHexString(this.offset));
            return buff.toString();
        }
    }

    static class FastCache {
        static final int MAX_STRING_SIZE = 128;
        private static final int CACHE_SIZE = 16384;
        private final FastCacheEntry[] cache = new FastCacheEntry[16384];

        FastCache() {
        }

        String getString(int hash, long msb, long lsb, int offset) {
            int index = hash & 0x3FFF;
            FastCacheEntry e = this.cache[index];
            if (e != null && e.matches(msb, lsb, offset)) {
                return e.string;
            }
            return null;
        }

        void clear() {
            Arrays.fill(this.cache, null);
        }

        static boolean isSmall(String s) {
            return s.length() <= 128;
        }

        void addString(int hash, FastCacheEntry entry) {
            int index = hash & 0x3FFF;
            this.cache[index] = entry;
        }
    }
}

