/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.compaction;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionStrategy.class);
    public static final boolean PAUSE_DEFAULT = true;
    public static final boolean CLONE_BINARIES_DEFAULT = false;
    public static final CleanupType CLEANUP_DEFAULT = CleanupType.CLEAN_OLD;
    public static final long TIMESTAMP_DEFAULT = 36000000L;
    public static final byte MEMORY_THRESHOLD_DEFAULT = 5;
    public static final boolean PERSIST_COMPACTION_MAP_DEFAULT = true;
    public static final byte GAIN_THRESHOLD_DEFAULT = 10;
    public static final int RETRY_COUNT_DEFAULT = 5;
    public static final boolean FORCE_AFTER_FAIL_DEFAULT = false;
    public static final CompactionStrategy NO_COMPACTION = new CompactionStrategy(true, false, CleanupType.CLEAN_NONE, 0L, 5){

        @Override
        public boolean compacted(@Nonnull Callable<Boolean> setHead) throws Exception {
            return false;
        }
    };
    private boolean paused;
    private boolean cloneBinaries;
    @Nonnull
    private CleanupType cleanupType;
    private long olderThan;
    private byte memoryThreshold = (byte)5;
    private boolean persistedCompactionMap = true;
    private int retryCount = 5;
    private boolean forceAfterFail = false;
    private long compactionStart = System.currentTimeMillis();
    private byte gainThreshold = (byte)10;
    private boolean offlineCompaction = false;

    protected CompactionStrategy(boolean paused, boolean cloneBinaries, @Nonnull CleanupType cleanupType, long olderThan, byte memoryThreshold) {
        Preconditions.checkArgument(olderThan >= 0L);
        this.paused = paused;
        this.cloneBinaries = cloneBinaries;
        this.cleanupType = Preconditions.checkNotNull(cleanupType);
        this.olderThan = olderThan;
        this.memoryThreshold = memoryThreshold;
    }

    public boolean canRemove(SegmentId id) {
        switch (this.cleanupType) {
            case CLEAN_ALL: {
                return true;
            }
            case CLEAN_NONE: {
                return false;
            }
            case CLEAN_OLD: {
                long age = this.compactionStart - id.getCreationTime();
                if (age > this.olderThan) {
                    LOG.info("TarMK released segment {} for gc. Age={}", (Object)id, (Object)age);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean cloneBinaries() {
        return this.cloneBinaries;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setCloneBinaries(boolean cloneBinaries) {
        this.cloneBinaries = cloneBinaries;
    }

    public void setCleanupType(@Nonnull CleanupType cleanupType) {
        this.cleanupType = Preconditions.checkNotNull(cleanupType);
    }

    public void setOlderThan(long olderThan) {
        Preconditions.checkArgument(olderThan >= 0L);
        this.olderThan = olderThan;
    }

    String getCleanupType() {
        return this.cleanupType.toString();
    }

    long getOlderThan() {
        return this.olderThan;
    }

    public String toString() {
        return "CompactionStrategy{paused=" + this.paused + ", cloneBinaries=" + this.cloneBinaries + ", cleanupType=" + (Object)((Object)this.cleanupType) + ", olderThan=" + this.olderThan + ", memoryThreshold=" + this.memoryThreshold + ", persistedCompactionMap=" + this.persistedCompactionMap + ", retryCount=" + this.retryCount + ", forceAfterFail=" + this.forceAfterFail + ", compactionStart=" + this.compactionStart + ", offlineCompaction=" + this.offlineCompaction + '}';
    }

    public void setCompactionStart(long ms) {
        this.compactionStart = ms;
    }

    public byte getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(byte memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public boolean getPersistCompactionMap() {
        return this.persistedCompactionMap;
    }

    public void setPersistCompactionMap(boolean persist) {
        this.persistedCompactionMap = persist;
    }

    public boolean getForceAfterFail() {
        return this.forceAfterFail;
    }

    public void setForceAfterFail(boolean forceAfterFail) {
        this.forceAfterFail = forceAfterFail;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public byte getGainThreshold() {
        return this.gainThreshold;
    }

    public void setGainThreshold(byte gainThreshold) {
        this.gainThreshold = gainThreshold;
    }

    public abstract boolean compacted(@Nonnull Callable<Boolean> var1) throws Exception;

    public boolean isOfflineCompaction() {
        return this.offlineCompaction;
    }

    public void setOfflineCompaction(boolean offlineCompaction) {
        this.offlineCompaction = offlineCompaction;
    }

    public boolean isDiskSpaceSufficient(long repositoryDiskSpace, long availableDiskSpace) {
        return (double)availableDiskSpace > 0.25 * (double)repositoryDiskSpace;
    }

    public static enum CleanupType {
        CLEAN_ALL,
        CLEAN_NONE,
        CLEAN_OLD;

    }
}

