/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.AbstractOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.RecordType;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.plugins.segment.file.TarReader;
import org.apache.jackrabbit.oak.plugins.segment.memory.MemoryStore;

public class FileStoreRevisionRecovery {
    private static Set<String> ROOT_NAMES = ImmutableSet.of("root", "checkpoints");

    public static void main(String[] args) throws Exception {
        SegmentVersion version;
        File store;
        if (args.length == 0) {
            System.out.println("java -jar oak-run-*.jar tarmkrecovery <path/to/repository> [--version-v10]");
            System.exit(0);
        }
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        NonOptionArgumentSpec<File> storeO = parser.nonOptions("Path to segment store (required)").ofType(File.class);
        OptionSpecBuilder v10 = parser.accepts("version-v10", "Use V10 for reading");
        OptionSet options = parser.parse(args);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if ((store = (File)storeO.value(options)) == null) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if (options.has(v10)) {
            version = SegmentVersion.V_10;
            System.out.println("Store(V10) " + store);
        } else {
            version = SegmentVersion.V_11;
            System.out.println("Store " + store);
        }
        SortedMap<String, UUID> candidates = FileStoreRevisionRecovery.candidateSegments(store);
        SortedMap<String, String> roots = FileStoreRevisionRecovery.extractRoots(store, candidates, version);
        for (Map.Entry<String, String> r : roots.entrySet()) {
            System.out.println(r.getValue());
        }
    }

    private static SortedMap<String, String> extractRoots(File dir, SortedMap<String, UUID> candidates, final SegmentVersion version) throws IOException {
        FileStore.ReadOnlyStore store = new FileStore.ReadOnlyStore(dir){

            @Override
            public SegmentVersion getVersion() {
                return version;
            }
        };
        TreeMap<String, String> roots = Maps.newTreeMap(Collections.reverseOrder());
        for (Map.Entry<String, UUID> c : candidates.entrySet()) {
            UUID uid = c.getValue();
            SegmentId id = new SegmentId(store.getTracker(), uid.getMostSignificantBits(), uid.getLeastSignificantBits());
            try {
                Segment s = store.readSegment(id);
                for (int r = 0; r < s.getRootCount(); ++r) {
                    if (s.getRootType(r) != RecordType.NODE) continue;
                    int offset = s.getRootOffset(r);
                    RecordId nodeId = new RecordId(s.getSegmentId(), offset);
                    if (!FileStoreRevisionRecovery.isRoot(nodeId)) continue;
                    roots.put(c.getKey() + "." + offset, nodeId.toString10());
                }
            }
            catch (SegmentNotFoundException ex) {
                System.out.println(ex.getMessage());
            }
        }
        return roots;
    }

    private static boolean isRoot(RecordId nodeId) {
        SegmentNodeState sns = new SegmentNodeState(nodeId);
        ImmutableSet<String> childNames = ImmutableSet.copyOf(sns.getChildNodeNames());
        return sns.getPropertyCount() == 0L && childNames.size() == 2 && Sets.difference(ROOT_NAMES, childNames).isEmpty();
    }

    private static SortedMap<String, UUID> candidateSegments(File store) throws IOException {
        List<String> revs = FileStoreHelper.readRevisions(store);
        if (revs.isEmpty()) {
            System.out.println("No revisions found.");
            return Maps.newTreeMap();
        }
        String head = revs.iterator().next();
        System.out.println("Current head revision " + head);
        final UUID headSegment = FileStoreRevisionRecovery.extractSegmentId(head);
        List<String> tars = FileStoreRevisionRecovery.listTars(store);
        final TreeMap<String, UUID> candidates = Maps.newTreeMap(Collections.reverseOrder());
        for (final String tar : tars) {
            final AtomicLong threshold = new AtomicLong(-1L);
            TarReader r = TarReader.open(new File(store, tar), true);
            r.accept(new TarEntryVisitor(){

                @Override
                public void visit(long msb, long lsb, File file, int offset, int size) {
                    if (msb == headSegment.getMostSignificantBits() && lsb == headSegment.getLeastSignificantBits()) {
                        threshold.set(offset);
                    }
                }
            });
            r.accept(new TarEntryVisitor(){

                @Override
                public void visit(long msb, long lsb, File file, int offset, int size) {
                    if ((long)offset >= threshold.get() && SegmentId.isDataSegmentId(lsb)) {
                        candidates.put(tar + "." + offset, new UUID(msb, lsb));
                    }
                }
            });
            if (threshold.get() < 0L) continue;
            break;
        }
        return candidates;
    }

    private static UUID extractSegmentId(String record) throws IOException {
        RecordId head = RecordId.fromString(new MemoryStore().getTracker(), record);
        return UUID.fromString(head.getSegmentId().toString());
    }

    private static List<String> listTars(File store) {
        List<String> files = Arrays.asList(store.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".tar");
            }
        }));
        Collections.sort(files, Collections.reverseOrder());
        return files;
    }
}

