/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.compression.SnappyFramedDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.net.ssl.SSLException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.client.StandbyClientHandler;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.RecordIdDecoder;
import org.apache.jackrabbit.oak.plugins.segment.standby.jmx.ClientStandbyStatusMBean;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.CommunicationObserver;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.StandbyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandbyClient
implements ClientStandbyStatusMBean,
Runnable,
Closeable {
    public static final String CLIENT_ID_PROPERTY_NAME = "standbyID";
    private static final Logger log = LoggerFactory.getLogger(StandbyClient.class);
    private final String host;
    private final int port;
    private final int readTimeoutMs;
    private final boolean autoClean;
    private final StandbyStore store;
    private final CommunicationObserver observer;
    private StandbyClientHandler handler;
    private EventLoopGroup group;
    private EventExecutorGroup executor;
    private SslContext sslContext;
    private boolean active = false;
    private int failedRequests = 0;
    private long lastSuccessfulRequest = -1L;
    private volatile String state = "initializing";
    private final Object sync = new Object();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private long syncStartTimestamp = -1L;
    private long syncEndTimestamp = -1L;

    public StandbyClient(String host, int port, SegmentStore store, boolean secure, int readTimeoutMs, boolean autoClean) throws SSLException {
        this.host = host;
        this.port = port;
        if (secure) {
            this.sslContext = SslContext.newClientContext(InsecureTrustManagerFactory.INSTANCE);
        }
        this.readTimeoutMs = readTimeoutMs;
        this.autoClean = autoClean;
        this.store = new StandbyStore(store);
        String s = System.getProperty(CLIENT_ID_PROPERTY_NAME);
        this.observer = new CommunicationObserver(s == null || s.length() == 0 ? UUID.randomUUID().toString() : s);
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.registerMBean(new StandardMBean(this, ClientStandbyStatusMBean.class), new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can register standby status mbean", e);
        }
    }

    public String getMBeanName() {
        return "org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=\"" + this.observer.getID() + "\"";
    }

    @Override
    public void close() {
        this.stop();
        this.state = "closing";
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can unregister standby status mbean", e);
        }
        this.observer.unregister();
        this.shutdownNetty();
        this.state = "closed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Bootstrap b;
        if (!this.isRunning()) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.active) {
                return;
            }
            this.state = "starting";
            this.executor = new DefaultEventExecutorGroup(4);
            this.handler = new StandbyClientHandler(this.store, this.observer, this.running, this.readTimeoutMs, this.autoClean);
            this.group = new NioEventLoopGroup();
            b = new Bootstrap();
            b.group(this.group);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.readTimeoutMs);
            b.option(ChannelOption.TCP_NODELAY, true);
            b.option(ChannelOption.SO_REUSEADDR, true);
            b.option(ChannelOption.SO_KEEPALIVE, true);
            b.handler(new ChannelInitializer<SocketChannel>(){

                @Override
                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    if (StandbyClient.this.sslContext != null) {
                        p.addLast(StandbyClient.this.sslContext.newHandler(ch.alloc()));
                    }
                    p.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(StandbyClient.this.readTimeoutMs, TimeUnit.MILLISECONDS));
                    p.addLast(new StringEncoder(CharsetUtil.UTF_8));
                    p.addLast(new SnappyFramedDecoder(true));
                    p.addLast(new RecordIdDecoder(StandbyClient.this.store));
                    p.addLast(StandbyClient.this.executor, StandbyClient.this.handler);
                }
            });
            this.state = "running";
            this.active = true;
        }
        try {
            long startTimestamp = System.currentTimeMillis();
            ChannelFuture f = b.connect(this.host, this.port).sync();
            f.channel().closeFuture().sync();
            this.failedRequests = 0;
            this.syncStartTimestamp = startTimestamp;
            this.syncEndTimestamp = System.currentTimeMillis();
            this.lastSuccessfulRequest = this.syncEndTimestamp / 1000L;
        }
        catch (Exception e) {
            ++this.failedRequests;
            log.error("Failed synchronizing state.", e);
        }
        finally {
            Object object2 = this.sync;
            synchronized (object2) {
                this.active = false;
                this.shutdownNetty();
            }
        }
    }

    private void shutdownNetty() {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
        if (this.executor != null && !this.executor.isShuttingDown()) {
            this.executor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        }
        if (this.group != null && !this.group.isShuttingDown()) {
            this.group.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        }
    }

    @Override
    public String getMode() {
        return "client: " + this.observer.getID();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void start() {
        this.running.set(true);
        this.state = "running";
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.state = "stopped";
    }

    @Override
    public String getStatus() {
        return this.state;
    }

    @Override
    public int getFailedRequests() {
        return this.failedRequests;
    }

    @Override
    public int getSecondsSinceLastSuccess() {
        if (this.lastSuccessfulRequest < 0L) {
            return -1;
        }
        return (int)(System.currentTimeMillis() / 1000L - this.lastSuccessfulRequest);
    }

    @Override
    public int calcFailedRequests() {
        return this.getFailedRequests();
    }

    @Override
    public int calcSecondsSinceLastSuccess() {
        return this.getSecondsSinceLastSuccess();
    }

    @Override
    public void cleanup() {
        this.store.cleanup();
    }

    @Override
    public long getSyncStartTimestamp() {
        return this.syncStartTimestamp;
    }

    @Override
    public long getSyncEndTimestamp() {
        return this.syncEndTimestamp;
    }
}

